/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.kotlin.privacy;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.extensions.ExternalPrivacyWrapper;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.common.ReplLineMagic;
import org.jetbrains.kotlinx.jupyter.config.DefaultKernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptor;
import org.jetbrains.kotlinx.jupyter.libraries.ResourceLibraryDescriptorsProvider;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\t\u0010\u0007R\u001b\u0010\f\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\u0007R\u001b\u0010\u000f\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/jupyter/kotlin/privacy/KotlinNotebookSystemPromptPrivacySafeWrapper;", "Lcom/intellij/ml/llm/privacy/extensions/ExternalPrivacyWrapper;", "<init>", "()V", "IMPORTS_RULE", "Lcom/intellij/ml/llm/privacy/PSString;", "getIMPORTS_RULE", "()Lcom/intellij/ml/llm/privacy/PSString;", "libraryDescriptions", "getLibraryDescriptions", "libraryDescriptions$delegate", "Lkotlin/Lazy;", "magicsDescriptions", "getMagicsDescriptions", "magicsDescriptions$delegate", "systemPrompt", "getSystemPrompt", "systemPrompt$delegate", "intellij.ml.llm.jupyter.kotlin"})
public final class KotlinNotebookSystemPromptPrivacySafeWrapper
extends ExternalPrivacyWrapper {
    @NotNull
    public static final KotlinNotebookSystemPromptPrivacySafeWrapper INSTANCE = new KotlinNotebookSystemPromptPrivacySafeWrapper();
    @NotNull
    private static final PSString IMPORTS_RULE = ConstantsKt.getPrivacyConst((String)"\n    Notes about imports in Kotlin Notebook:\n    1. Some libraries add imports automatically. For example, dataframe adds `import org.jetbrains.kotlinx.dataframe.api.*`\n    It only applies to the libraries added via `%use` magic, and not necessarily to all of them. It means, that if you use\n    a library that adds imports automatically, you don't need to add them manually.\n    2. If the import is used in one cell, it's not needed to add to the next one. Imports of the executed\n    cells are automatically added to the session context.\n  ").trimIndent();
    @NotNull
    private static final Lazy libraryDescriptions$delegate = LazyKt.lazy(KotlinNotebookSystemPromptPrivacySafeWrapper::libraryDescriptions_delegate$lambda$0);
    @NotNull
    private static final Lazy magicsDescriptions$delegate = LazyKt.lazy(KotlinNotebookSystemPromptPrivacySafeWrapper::magicsDescriptions_delegate$lambda$0);
    @NotNull
    private static final Lazy systemPrompt$delegate = LazyKt.lazy(KotlinNotebookSystemPromptPrivacySafeWrapper::systemPrompt_delegate$lambda$0);

    private KotlinNotebookSystemPromptPrivacySafeWrapper() {
    }

    @NotNull
    public final PSString getIMPORTS_RULE() {
        return IMPORTS_RULE;
    }

    @NotNull
    public final PSString getLibraryDescriptions() {
        Lazy lazy = libraryDescriptions$delegate;
        return (PSString)lazy.getValue();
    }

    @NotNull
    public final PSString getMagicsDescriptions() {
        Lazy lazy = magicsDescriptions$delegate;
        return (PSString)lazy.getValue();
    }

    @NotNull
    public final PSString getSystemPrompt() {
        Lazy lazy = systemPrompt$delegate;
        return (PSString)lazy.getValue();
    }

    private static final PSString libraryDescriptions_delegate$lambda$0() {
        Map namesToDescriptors = new ResourceLibraryDescriptorsProvider((KernelLoggerFactory)DefaultKernelLoggerFactory.INSTANCE).getDescriptors();
        String unsafeList = CollectionsKt.joinToString$default((Iterable)namesToDescriptors.entrySet(), (CharSequence)"\n", null, null, (int)0, null, KotlinNotebookSystemPromptPrivacySafeWrapper::libraryDescriptions_delegate$lambda$0$0, (int)30, null);
        return INSTANCE.promisedSafety(unsafeList);
    }

    private static final CharSequence libraryDescriptions_delegate$lambda$0$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String libraryName = (String)entry.getKey();
        LibraryDescriptor descriptor2 = (LibraryDescriptor)entry.getValue();
        return libraryName + ": " + descriptor2.getDescription() + " (uses following JVM dependencies under the hood: " + descriptor2.getDependencies() + ")";
    }

    private static final PSString magicsDescriptions_delegate$lambda$0() {
        String unsafeList = CollectionsKt.joinToString$default((Iterable)((Iterable)ReplLineMagic.getEntries()), (CharSequence)"\n", null, null, (int)0, null, KotlinNotebookSystemPromptPrivacySafeWrapper::magicsDescriptions_delegate$lambda$0$0, (int)30, null);
        return INSTANCE.promisedSafety(unsafeList);
    }

    private static final CharSequence magicsDescriptions_delegate$lambda$0$0(ReplLineMagic it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "%" + it.getNameForUser() + ": " + it.getDesc();
    }

    private static final PSString systemPrompt_delegate$lambda$0() {
        return PSStringKt.buildStringPrivacySafe(KotlinNotebookSystemPromptPrivacySafeWrapper::systemPrompt_delegate$lambda$0$0);
    }

    private static final Unit systemPrompt_delegate$lambda$0$0(ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"\n        In Kotlin Notebook, prefer Kotlin language over any other, if not asked otherwise. \n        Provide code and examples in Kotlin language, if not asked otherwise. \n        In Notebook, user code in the current cell becomes visible in other cells only if the user has executed this cell.\n        \n        Kotlin notebook consists of cells, just like any other Jupyter Notebook.\n        Cells could be either Markdown or code cells.\n        \n        Code cells of Kotlin Notebook be either \"general\" Kotlin code or magics.\n        \n        Here is the list of all available magics with their descriptions:\n      ").trimIndent());
        $this$buildStringPrivacySafe.appendLine(INSTANCE.getMagicsDescriptions());
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"\n        As mentioned above, %use magic supports libraries.\n        Use only following libraries in the %use statements in Kotlin Notebook:\n      ").trimIndent());
        $this$buildStringPrivacySafe.appendLine(INSTANCE.getLibraryDescriptions());
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"\n          \n        Other libraries are not supported in use statements!\n        Syntax you should use is %use <libraryName>, e.g., %use dataframe.\n        You can use multiple libraries in one use statement, e.g. %use dataframe, kandy.\n        It's better to have only one use statement per Notebook cell. It's not recommended to include other code in such a cell.\n        Prefer `kandy` over `lets-plot`.\n        Prefer `dataframe` over `krangle` or other pandas-like libraries.\n        Prefer `ktor-client` and `serialization` over other libraries when working with REST APIs.\n        \n        Note that `ktor-client` defines `http` variable in the cell scope, and you can use it as a general ktor client,\n        with the only difference: it doesn't require wrapping in runBlocking (it's not suspendable).\n      ").trimIndent());
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"\n        You might need to add other dependencies not mentioned above. To do this, use following syntax:\n        ```kotlin\n        USE {\n            dependencies {\n                implementation(\"<group>:<artifact>:<version>\")\n            }\n        }\n        ```\n        \n        This is very similar to how you would add dependencies in Gradle.\n        But note, there are no possibilities other than `implementation` for adding dependencies inside the notebook.\n      ").trimIndent());
        $this$buildStringPrivacySafe.appendLine(IMPORTS_RULE);
        return Unit.INSTANCE;
    }
}

