/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.python.prompts;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.py.psi.JupyterPyDialect;
import com.intellij.ml.llm.codeGeneration.grazie.CgPrompt;
import com.intellij.ml.llm.codeGeneration.grazie.CompiledUserPrompt;
import com.intellij.ml.llm.codeGeneration.grazie.JupyterEditCodeCellCgPrompt;
import com.intellij.ml.llm.codeGeneration.grazie.JupyterEditMarkdownCellCgPrompt;
import com.intellij.ml.llm.codeGeneration.grazie.JupyterExplainWithMarkdownCgPrompt;
import com.intellij.ml.llm.codeGeneration.grazie.JupyterFixErrorCgPrompt;
import com.intellij.ml.llm.intentions.conversion.language.PasteConvertLanguage;
import com.intellij.ml.llm.intentions.conversion.language.PythonLang;
import com.intellij.ml.llm.jupyter.common.prompts.cg.JupyterCgPromptExamplesProvider;
import com.intellij.ml.llm.jupyter.common.prompts.cg.JupyterCgPromptsRequestProvider;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PythonLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/jupyter/python/prompts/PythonJupyterCgPromptsProvider;", "Lcom/intellij/ml/llm/jupyter/common/prompts/cg/JupyterCgPromptsRequestProvider;", "<init>", "()V", "examplesProvider", "Lcom/intellij/ml/llm/jupyter/common/prompts/cg/JupyterCgPromptExamplesProvider$PythonJupyterCgExamplesProvider;", "backendLanguage", "Lcom/intellij/ml/llm/intentions/conversion/language/PasteConvertLanguage;", "getBackendLanguage", "()Lcom/intellij/ml/llm/intentions/conversion/language/PasteConvertLanguage;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "provideExplainWithMarkdownRequest", "Lcom/intellij/ml/llm/codeGeneration/grazie/CgPrompt$JupyterRequestCgPrompt;", "snippetsData", "Lcom/intellij/ml/llm/jupyter/common/prompts/cg/JupyterCgPromptsRequestProvider$Companion$SnippetsData;", "provideEditCellRequest", "compiledUserPrompt", "Lcom/intellij/ml/llm/codeGeneration/grazie/CompiledUserPrompt;", "provideFixErrorRequest", "output", "Lcom/intellij/ml/llm/privacy/PSString;", "intellij.ml.llm.jupyter.python"})
public final class PythonJupyterCgPromptsProvider
extends JupyterCgPromptsRequestProvider {
    @NotNull
    private final JupyterCgPromptExamplesProvider.PythonJupyterCgExamplesProvider examplesProvider = new JupyterCgPromptExamplesProvider.PythonJupyterCgExamplesProvider();
    @NotNull
    private final PasteConvertLanguage backendLanguage = (PasteConvertLanguage)PythonLang.INSTANCE;

    @Override
    @NotNull
    protected PasteConvertLanguage getBackendLanguage() {
        return this.backendLanguage;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        BackedNotebookVirtualFile backedNotebookVirtualFile;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, virtualFile2)) {
            return false;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile2 = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile2);
        if (backedNotebookVirtualFile2 == null) {
            backedNotebookVirtualFile2 = backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile2);
        }
        if (backedNotebookVirtualFile2 == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getNotebook()) == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getLanguage()) == null) {
            return false;
        }
        BackedNotebookVirtualFile language = backedNotebookVirtualFile;
        return language instanceof JupyterPyDialect || language instanceof PythonLanguage;
    }

    @Override
    @NotNull
    public CgPrompt.JupyterRequestCgPrompt provideExplainWithMarkdownRequest(@NotNull JupyterCgPromptsRequestProvider.Companion.SnippetsData snippetsData) {
        Intrinsics.checkNotNullParameter((Object)snippetsData, (String)"snippetsData");
        return new JupyterExplainWithMarkdownCgPrompt(snippetsData.getPrefixNotebookTextAsSnippet(), snippetsData.getSuffixNotebookTextAsSnippet(), snippetsData.getCellTextAsSnippet(), snippetsData.getVariablesValues(), this.examplesProvider.getExampleForExplainWithMarkdown(), null, this.getBackendLanguage().getDisplayName(), 32, null);
    }

    @Override
    @NotNull
    public CgPrompt.JupyterRequestCgPrompt provideEditCellRequest(@NotNull JupyterCgPromptsRequestProvider.Companion.SnippetsData snippetsData, @NotNull CompiledUserPrompt compiledUserPrompt) {
        Intrinsics.checkNotNullParameter((Object)snippetsData, (String)"snippetsData");
        Intrinsics.checkNotNullParameter((Object)compiledUserPrompt, (String)"compiledUserPrompt");
        if (snippetsData.getCellType() == CellType.MARKDOWN) {
            return new JupyterEditMarkdownCellCgPrompt(snippetsData.getPrefixNotebookTextAsSnippet(), snippetsData.getSuffixNotebookTextAsSnippet(), snippetsData.getCellTextAsSnippet(), snippetsData.getVariablesValues(), compiledUserPrompt, this.examplesProvider.getExampleForEditMarkdownCell(), null, this.getBackendLanguage().getDisplayName(), 64, null);
        }
        return new JupyterEditCodeCellCgPrompt(snippetsData.getPrefixNotebookTextAsSnippet(), snippetsData.getSuffixNotebookTextAsSnippet(), snippetsData.getCellTextAsSnippet(), snippetsData.getVariablesValues(), compiledUserPrompt, this.examplesProvider.getExampleForEditCodeCell(), null, this.getBackendLanguage().getDisplayName(), 64, null);
    }

    @Override
    @NotNull
    public CgPrompt.JupyterRequestCgPrompt provideFixErrorRequest(@NotNull JupyterCgPromptsRequestProvider.Companion.SnippetsData snippetsData, @NotNull PSString output) {
        Intrinsics.checkNotNullParameter((Object)snippetsData, (String)"snippetsData");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return new JupyterFixErrorCgPrompt(snippetsData.getPrefixNotebookTextAsSnippet(), snippetsData.getSuffixNotebookTextAsSnippet(), snippetsData.getCellTextAsSnippet(), snippetsData.getVariablesValues(), output, this.examplesProvider.getExamplesForFixError(), null, this.getBackendLanguage().getDisplayName(), 64, null);
    }
}

