/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.python.prompts;

import com.intellij.jupyter.py.psi.JupyterPyDialect;
import com.intellij.lang.Language;
import com.intellij.ml.llm.codeGeneration.grazie.CgPrompt;
import com.intellij.ml.llm.codeGeneration.grazie.CgPromptRenderKt;
import com.intellij.ml.llm.codeGeneration.grazie.jupyter.AbstractLanguageCgPromptEnhancer;
import com.intellij.ml.llm.grazie.tasks.jupyter.common.JupyterPromptsStorage;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.promptTree.PromptBuilder;
import com.jetbrains.python.PythonLanguage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\tH\u0016J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/jupyter/python/prompts/PythonJupyterPromptEnhancer;", "Lcom/intellij/ml/llm/codeGeneration/grazie/jupyter/AbstractLanguageCgPromptEnhancer;", "<init>", "()V", "enhance", "", "Lcom/intellij/ml/llm/promptTree/PromptBuilder;", "task", "Lcom/intellij/ml/llm/codeGeneration/grazie/CgPrompt$JupyterOriginalUpdatedModification;", "Lcom/intellij/ml/llm/codeGeneration/grazie/CgPrompt$JupyterEditCellModification;", "Lcom/intellij/ml/llm/codeGeneration/grazie/CgPrompt$JupyterManyCellsModification;", "intellij.ml.llm.jupyter.python"})
public final class PythonJupyterPromptEnhancer
extends AbstractLanguageCgPromptEnhancer {
    public PythonJupyterPromptEnhancer() {
        Object[] objectArray = new Language[]{PythonLanguage.getInstance(), JupyterPyDialect.INSTANCE, null};
        super(CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    public void enhance(@NotNull PromptBuilder $this$enhance, @NotNull CgPrompt.JupyterOriginalUpdatedModification task2) {
        Intrinsics.checkNotNullParameter((Object)$this$enhance, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        PromptBuilder.appendLine$default((PromptBuilder)$this$enhance, (PSString)ConstantsKt.getPrivacyConst((String)"\n      Python-specific rules:\n      - To preview pandas dataframes, use `df` and not `df.head()`.\n      - If a package is not installed, install it by running `!pip install <package_name>` once.\n      - Keep consistency with already used libraries and avoid duplicate imports.\n      - Avoid plotting multiple figures in one cell and too many non-aggregated data points.\n      ").trimIndent(), null, (int)2, null);
    }

    @Override
    public void enhance(@NotNull PromptBuilder $this$enhance, @NotNull CgPrompt.JupyterEditCellModification task2) {
        Intrinsics.checkNotNullParameter((Object)$this$enhance, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        if (CgPromptRenderKt.isCurrentCellCode(task2)) {
            PromptBuilder.appendLine$default((PromptBuilder)$this$enhance, (PSString)ConstantsKt.getPrivacyConst((String)"\n        Always be sure a package is installed before using it (check imports).\n        If a package is not installed, install it by running `!pip install <package_name>`.\n        NEVER install packages twice.\n        Use `!pip install <package_name>` only for your new code imports (if necessary), not for existing imports.\n        Keep the existing notebook code consistent:\n        1. When a package is already imported, don't import it again.\n        2. When a certain package is already used for some task, don't use another package for the same task (e.g. for plotting).\n        To preview pandas dataframes, prefer `df` over `df.head()`.\n        Avoid plotting multiple figures in one cell. Avoid plotting too many non-aggregated data points.\n        ").trimIndent(), null, (int)2, null);
        }
        PromptBuilder.appendLine$default((PromptBuilder)$this$enhance, (PSString)ConstantsKt.getPrivacyConst((String)"*Python example:*"), null, (int)2, null);
        PromptBuilder.appendLine$default((PromptBuilder)$this$enhance, (PSString)JupyterPromptsStorage.Python.INSTANCE.getEDIT_CELL_EXAMPLE_CG(), null, (int)2, null);
    }

    @Override
    public void enhance(@NotNull PromptBuilder $this$enhance, @NotNull CgPrompt.JupyterManyCellsModification task2) {
        Intrinsics.checkNotNullParameter((Object)$this$enhance, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        PromptBuilder.appendLine$default((PromptBuilder)$this$enhance, (PSString)ConstantsKt.getPrivacyConst((String)"\n      Write only Python code snippets unless a markdown explanation is necessary.\n      Do not ask the user follow-up questions; they cannot respond.\n      If you need external libraries, ensure they are available; install missing ones with `!pip install <package>` once.\n      Keep consistency with already used libraries and imports in the notebook.\n      ").trimIndent(), null, (int)2, null);
        PromptBuilder.appendLine$default((PromptBuilder)$this$enhance, (PSString)ConstantsKt.getPrivacyConst((String)"*Python examples:*"), null, (int)2, null);
        PromptBuilder.appendLine$default((PromptBuilder)$this$enhance, (PSString)ConstantsKt.getPrivacyConst((String)"\n      Example request: Write me gcd algorithm\n      \n      ```python\n      def gcd(a, b):\n          while b:\n              a, b = b, a % b\n          return a\n      ```\n      \n      Example request: Create a plot of the 'age' distribution from an existing dataset.\n      \n      Original:\n      ```jupyter\n      import pandas as pd\n      data = pd.read_csv('people.csv')\n      ```\n      \n      ```python\n      !pip install matplotlib\n      import matplotlib.pyplot as plt\n      \n      def plot_age_distribution(df):\n          plt.figure(figsize=(10, 6))\n          plt.hist(df['age'], bins=20, color='skyblue', edgecolor='black')\n          plt.title('Age Distribution')\n          plt.xlabel('Age')\n          plt.ylabel('Frequency')\n          plt.show()\n      \n      plot_age_distribution(data)\n      ```\n      ").trimIndent(), null, (int)2, null);
    }
}

