/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client;

import com.intellij.ml.llm.mcp.client.McpBundle;
import com.intellij.ml.llm.mcp.client.McpClientRegistryException;
import com.intellij.ml.llm.mcp.client.settings.McpApplicationServerConfigurationService;
import com.intellij.ml.llm.mcp.client.settings.McpConfigurable;
import com.intellij.ml.llm.mcp.client.settings.McpConfigurationChangeSource;
import com.intellij.ml.llm.mcp.client.settings.McpConfigurationChangeType;
import com.intellij.ml.llm.mcp.client.settings.McpProjectServerConfigurationService;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommand;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfiguration;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationServiceBase;
import com.intellij.ml.llm.mcp.client.settings.McpServerURL;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0011\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J\u001e\u0010\u0012\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/mcp/client/McpSettingsChangedNotification;", "", "<init>", "()V", "NOTIFICATION_GROUP_ID", "", "NOTIFICATION_ID_SETTINGS_CHANGED", "showSettingsChangedNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "configurations", "", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfiguration;", "changeType", "Lcom/intellij/ml/llm/mcp/client/settings/McpConfigurationChangeType;", "configuration", "getDescription", "changeConfigurationsState", "newConfigurations", "ConfigurationChangeAction", "ConfigureMcpSettingsAction", "EnableExternalChangesAction", "intellij.ml.llm.mcp"})
@SourceDebugExtension(value={"SMAP\nMcpSettingsChangedNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpSettingsChangedNotification.kt\ncom/intellij/ml/llm/mcp/client/McpSettingsChangedNotification\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1761#2,3:123\n*S KotlinDebug\n*F\n+ 1 McpSettingsChangedNotification.kt\ncom/intellij/ml/llm/mcp/client/McpSettingsChangedNotification\n*L\n86#1:123,3\n*E\n"})
public final class McpSettingsChangedNotification {
    @NotNull
    public static final McpSettingsChangedNotification INSTANCE = new McpSettingsChangedNotification();
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "MCP Client";
    @NotNull
    private static final String NOTIFICATION_ID_SETTINGS_CHANGED = "mcp.client.settings.changed";

    private McpSettingsChangedNotification() {
    }

    public final void showSettingsChangedNotification(@Nullable Project project2, @NotNull Collection<? extends McpServerConfiguration> configurations, @NotNull McpConfigurationChangeType changeType) {
        String string;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(configurations, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP_ID);
        String string2 = McpBundle.message("ml.llm.mcp.settings.changed.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Object[] objectArray2 = notificationGroup.createNotification(string2, this.getDescription(configurations, changeType), NotificationType.INFORMATION).setDisplayId(NOTIFICATION_ID_SETTINGS_CHANGED);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"setDisplayId(...)");
        Object[] notification2 = objectArray2;
        boolean autoEnableExternalChanges = McpApplicationServerConfigurationService.Companion.getInstance().getAutoEnableExternalChanges();
        if (autoEnableExternalChanges) {
            objectArray = new Object[]{configurations.size()};
            string = McpBundle.message("ml.llm.mcp.settings.changed.disable", objectArray);
        } else {
            objectArray = new Object[]{configurations.size()};
            string = McpBundle.message("ml.llm.mcp.settings.changed.enable", objectArray);
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        String text2 = string3;
        objectArray = !autoEnableExternalChanges ? McpBundle.message("ml.llm.mcp.server.configurations.enable.added.modified.configurations.always", new Object[0]) : McpBundle.message("ml.llm.mcp.server.configurations.enable.added.modified.configurations.never", new Object[0]);
        Intrinsics.checkNotNull((Object)objectArray);
        Object configChangeMessage = objectArray;
        Object[] $this$showSettingsChangedNotification_u24lambda_u240 = objectArray = notification2;
        boolean bl = false;
        $this$showSettingsChangedNotification_u24lambda_u240.addAction((AnAction)new ConfigurationChangeAction(text2, project2, configurations, (Notification)notification2));
        $this$showSettingsChangedNotification_u24lambda_u240.addAction((AnAction)new EnableExternalChangesAction((Notification)notification2, (String)configChangeMessage));
        $this$showSettingsChangedNotification_u24lambda_u240.addAction((AnAction)new ConfigureMcpSettingsAction(project2, (Notification)notification2));
        objectArray.notify(project2);
    }

    public final void showSettingsChangedNotification(@Nullable Project project2, @NotNull McpServerConfiguration configuration, @NotNull McpConfigurationChangeType changeType) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
        this.showSettingsChangedNotification(project2, CollectionsKt.listOf((Object)configuration), changeType);
    }

    @NlsSafe
    private final String getDescription(Collection<? extends McpServerConfiguration> configurations, McpConfigurationChangeType changeType) {
        Object object;
        String string;
        boolean bl;
        block10: {
            Iterable $this$any$iv = configurations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    McpServerConfiguration it = (McpServerConfiguration)element$iv;
                    boolean bl2 = false;
                    if (!it.getEnabled()) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            string = "";
        } else {
            Object[] objectArray = new Object[]{configurations.size()};
            String string2 = McpBundle.message("ml.llm.mcp.settings.notification.description.disabled", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        String disabled = string;
        switch (WhenMappings.$EnumSwitchMapping$0[changeType.ordinal()]) {
            case 1: {
                Object[] objectArray = new Object[]{configurations.size(), CollectionsKt.joinToString$default((Iterable)configurations, (CharSequence)", ", null, null, (int)0, null, McpSettingsChangedNotification::getDescription$lambda$1, (int)30, null)};
                object = McpBundle.message("ml.llm.mcp.settings.added.notification.description", objectArray) + " " + disabled;
                break;
            }
            case 2: 
            case 3: {
                Object[] objectArray = new Object[]{configurations.size(), CollectionsKt.joinToString$default((Iterable)configurations, (CharSequence)", ", null, null, (int)0, null, McpSettingsChangedNotification::getDescription$lambda$2, (int)30, null)};
                object = McpBundle.message("ml.llm.mcp.settings.changed.notification.description", objectArray) + " " + disabled;
                break;
            }
            case 4: {
                Object[] objectArray = new Object[]{configurations.size(), CollectionsKt.joinToString$default((Iterable)configurations, (CharSequence)", ", null, null, (int)0, null, McpSettingsChangedNotification::getDescription$lambda$3, (int)30, null)};
                String string3 = McpBundle.message("ml.llm.mcp.settings.removed.notification.description", objectArray);
                object = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    public final void changeConfigurationsState(@Nullable Project project2, @NotNull Collection<? extends McpServerConfiguration> newConfigurations) {
        Intrinsics.checkNotNullParameter(newConfigurations, (String)"newConfigurations");
        boolean autoEnableExternalChanges = McpApplicationServerConfigurationService.Companion.getInstance().getAutoEnableExternalChanges();
        McpServerConfigurationServiceBase service = project2 == null ? (McpServerConfigurationServiceBase)McpApplicationServerConfigurationService.Companion.getInstance() : (McpServerConfigurationServiceBase)McpProjectServerConfigurationService.Companion.getInstance(project2);
        List configurations = CollectionsKt.toMutableList((Collection)service.getConfigurations());
        for (McpServerConfiguration mcpServerConfiguration : newConfigurations) {
            McpServerConfiguration mcpServerConfiguration2;
            McpServerConfiguration mcpServerConfiguration22 = mcpServerConfiguration;
            if (mcpServerConfiguration22 instanceof McpServerCommand) {
                mcpServerConfiguration2 = new McpServerCommand((McpServerCommand)mcpServerConfiguration);
            } else if (mcpServerConfiguration22 instanceof McpServerURL) {
                mcpServerConfiguration2 = new McpServerURL(mcpServerConfiguration);
            } else {
                throw new McpClientRegistryException("Unknow configuration type.");
            }
            McpServerConfiguration newConfiguration = mcpServerConfiguration2;
            newConfiguration.setEnabled(!autoEnableExternalChanges);
            configurations.set(configurations.indexOf(mcpServerConfiguration), newConfiguration);
        }
        McpServerConfigurationServiceBase.setConfigurations$default(service, configurations, CollectionsKt.emptyList(), McpConfigurationChangeSource.NOTIFICATION, false, 8, null);
    }

    private static final CharSequence getDescription$lambda$1(McpServerConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence getDescription$lambda$2(McpServerConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence getDescription$lambda$3(McpServerConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B4\u0012\u000b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/mcp/client/McpSettingsChangedNotification$ConfigurationChangeAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "text", "", "Lorg/jetbrains/annotations/Nls;", "project", "Lcom/intellij/openapi/project/Project;", "configurations", "", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfiguration;", "notification", "Lcom/intellij/notification/Notification;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lcom/intellij/notification/Notification;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.ml.llm.mcp"})
    public static final class ConfigurationChangeAction
    extends AnAction
    implements DumbAware {
        @Nullable
        private final Project project;
        @NotNull
        private final Collection<McpServerConfiguration> configurations;
        @NotNull
        private final Notification notification;

        public ConfigurationChangeAction(@NotNull String text2, @Nullable Project project2, @NotNull Collection<? extends McpServerConfiguration> configurations, @NotNull Notification notification2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(configurations, (String)"configurations");
            Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
            super(text2);
            this.project = project2;
            this.configurations = configurations;
            this.notification = notification2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            INSTANCE.changeConfigurationsState(this.project, this.configurations);
            this.notification.expire();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/mcp/client/McpSettingsChangedNotification$ConfigureMcpSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "notification", "Lcom/intellij/notification/Notification;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/notification/Notification;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.ml.llm.mcp"})
    public static final class ConfigureMcpSettingsAction
    extends AnAction
    implements DumbAware {
        @Nullable
        private final Project project;
        @NotNull
        private final Notification notification;

        public ConfigureMcpSettingsAction(@Nullable Project project2, @NotNull Notification notification2) {
            Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
            super(McpBundle.message("ml.llm.mcp.settings.changed.open.settings", new Object[0]));
            this.project = project2;
            this.notification = notification2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ShowSettingsUtil showSettingsUtil = ShowSettingsUtil.getInstance();
            Project project2 = this.project;
            if (project2 == null) {
                project2 = e.getProject();
            }
            showSettingsUtil.showSettingsDialog(project2, McpConfigurable.class);
            this.notification.expire();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001c\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/mcp/client/McpSettingsChangedNotification$EnableExternalChangesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "notification", "Lcom/intellij/notification/Notification;", "text", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/notification/Notification;Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.ml.llm.mcp"})
    public static final class EnableExternalChangesAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final Notification notification;
        @NotNull
        private final String text;

        public EnableExternalChangesAction(@NotNull Notification notification2, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            super(text2);
            this.notification = notification2;
            this.text = text2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            McpApplicationServerConfigurationService.Companion.getInstance().setAutoEnableExternalChanges$intellij_ml_llm_mcp(!McpApplicationServerConfigurationService.Companion.getInstance().getAutoEnableExternalChanges());
            this.notification.expire();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[McpConfigurationChangeType.values().length];
            try {
                nArray[McpConfigurationChangeType.ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[McpConfigurationChangeType.MODIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[McpConfigurationChangeType.MOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[McpConfigurationChangeType.REMOVED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

