/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.embedded;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.mcpserver.StdioRunnerUtilKt;
import com.intellij.mcpserver.impl.McpServerService;
import com.intellij.ml.llm.mcp.client.McpClient;
import com.intellij.ml.llm.mcp.client.McpClientRegistry;
import com.intellij.ml.llm.mcp.client.McpClientService;
import com.intellij.ml.llm.mcp.client.McpClientSystemRegistry;
import com.intellij.ml.llm.mcp.client.McpServerCommandDescriptor;
import com.intellij.ml.llm.mcp.client.McpServerDescriptor;
import com.intellij.ml.llm.mcp.client.embedded.EmbeddedMcpServerInitializerKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/mcp/client/embedded/EmbeddedMcpServerInitializer;", "Lcom/intellij/openapi/startup/ProjectActivity;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "mcpService", "Lcom/intellij/mcpserver/impl/McpServerService;", "isEnabled", "", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRemoteMcpServerConfig", "Lcom/intellij/ml/llm/mcp/client/McpServerCommandDescriptor;", "getLocalMcpServerConfig", "mcpServerPort", "", "intellij.ml.llm.mcp"})
@SourceDebugExtension(value={"SMAP\nEmbeddedMcpServerInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddedMcpServerInitializer.kt\ncom/intellij/ml/llm/mcp/client/embedded/EmbeddedMcpServerInitializer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n23#2:198\n23#2:202\n23#2:203\n23#2:215\n2746#3,3:199\n669#3,11:204\n*S KotlinDebug\n*F\n+ 1 EmbeddedMcpServerInitializer.kt\ncom/intellij/ml/llm/mcp/client/embedded/EmbeddedMcpServerInitializer\n*L\n51#1:198\n55#1:202\n60#1:203\n67#1:215\n54#1:199,3\n65#1:204,11\n*E\n"})
public final class EmbeddedMcpServerInitializer
implements ProjectActivity {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final McpServerService mcpService;
    private final boolean isEnabled;

    public EmbeddedMcpServerInitializer(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.mcpService = McpServerService.Companion.getInstance();
        this.isEnabled = Registry.Companion.is("llm.mcp.client.enabled") && Registry.Companion.is("llm.mcp.platform.server.enabled");
    }

    @Nullable
    public Object execute(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
        Application appManager = ApplicationManager.getApplication();
        if (this.isEnabled && !appManager.isUnitTestMode() || appManager.isUnitTestMode() && EmbeddedMcpServerInitializerKt.isEnabledInTests()) {
            Object v4;
            block12: {
                boolean bl;
                McpClientSystemRegistry registry;
                block11: {
                    if (!this.mcpService.isRunning()) {
                        this.mcpService.start();
                    }
                    EmbeddedMcpServerInitializer $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(EmbeddedMcpServerInitializer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info("Embedded MCP server started");
                    registry = McpClientSystemRegistry.Companion.getInstance();
                    Iterable $this$none$iv = McpClientRegistry.getConfigurations$default(registry, null, 1, null).values();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            McpServerDescriptor it = (McpServerDescriptor)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)ApplicationInfo.getInstance().getFullApplicationName())) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(EmbeddedMcpServerInitializer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.debug("Adding configuration for embedded MCP server");
                    McpServerCommandDescriptor command = this.getLocalMcpServerConfig(this.mcpService.getPort());
                    McpClientSystemRegistry.registerConfiguration$default(registry, command, EmbeddedMcpServerInitializerKt.getAllowedToolsNamesForIdeMcpServer(), null, 4, null);
                } else {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(EmbeddedMcpServerInitializer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.debug("Configuration for embedded MCP server already exists");
                    McpClientService.Companion.getInstance();
                }
                Iterable $this$singleOrNull$iv = McpClientService.Companion.getInstance().getClients$intellij_ml_llm_mcp();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    McpClient it = (McpClient)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getServerConfiguration().getName(), (Object)ApplicationInfo.getInstance().getFullApplicationName())) continue;
                    if (found$iv) {
                        v4 = null;
                        break block12;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v4 = !found$iv ? null : single$iv;
            }
            McpClient mcpClient = v4;
            if (mcpClient == null) {
                EmbeddedMcpServerInitializer $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(EmbeddedMcpServerInitializer.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("MCP client for embedded MCP server is not initialized");
            } else {
                BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mcpClient, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ McpClient $mcpClient;
                    {
                        this.$mcpClient = $mcpClient;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = (CoroutineScope)this.L$0;
                        var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
lbl6:
                                // 3 sources

                                while (!this.$mcpClient.isRunning()) {
                                    this.L$0 = $this$launch;
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                                    if (v0 != var5_3) continue;
                                    return var5_3;
                                }
                                break;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl6
                            }
                        }
                        $this$thisLogger$iv = $this$launch;
                        $i$f$thisLogger = false;
                        v1 = Logger.getInstance(CoroutineScope.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                        v1.info("Connected to embedded MCP server ");
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
        return Unit.INSTANCE;
    }

    private final McpServerCommandDescriptor getRemoteMcpServerConfig(McpServerService mcpService) {
        String string = ApplicationInfo.getInstance().getFullApplicationName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullApplicationName(...)");
        Object[] objectArray = new String[]{"-y", "mcp-remote@latest", mcpService.getServerSseUrl()};
        return new McpServerCommandDescriptor(string, "npm", CollectionsKt.listOf((Object[])objectArray), MapsKt.emptyMap(), "");
    }

    private final McpServerCommandDescriptor getLocalMcpServerConfig(int mcpServerPort) {
        GeneralCommandLine mcpCommandLineArgs = StdioRunnerUtilKt.createStdioMcpServerCommandLine$default((int)mcpServerPort, null, null, (int)4, null);
        String string = ApplicationInfo.getInstance().getFullApplicationName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullApplicationName(...)");
        String string2 = mcpCommandLineArgs.getExePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExePath(...)");
        List list = mcpCommandLineArgs.getParametersList().getList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
        Map map2 = mcpCommandLineArgs.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvironment(...)");
        return new McpServerCommandDescriptor(string, string2, list, map2, "");
    }
}

