/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.settings;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.mcp.client.McpBundle;
import com.intellij.ml.llm.mcp.client.McpClient;
import com.intellij.ml.llm.mcp.client.McpClientService;
import com.intellij.ml.llm.mcp.client.settings.ClaudeConfigImportAction;
import com.intellij.ml.llm.mcp.client.settings.ClaudeConfigImporter;
import com.intellij.ml.llm.mcp.client.settings.ConfigurationChangeListener;
import com.intellij.ml.llm.mcp.client.settings.McpApplicationServerConfigurationService;
import com.intellij.ml.llm.mcp.client.settings.McpConfigurationChangeSource;
import com.intellij.ml.llm.mcp.client.settings.McpNotificationPanel;
import com.intellij.ml.llm.mcp.client.settings.McpProjectServerConfigurationService;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommand;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfiguration;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationEditDialog;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationItem;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationLevel;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationServiceBase;
import com.intellij.ml.llm.mcp.client.settings.McpServerURL;
import com.intellij.ml.llm.mcp.client.settings.McpServersPanel;
import com.intellij.ml.llm.mcp.client.settings.McpServersPanelKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UiScopeKt;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u001c\b\u0000\u0018\u00002\u00020\u0001:\u00049:;<B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0007H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020#H\u0002J\b\u0010&\u001a\u00020#H\u0002J\b\u0010'\u001a\u00020#H\u0002J\u0006\u0010(\u001a\u00020\u0007J\u0006\u0010)\u001a\u00020#J8\u0010*\u001a\u00020#2\u0016\u0010+\u001a\u0012\u0012\u0004\u0012\u00020-0,j\b\u0012\u0004\u0012\u00020-`.2\u0016\u0010/\u001a\u0012\u0012\u0004\u0012\u00020-0,j\b\u0012\u0004\u0012\u00020-`.H\u0002J\u0006\u00100\u001a\u00020#J&\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020-2\u0006\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0002J\u0006\u00108\u001a\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000f0\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u0006="}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "autoEnableExternalChanges", "getAutoEnableExternalChanges", "()Z", "setAutoEnableExternalChanges", "(Z)V", "tableModel", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationItem;", "table", "Lcom/intellij/ui/table/TableView;", "kotlin.jvm.PlatformType", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "notificationWrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "footerPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "commandListener", "com/intellij/ml/llm/mcp/client/settings/McpServersPanel$commandListener$1", "Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel$commandListener$1;", "isModifiable", "getNotificationPanel", "Ljavax/swing/JPanel;", "modifiable", "setEmptyText", "", "addServer", "editServer", "removeServer", "updateTable", "isModified", "apply", "validateAlreadyExistingConfigurations", "movedToGlobal", "Ljava/util/ArrayList;", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfiguration;", "Lkotlin/collections/ArrayList;", "movedToProject", "reset", "createItem", "command", "level", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationLevel;", "clients", "", "Lcom/intellij/ml/llm/mcp/client/McpClient;", "disposeUIResources", "AddServerAction", "EditServerAction", "RemoveServerAction", "ReconnectServerAction", "intellij.ml.llm.mcp"})
@SourceDebugExtension(value={"SMAP\nMcpServersPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpServersPanel.kt\ncom/intellij/ml/llm/mcp/client/settings/McpServersPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,754:1\n1869#2,2:755\n1208#2,2:757\n1236#2,4:759\n1208#2,2:763\n1236#2,4:765\n1563#2:769\n1634#2,3:770\n1563#2:773\n1634#2,3:774\n1#3:777\n*S KotlinDebug\n*F\n+ 1 McpServersPanel.kt\ncom/intellij/ml/llm/mcp/client/settings/McpServersPanel\n*L\n196#1:755,2\n254#1:757,2\n254#1:759,4\n255#1:763,2\n255#1:765,4\n293#1:769\n293#1:770,3\n294#1:773\n294#1:774,3\n*E\n"})
public final class McpServersPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final ListTableModel<McpServerConfigurationItem> tableModel;
    @NotNull
    private final TableView<McpServerConfigurationItem> table;
    @NotNull
    private final JComponent component;
    @NotNull
    private final Wrapper notificationWrapper;
    @NotNull
    private DialogPanel footerPanel;
    @NotNull
    private final commandListener.1 commandListener;

    public McpServersPanel(@NotNull Project project2) {
        ToolbarDecorator toolbarDecorator;
        ColumnInfo[] columnInfoArray;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        spreadBuilder.add((Object)McpServersPanelKt.access$createEnabledColumn());
        spreadBuilder.add((Object)McpServersPanelKt.access$createStatusColumn());
        spreadBuilder.add((Object)McpServersPanelKt.access$createNameColumn());
        spreadBuilder.add((Object)McpServersPanelKt.access$createConfigurationColumn());
        spreadBuilder.add((Object)McpServersPanelKt.access$createLevelColumn(!this.project.isDefault()));
        if (Registry.Companion.is("llm.mcp.client.show.server.source")) {
            ColumnInfo[] columnInfoArray2 = new ColumnInfo[]{McpServersPanelKt.access$createSourceColumn()};
            columnInfoArray = columnInfoArray2;
        } else {
            columnInfoArray = new ColumnInfo[]{};
        }
        spreadBuilder.addSpread((Object)columnInfoArray);
        this.tableModel = new ListTableModel((ColumnInfo[])spreadBuilder.toArray((Object[])new ColumnInfo[spreadBuilder.size()]));
        this.table = new TableView(this.tableModel);
        this.notificationWrapper = new Wrapper();
        this.commandListener = new ConfigurationChangeListener(this){
            private final AtomicBoolean reset;
            final /* synthetic */ McpServersPanel this$0;
            {
                this.this$0 = $receiver;
                this.reset = new AtomicBoolean(false);
            }

            public final AtomicBoolean getReset() {
                return this.reset;
            }

            public void configurationsChanged() {
                if (this.reset.compareAndSet(false, true)) {
                    UIUtil.invokeLaterIfNeeded(() -> commandListener.1.configurationsChanged$lambda$0(this, this.this$0));
                }
            }

            private static final void configurationsChanged$lambda$0(commandListener.1 this$0, McpServersPanel this$1) {
                if (this$0.reset.compareAndSet(true, false)) {
                    this$1.reset();
                }
            }
        };
        McpApplicationServerConfigurationService.Companion.getInstance().addListener(this.commandListener);
        McpApplicationServerConfigurationService.Companion.getInstance().refreshConfigurationFile();
        McpProjectServerConfigurationService.Companion.getInstance(this.project).refreshConfigurationFile();
        this.tableModel.setSortable(true);
        this.table.setShowGrid(false);
        TableUtil.setupCheckboxColumn((TableColumn)this.table.getColumnModel().getColumn(0), (int)0);
        JBTable.setupCheckboxShortcut((JTable)((JTable)this.table), (int)0);
        this.table.putClientProperty((Object)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        ToolbarDecorator it = toolbarDecorator = ToolbarDecorator.createDecorator((JTable)((JTable)this.table)).setAddAction((AnActionButtonRunnable)new AddServerAction()).setEditAction((AnActionButtonRunnable)new EditServerAction()).setRemoveAction((AnActionButtonRunnable)new RemoveServerAction()).setAddActionUpdater(arg_0 -> McpServersPanel._init_$lambda$0(this, arg_0)).setEditActionUpdater(arg_0 -> McpServersPanel._init_$lambda$1(this, arg_0)).setRemoveActionUpdater(arg_0 -> McpServersPanel._init_$lambda$2(this, arg_0)).setMoveDownActionUpdater(arg_0 -> McpServersPanel._init_$lambda$3(this, arg_0)).setMoveUpActionUpdater(arg_0 -> McpServersPanel._init_$lambda$4(this, arg_0)).addExtraAction((AnAction)new ReconnectServerAction());
        boolean bl = false;
        if (!SystemInfo.isLinux) {
            AnAction[] anActionArray = new AnAction[]{new ClaudeConfigImportAction()};
            it.addExtraActions(anActionArray);
        }
        JPanel jPanel = toolbarDecorator.createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel tablePanel = jPanel;
        DialogPanel header = BuilderKt.panel(McpServersPanel::_init_$lambda$6);
        this.footerPanel = BuilderKt.panel(arg_0 -> McpServersPanel._init_$lambda$7(this, arg_0));
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)tablePanel).addToTop((Component)header).addToBottom((Component)this.footerPanel);
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"addToBottom(...)");
        this.component = (JComponent)borderLayoutPanel;
    }

    public final boolean getAutoEnableExternalChanges() {
        return McpApplicationServerConfigurationService.Companion.getInstance().getAutoEnableExternalChanges();
    }

    public final void setAutoEnableExternalChanges(boolean value) {
        McpApplicationServerConfigurationService.Companion.getInstance().setAutoEnableExternalChanges$intellij_ml_llm_mcp(value);
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    private final boolean isModifiable() {
        return McpApplicationServerConfigurationService.Companion.getInstance().getModifiable();
    }

    private final JPanel getNotificationPanel(boolean modifiable) {
        JPanel jPanel;
        if (modifiable) {
            jPanel = new JPanel();
        } else {
            String string = McpBundle.message("ml.llm.mcp.server.configurations.not.editable", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            jPanel = (JPanel)((Object)new McpNotificationPanel(string, EditorNotificationPanel.Status.Info));
        }
        return jPanel;
    }

    private final void setEmptyText() {
        Shortcut shortcut;
        Object[] addAction;
        StatusText statusText2 = this.table.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText2, (String)"getEmptyText(...)");
        StatusText emptyText = statusText2;
        emptyText.setText(McpBundle.message("ml.llm.mcp.server.no.configured", new Object[0]));
        boolean modifiable = this.isModifiable();
        this.notificationWrapper.setContent((JComponent)this.getNotificationPanel(modifiable));
        if (!modifiable) {
            return;
        }
        emptyText.appendSecondaryText(McpBundle.message("ml.llm.mcp.server.add", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> McpServersPanel.setEmptyText$lambda$0(this, arg_0));
        Object[] objectArray = addAction = ActionManager.getInstance().getAction("NewElement");
        Shortcut shortcut2 = addAction != null && (objectArray = objectArray.getShortcutSet()) != null && (objectArray = objectArray.getShortcuts()) != null ? (Shortcut)ArraysKt.firstOrNull((Object[])objectArray) : (shortcut = null);
        if (shortcut != null) {
            emptyText.appendSecondaryText(" (" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")", StatusText.DEFAULT_ATTRIBUTES, null);
        }
        emptyText.appendLine(McpBundle.message("ml.llm.mcp.server.import.from.claude", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> McpServersPanel.setEmptyText$lambda$1(this, arg_0));
    }

    private final void addServer() {
        String string = McpBundle.message("ml.llm.mcp.server.new", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        McpServerConfigurationEditDialog dialog2 = new McpServerConfigurationEditDialog(this.project, string, null, null, 12, null);
        if (dialog2.showAndGet()) {
            Iterable $this$forEach$iv = dialog2.getConfigurations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                McpServerConfiguration it = (McpServerConfiguration)element$iv;
                boolean bl = false;
                this.tableModel.addRow((Object)new McpServerConfigurationItem(it, dialog2.getMcpServerConfigurationLevel(), null));
            }
            this.updateTable();
        }
    }

    private final void editServer() {
        McpServerConfigurationItem mcpServerConfigurationItem = (McpServerConfigurationItem)this.table.getSelectedObject();
        if (mcpServerConfigurationItem == null) {
            return;
        }
        McpServerConfigurationItem item = mcpServerConfigurationItem;
        Object[] objectArray = new McpServerConfiguration[]{item.getConfiguration()};
        List configurations = CollectionsKt.mutableListOf((Object[])objectArray);
        String string = McpBundle.message("ml.llm.mcp.server.edit", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        McpServerConfigurationEditDialog dialog2 = new McpServerConfigurationEditDialog(this.project, string, configurations, item.getLevel());
        if (dialog2.showAndGet()) {
            item.getConfiguration().copyFrom((McpServerConfiguration)CollectionsKt.first((List)configurations));
            item.setLevel(dialog2.getMcpServerConfigurationLevel());
            this.updateTable();
        }
    }

    private final void removeServer() {
        int[] selectedRows = this.table.getSelectedRows();
        Intrinsics.checkNotNull((Object)selectedRows);
        List list = ArraysKt.reversed((int[])selectedRows);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int selectedRow = ((Number)list.get(i)).intValue();
            this.tableModel.removeRow(selectedRow);
        }
        this.updateTable();
    }

    private final void updateTable() {
        this.tableModel.fireTableDataChanged();
    }

    public final boolean isModified() {
        ArrayList<McpServerConfiguration> globalCommands = new ArrayList<McpServerConfiguration>();
        ArrayList<McpServerConfiguration> projectCommands = new ArrayList<McpServerConfiguration>();
        for (McpServerConfigurationItem item : this.tableModel.getItems()) {
            boolean bl = item.getLevel() == McpServerConfigurationLevel.GLOBAL ? globalCommands.add(item.getConfiguration()) : projectCommands.add(item.getConfiguration());
        }
        return !Intrinsics.areEqual(McpApplicationServerConfigurationService.Companion.getInstance().getConfigurations(), globalCommands) || !Intrinsics.areEqual(McpProjectServerConfigurationService.Companion.getInstance(this.project).getConfigurations(), projectCommands) || this.footerPanel.isModified();
    }

    /*
     * WARNING - void declaration
     */
    public final void apply() {
        void $this$associateByTo$iv$iv;
        Map map2;
        void $this$associateByTo$iv$iv2;
        McpApplicationServerConfigurationService.Companion.getInstance().removeListener(this.commandListener);
        this.footerPanel.apply();
        ArrayList<McpServerConfiguration> globalCommands = new ArrayList<McpServerConfiguration>();
        ArrayList<McpServerConfiguration> projectCommands = new ArrayList<McpServerConfiguration>();
        ArrayList<McpServerConfiguration> movedToGlobal = new ArrayList<McpServerConfiguration>();
        ArrayList<McpServerConfiguration> movedToProject = new ArrayList<McpServerConfiguration>();
        Iterable $this$associateBy$iv = McpApplicationServerConfigurationService.Companion.getInstance().getConfigurations();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            void it;
            McpServerConfiguration mcpServerConfiguration = (McpServerConfiguration)element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getId(), element$iv$iv);
        }
        Map globalBefore = destination$iv$iv;
        Iterable $this$associateBy$iv2 = McpProjectServerConfigurationService.Companion.getInstance(this.project).getConfigurations();
        boolean $i$f$associateBy2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            McpServerConfiguration bl = (McpServerConfiguration)element$iv$iv;
            map2 = destination$iv$iv2;
            boolean bl2 = false;
            map2.put(it.getId(), element$iv$iv);
        }
        Map projectBefore = destination$iv$iv2;
        for (McpServerConfigurationItem item : this.tableModel.getItems()) {
            if (item.getLevel() == McpServerConfigurationLevel.GLOBAL) {
                globalCommands.add(item.getConfiguration());
                McpServerConfiguration commandBefore = (McpServerConfiguration)projectBefore.get(item.getConfiguration().getId());
                if (commandBefore == null) continue;
                movedToGlobal.add(commandBefore);
                continue;
            }
            projectCommands.add(item.getConfiguration());
            McpServerConfiguration commandBefore = (McpServerConfiguration)globalBefore.get(item.getConfiguration().getId());
            if (commandBefore == null) continue;
            movedToProject.add(commandBefore);
        }
        List moved = CollectionsKt.plus((Collection)movedToGlobal, (Iterable)movedToProject);
        this.validateAlreadyExistingConfigurations(movedToGlobal, movedToProject);
        McpServerConfigurationServiceBase.setConfigurations$default(McpApplicationServerConfigurationService.Companion.getInstance(), globalCommands, moved, McpConfigurationChangeSource.SETTINGS_UI, false, 8, null);
        if (!this.project.isDefault()) {
            McpServerConfigurationServiceBase.setConfigurations$default(McpProjectServerConfigurationService.Companion.getInstance(this.project), projectCommands, moved, McpConfigurationChangeSource.SETTINGS_UI, false, 8, null);
        }
        McpApplicationServerConfigurationService.Companion.getInstance().addListener(this.commandListener);
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    private final void validateAlreadyExistingConfigurations(ArrayList<McpServerConfiguration> movedToGlobal, ArrayList<McpServerConfiguration> movedToProject) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List<McpServerConfiguration> existingGlobal = McpApplicationServerConfigurationService.Companion.getInstance().getConfigurations();
        List<McpServerConfiguration> existingProject = McpProjectServerConfigurationService.Companion.getInstance(this.project).getConfigurations();
        Iterable $this$map$iv = movedToGlobal;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            McpServerConfiguration mcpServerConfiguration = (McpServerConfiguration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set toGlobalNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = movedToProject;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            McpServerConfiguration bl = (McpServerConfiguration)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getName());
        }
        Set toProjectNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Set globalConflicts = toGlobalNames.isEmpty() ? SetsKt.emptySet() : SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)existingGlobal), McpServersPanel::validateAlreadyExistingConfigurations$lambda$2), arg_0 -> McpServersPanel.validateAlreadyExistingConfigurations$lambda$3(toGlobalNames, arg_0)));
        Set projectConflicts = toProjectNames.isEmpty() ? SetsKt.emptySet() : SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)existingProject), McpServersPanel::validateAlreadyExistingConfigurations$lambda$4), arg_0 -> McpServersPanel.validateAlreadyExistingConfigurations$lambda$5(toProjectNames, arg_0)));
        if (!((Collection)globalConflicts).isEmpty() || !((Collection)projectConflicts).isEmpty()) {
            List parts = new ArrayList();
            if (!((Collection)globalConflicts).isEmpty()) {
                ((Collection)parts).add(McpServerConfigurationLevel.GLOBAL.getDisplayName() + ": " + CollectionsKt.joinToString$default((Iterable)globalConflicts, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            if (!((Collection)projectConflicts).isEmpty()) {
                ((Collection)parts).add(McpServerConfigurationLevel.PROJECT.getDisplayName() + ": " + CollectionsKt.joinToString$default((Iterable)projectConflicts, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            String string = McpBundle.message("ml.llm.mcp.server.json.config.existing.invalid", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String header = string;
            String errorText = !((Collection)parts).isEmpty() ? header + "\n" + CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : header;
            throw new ConfigurationException(errorText);
        }
    }

    public final void reset() {
        List<McpClient> clients = McpClientService.Companion.getInstance().getClients(this.project);
        ArrayList<McpServerConfigurationItem> items2 = new ArrayList<McpServerConfigurationItem>();
        for (McpServerConfiguration command : McpApplicationServerConfigurationService.Companion.getInstance().getConfigurations()) {
            items2.add(this.createItem(command, McpServerConfigurationLevel.GLOBAL, clients));
        }
        for (McpServerConfiguration command : McpProjectServerConfigurationService.Companion.getInstance(this.project).getConfigurations()) {
            items2.add(this.createItem(command, McpServerConfigurationLevel.PROJECT, clients));
        }
        this.tableModel.setItems((List)items2);
        this.setEmptyText();
        this.footerPanel.reset();
    }

    private final McpServerConfigurationItem createItem(McpServerConfiguration command, McpServerConfigurationLevel level, List<McpClient> clients) {
        McpServerConfiguration mcpServerConfiguration;
        Object v0;
        Object object;
        block6: {
            object = clients;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                McpClient client2 = (McpClient)t;
                boolean bl = false;
                if (!(client2.getServerConfiguration().getId() == command.getId())) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        McpClient client3 = v0;
        if (client3 != null) {
            UiScopeKt.launchOnShow$default((Component)((Component)this.table), (String)"McpServersPanel", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(client3, this, null){
                int label;
                final /* synthetic */ McpClient $client;
                final /* synthetic */ McpServersPanel this$0;
                {
                    this.$client = $client;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$client.getState().collect(new FlowCollector(this.this$0){
                                final /* synthetic */ McpServersPanel this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                public final Object emit(McpClient.State state2, Continuation<? super Unit> $completion) {
                                    McpServersPanel.access$updateTable(this.this$0);
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) throw new KotlinNothingValueException();
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            throw new KotlinNothingValueException();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        if ((object = command) instanceof McpServerCommand) {
            mcpServerConfiguration = new McpServerCommand((McpServerCommand)command);
        } else if (object instanceof McpServerURL) {
            mcpServerConfiguration = new McpServerURL(command);
        } else {
            throw new IllegalStateException("Unknown configuration type: " + command.getClass().getName());
        }
        McpServerConfiguration configuration = mcpServerConfiguration;
        return new McpServerConfigurationItem(configuration, level, client3);
    }

    public final void disposeUIResources() {
        McpApplicationServerConfigurationService.Companion.getInstance().removeListener(this.commandListener);
        this.commandListener.getReset().set(false);
    }

    private static final boolean _init_$lambda$0(McpServersPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isModifiable();
    }

    private static final boolean _init_$lambda$1(McpServersPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isModifiable();
    }

    private static final boolean _init_$lambda$2(McpServersPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isModifiable();
    }

    private static final boolean _init_$lambda$3(McpServersPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isModifiable();
    }

    private static final boolean _init_$lambda$4(McpServersPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isModifiable();
    }

    private static final Unit _init_$lambda$6(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, McpServersPanel::lambda$6$0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{"https://modelcontextprotocol.io/introduction", "https://github.com/modelcontextprotocol/servers"};
        String string = McpBundle.message("ml.llm.mcp.settings.configurable.comment", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(McpServersPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> McpServersPanel.lambda$7$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> McpServersPanel.lambda$7$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$0(McpServersPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = McpBundle.message("ml.llm.mcp.server.configurations.enable.added.modified.configurations", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), () -> McpServersPanel.lambda$7$0$0(this$0), arg_0 -> McpServersPanel.lambda$7$0$1(this$0, arg_0)).visible(this$0.isModifiable());
        return Unit.INSTANCE;
    }

    private static final boolean lambda$7$0$0(McpServersPanel this$0) {
        return this$0.getAutoEnableExternalChanges();
    }

    private static final Unit lambda$7$0$1(McpServersPanel this$0, boolean it) {
        this$0.setAutoEnableExternalChanges(it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lambda$7$1(McpServersPanel this$0, Row $this$row) {
        void it;
        Wrapper wrapper;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Wrapper wrapper2 = wrapper = this$0.notificationWrapper;
        Row row = $this$row;
        boolean bl = false;
        it.setContent((JComponent)this$0.getNotificationPanel(this$0.isModifiable()));
        row.cell((JComponent)wrapper).align((Align)AlignX.FILL.INSTANCE).applyToComponent(McpServersPanel::lambda$7$1$1);
        $this$row.topGap(TopGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$1$1(Wrapper $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, (Object)UnscaledGaps.EMPTY);
        return Unit.INSTANCE;
    }

    private static final void setEmptyText$lambda$0(McpServersPanel this$0, ActionEvent it) {
        this$0.addServer();
    }

    private static final void setEmptyText$lambda$1(McpServersPanel this$0, ActionEvent it) {
        new ClaudeConfigImporter().import((JTable)this$0.table);
    }

    private static final String validateAlreadyExistingConfigurations$lambda$2(McpServerConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final boolean validateAlreadyExistingConfigurations$lambda$3(Set $toGlobalNames, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $toGlobalNames.contains(it);
    }

    private static final String validateAlreadyExistingConfigurations$lambda$4(McpServerConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final boolean validateAlreadyExistingConfigurations$lambda$5(Set $toProjectNames, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $toProjectNames.contains(it);
    }

    public static final /* synthetic */ void access$updateTable(McpServersPanel $this) {
        $this.updateTable();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel$AddServerAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel;)V", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.ml.llm.mcp"})
    private final class AddServerAction
    implements AnActionButtonRunnable {
        public void run(@NotNull AnActionButton button2) {
            Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
            McpServersPanel.this.addServer();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel$EditServerAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel;)V", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.ml.llm.mcp"})
    private final class EditServerAction
    implements AnActionButtonRunnable {
        public void run(@NotNull AnActionButton button2) {
            Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
            McpServersPanel.this.editServer();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel$ReconnectServerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.ml.llm.mcp"})
    @SourceDebugExtension(value={"SMAP\nMcpServersPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpServersPanel.kt\ncom/intellij/ml/llm/mcp/client/settings/McpServersPanel$ReconnectServerAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,754:1\n1761#2,3:755\n1869#2,2:758\n*S KotlinDebug\n*F\n+ 1 McpServersPanel.kt\ncom/intellij/ml/llm/mcp/client/settings/McpServersPanel$ReconnectServerAction\n*L\n377#1:755,3\n382#1:758,2\n*E\n"})
    private final class ReconnectServerAction
    extends DumbAwareAction {
        public ReconnectServerAction() {
            super(McpBundle.message("ml.llm.mcp.server.reconnect", new Object[0]), McpBundle.message("ml.llm.mcp.server.reconnect.action.description", new Object[0]), AllIcons.Actions.Restart);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                List list = McpServersPanel.this.table.getSelectedObjects();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedObjects(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        McpServerConfigurationItem item = (McpServerConfigurationItem)element$iv;
                        boolean bl2 = false;
                        if (!item.getConfiguration().getEnabled()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            boolean hasEnabledSelection = bl;
            e.getPresentation().setEnabled(hasEnabledSelection && McpServersPanel.this.isModifiable());
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            List list = McpServersPanel.this.table.getSelectedObjects();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedObjects(...)");
            Iterable iterable = list;
            McpServersPanel mcpServersPanel = McpServersPanel.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                McpServerConfigurationItem item = (McpServerConfigurationItem)element$iv;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[item.getLevel().ordinal()]) {
                    case 1: {
                        McpApplicationServerConfigurationService.Companion.getInstance().requestRestart(item.getConfiguration());
                        break;
                    }
                    case 2: {
                        McpProjectServerConfigurationService.Companion.getInstance(mcpServersPanel.project).requestRestart(item.getConfiguration());
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[McpServerConfigurationLevel.values().length];
                try {
                    nArray[McpServerConfigurationLevel.GLOBAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[McpServerConfigurationLevel.PROJECT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel$RemoveServerAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel;)V", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.ml.llm.mcp"})
    private final class RemoveServerAction
    implements AnActionButtonRunnable {
        public void run(@NotNull AnActionButton button2) {
            Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
            McpServersPanel.this.removeServer();
        }
    }
}

