/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.json;

import com.intellij.ml.llm.mcp.client.McpBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.SystemProperties;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/mcp/json/McpJsonSchemaProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "<init>", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "McpJsonSchemaProvider", "intellij.ml.llm.mcp.json"})
public final class McpJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return CollectionsKt.listOf((Object)new McpJsonSchemaProvider(project2));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\r\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/mcp/json/McpJsonSchemaProviderFactory$McpJsonSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "Lorg/jetbrains/annotations/Nls;", "getSchemaFile", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "intellij.ml.llm.mcp.json"})
    private static final class McpJsonSchemaProvider
    implements JsonSchemaFileProvider {
        @NotNull
        private final Project project;

        public McpJsonSchemaProvider(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }

        public boolean isAvailable(@NotNull VirtualFile file2) {
            String projectPath;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            String string = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String fileName = string;
            if (!StringsKt.endsWith$default((String)fileName, (String)"mcp.json", (boolean)false, (int)2, null)) {
                return false;
            }
            String string2 = SystemProperties.getUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserHome(...)");
            Path path = Paths.get(string2, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path path2 = path.resolve(Registry.Companion.stringValue("llm.mcp.client.global.mcp.json.path"));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            String globalPath = ((Object)path2).toString();
            if (Intrinsics.areEqual((Object)file2.getPath(), (Object)globalPath)) {
                return true;
            }
            String string3 = this.project.getBasePath();
            if (string3 != null) {
                String basePath = string3;
                boolean bl = false;
                Path path3 = Paths.get(basePath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                Path path4 = path3.resolve(Registry.Companion.stringValue("llm.mcp.client.project.mcp.json.path"));
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                v6 = ((Object)path4).toString();
            } else {
                v6 = projectPath = null;
            }
            if (projectPath != null && Intrinsics.areEqual((Object)file2.getPath(), projectPath)) {
                return true;
            }
            return file2 instanceof LightVirtualFile && Intrinsics.areEqual((Object)fileName, (Object)"mcp.json");
        }

        @NotNull
        public String getName() {
            String string = McpBundle.message("title.mcp.configuration", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Nullable
        public VirtualFile getSchemaFile() {
            return JsonSchemaProviderFactory.getResourceFile(McpJsonSchemaProviderFactory.class, (String)"/schemas/mcp.json");
        }

        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.embeddedSchema;
        }
    }
}

