/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.provider.caches;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.intellij.ml.diagnostics.DiagnosticsLogger;
import com.intellij.ml.diagnostics.DiagnosticsLoggerKt;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.BackendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.backend.diff.TextDiffUtils;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.NextEditCacheKt;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.PartialHunkMatcher;
import com.intellij.ml.llm.nextEdits.backend.provider.context.NextEditContext;
import com.intellij.ml.llm.nextEdits.backend.provider.suggestion.NextProposalEditsKt;
import com.intellij.ml.llm.nextEdits.common.diff.Hunk;
import com.intellij.ml.llm.nextEdits.common.diff.TextDiff;
import com.intellij.ml.llm.nextEdits.common.provider.NextEditProposal;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 $2\u00020\u0001:\u0004#$%&B-\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\t\b\u0016\u00a2\u0006\u0004\b\n\u0010\fJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0006\u0010\u0019\u001a\u00020\u0013J)\u0010\u001a\u001a\u00020\u00132!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00050\u001cJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache;", "", "expiryStrategy", "Lcom/github/benmanes/caffeine/cache/Expiry;", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$CacheEntry;", "", "cacheSize", "", "mbThreshold", "", "<init>", "(Lcom/github/benmanes/caffeine/cache/Expiry;JD)V", "()V", "LOG", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "cache", "", "put", "", "context", "Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext;", "proposal", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditProposal$Rewrite;", "tryGet", "invalidate", "removeIf", "condition", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "entry", "debugItems", "", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$DebugItem;", "DebugItem", "Companion", "CacheEntry", "CacheEntryExpiry", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditCache.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache\n+ 2 BackendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n25#2:201\n13#3:202\n1#4:203\n295#5:204\n1761#5,3:205\n296#5:208\n1563#5:209\n1634#5,3:210\n*S KotlinDebug\n*F\n+ 1 NextEditCache.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache\n*L\n40#1:201\n40#1:202\n80#1:204\n81#1:205,3\n80#1:208\n123#1:209\n123#1:210,3\n*E\n"})
public final class NextEditCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double mbThreshold;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final Set<CacheEntry> cache;
    private static final long CACHE_SIZE = 10L;
    private static final double DEFAULT_MB_THRESHOLD = 1.0;

    /*
     * WARNING - void declaration
     */
    private NextEditCache(Expiry<CacheEntry, Boolean> expiryStrategy, long cacheSize, double mbThreshold) {
        void it;
        this.mbThreshold = mbThreshold;
        NextEditCache $this$thisNextEditLogger$iv = this;
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger22 = false;
        Logger logger = Logger.getInstance(NextEditCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = BackendNextEditDiagnosticsLogger.constructor-impl(logger);
        ConcurrentMap $i$f$logger22 = Caffeine.newBuilder().maximumSize(cacheSize).expireAfter(expiryStrategy).build().asMap();
        NextEditCache nextEditCache = this;
        boolean bl = false;
        Set set = Collections.newSetFromMap((Map)it);
        Intrinsics.checkNotNullExpressionValue(set, (String)"let(...)");
        nextEditCache.cache = set;
    }

    public NextEditCache() {
        this((Expiry<CacheEntry, Boolean>)((Expiry)new CacheEntryExpiry(0L, 0L, 0.0, 0.0, 15, null)), 10L, 1.0);
    }

    public final void put(@NotNull NextEditContext context2, @NotNull NextEditProposal.Rewrite proposal2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
        if (NextEditCacheKt.access$sizeInMb(context2.getCurrentFile().getContent()) < this.mbThreshold) {
            this.cache.add(new CacheEntry(context2, proposal2));
        }
    }

    @RequiresBackgroundThread
    @Nullable
    public final NextEditProposal.Rewrite tryGet(@NotNull NextEditContext context2) {
        Object v1;
        block6: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            ThreadingAssertions.assertBackgroundThread();
            Iterable $this$firstOrNull$iv = this.cache;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block5: {
                    CacheEntry cacheEntry = (CacheEntry)element$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = cacheEntry.getDiff().getHunks();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            Hunk cacheHunk = (Hunk)element$iv2;
                            boolean bl3 = false;
                            if (!PartialHunkMatcher.INSTANCE.isMatch(cacheEntry.getCurrentFile().getContent(), CollectionsKt.emptyList(), cacheHunk, context2)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        CacheEntry cacheEntry = v1;
        if (cacheEntry == null) {
            return null;
        }
        CacheEntry matchedEntry = cacheEntry;
        NextEditProposal.Rewrite initialProposal = matchedEntry.getProposal();
        DiagnosticsLoggerKt.debug((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(this.LOG), () -> NextEditCache.tryGet$lambda$1(matchedEntry));
        TextDiff diff2 = TextDiffUtils.INSTANCE.diff(context2.getCurrentFile().getContent(), matchedEntry.getAfter());
        return NextProposalEditsKt.fromDiff(NextEditProposal.Rewrite.Companion, diff2, initialProposal.getActionHintPresentation(), context2.getCurrentFile().getPath().getValue(), initialProposal.getPriority(), initialProposal.getForcedIntrusionMode(), initialProposal.getSimilarityId(), initialProposal.getSuggestionKind());
    }

    public final void invalidate() {
        this.cache.clear();
    }

    public final void removeIf(@NotNull Function1<? super CacheEntry, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        this.cache.removeIf(arg_0 -> NextEditCache.removeIf$lambda$1(arg_0 -> NextEditCache.removeIf$lambda$0(condition, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public final List<DebugItem> debugItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.cache;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CacheEntry cacheEntry = (CacheEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DebugItem(it.getCurrentFile().getPath().toString(), it.getDiff()));
        }
        return (List)destination$iv$iv;
    }

    private static final String tryGet$lambda$1(CacheEntry $matchedEntry) {
        return "Cache hit for " + $matchedEntry.getCurrentFile().getPath();
    }

    private static final boolean removeIf$lambda$0(Function1 $condition, CacheEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return (Boolean)$condition.invoke((Object)entry);
    }

    private static final boolean removeIf$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public /* synthetic */ NextEditCache(Expiry expiryStrategy, long cacheSize, double mbThreshold, DefaultConstructorMarker $constructor_marker) {
        this((Expiry<CacheEntry, Boolean>)expiryStrategy, cacheSize, mbThreshold);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$CacheEntry;", "", "context", "Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext;", "proposal", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditProposal$Rewrite;", "<init>", "(Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext;Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditProposal$Rewrite;)V", "getProposal", "()Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditProposal$Rewrite;", "currentFile", "Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext$File;", "getCurrentFile", "()Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext$File;", "after", "", "getAfter", "()Ljava/lang/String;", "after$delegate", "Lkotlin/Lazy;", "diff", "Lcom/intellij/ml/llm/nextEdits/common/diff/TextDiff;", "getDiff", "()Lcom/intellij/ml/llm/nextEdits/common/diff/TextDiff;", "intellij.ml.llm.nextEdits.backend"})
    @ApiStatus.Internal
    public static final class CacheEntry {
        @NotNull
        private final NextEditProposal.Rewrite proposal;
        @NotNull
        private final NextEditContext.File currentFile;
        @NotNull
        private final Lazy after$delegate;

        public CacheEntry(@NotNull NextEditContext context2, @NotNull NextEditProposal.Rewrite proposal2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
            this.proposal = proposal2;
            this.currentFile = context2.getCurrentFile();
            this.after$delegate = LazyKt.lazy(() -> CacheEntry.after_delegate$lambda$0(this));
        }

        @NotNull
        public final NextEditProposal.Rewrite getProposal() {
            return this.proposal;
        }

        @NotNull
        public final NextEditContext.File getCurrentFile() {
            return this.currentFile;
        }

        @NotNull
        public final String getAfter() {
            Lazy lazy = this.after$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final TextDiff getDiff() {
            return this.proposal.getDiff();
        }

        private static final String after_delegate$lambda$0(CacheEntry this$0) {
            return TextDiffUtils.INSTANCE.merge(this$0.currentFile.getContent(), this$0.getDiff());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\u0018\u0000 \u00152\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0015B/\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J(\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J(\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$CacheEntryExpiry;", "Lcom/github/benmanes/caffeine/cache/Expiry;", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$CacheEntry;", "", "shortTtlMs", "", "longTtlMs", "minSizeForShortTtl", "", "maxSizeForShortTtl", "<init>", "(JJDD)V", "expireAfterCreate", "key", "value", "currentTime", "expireAfterUpdate", "currentDuration", "expireAfterRead", "getTtlNanos", "entry", "Companion", "intellij.ml.llm.nextEdits.backend"})
    public static final class CacheEntryExpiry
    implements Expiry<CacheEntry, Boolean> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long shortTtlMs;
        private final long longTtlMs;
        private final double minSizeForShortTtl;
        private final double maxSizeForShortTtl;
        private static final long DEFAULT_SHORT_TTL_MS = 60000L;
        private static final long DEFAULT_LONG_TTL_MS = 300000L;
        private static final double DEFAULT_MIN_SIZE_FOR_SHORT_TTL = 0.25;
        private static final double DEFAULT_MAX_SIZE_FOR_SHORT_TTL = 1.0;

        public CacheEntryExpiry(long shortTtlMs, long longTtlMs, double minSizeForShortTtl, double maxSizeForShortTtl) {
            this.shortTtlMs = shortTtlMs;
            this.longTtlMs = longTtlMs;
            this.minSizeForShortTtl = minSizeForShortTtl;
            this.maxSizeForShortTtl = maxSizeForShortTtl;
        }

        public /* synthetic */ CacheEntryExpiry(long l, long l2, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 60000L;
            }
            if ((n & 2) != 0) {
                l2 = 300000L;
            }
            if ((n & 4) != 0) {
                d = 0.25;
            }
            if ((n & 8) != 0) {
                d2 = 1.0;
            }
            this(l, l2, d, d2);
        }

        public long expireAfterCreate(@NotNull CacheEntry key, boolean value, long currentTime) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.getTtlNanos(key);
        }

        public long expireAfterUpdate(@NotNull CacheEntry key, boolean value, long currentTime, long currentDuration) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return currentDuration;
        }

        public long expireAfterRead(@NotNull CacheEntry key, boolean value, long currentTime, long currentDuration) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return currentDuration;
        }

        private final long getTtlNanos(CacheEntry entry) {
            double fileSizeMb = NextEditCacheKt.access$sizeInMb(entry.getCurrentFile().getContent());
            return RangesKt.rangeUntil((double)this.minSizeForShortTtl, (double)this.maxSizeForShortTtl).contains((Comparable)Double.valueOf(fileSizeMb)) ? TimeUnit.MILLISECONDS.toNanos(this.shortTtlMs) : TimeUnit.MILLISECONDS.toNanos(this.longTtlMs);
        }

        public CacheEntryExpiry() {
            this(0L, 0L, 0.0, 0.0, 15, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$CacheEntryExpiry$Companion;", "", "<init>", "()V", "DEFAULT_SHORT_TTL_MS", "", "DEFAULT_LONG_TTL_MS", "DEFAULT_MIN_SIZE_FOR_SHORT_TTL", "", "DEFAULT_MAX_SIZE_FOR_SHORT_TTL", "intellij.ml.llm.nextEdits.backend"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J2\u0010\b\u001a\u00020\u00052\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache;", "project", "Lcom/intellij/openapi/project/Project;", "createCustomInstance", "expiryStrategy", "Lcom/github/benmanes/caffeine/cache/Expiry;", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$CacheEntry;", "", "cacheSize", "", "mbThreshold", "", "CACHE_SIZE", "DEFAULT_MB_THRESHOLD", "intellij.ml.llm.nextEdits.backend"})
    @SourceDebugExtension(value={"SMAP\nNextEditCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditCache.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,200:1\n30#2,2:201\n*S KotlinDebug\n*F\n+ 1 NextEditCache.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$Companion\n*L\n127#1:201,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditCache getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<NextEditCache> serviceClass$iv = NextEditCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NextEditCache)object;
        }

        @TestOnly
        @ApiStatus.Internal
        @NotNull
        public final NextEditCache createCustomInstance(@NotNull Expiry<CacheEntry, Boolean> expiryStrategy, long cacheSize, double mbThreshold) {
            Intrinsics.checkNotNullParameter(expiryStrategy, (String)"expiryStrategy");
            return new NextEditCache(expiryStrategy, cacheSize, mbThreshold, null);
        }

        public static /* synthetic */ NextEditCache createCustomInstance$default(Companion companion, Expiry expiry, long l, double d, int n, Object object) {
            if ((n & 1) != 0) {
                expiry = new CacheEntryExpiry(0L, 0L, 0.0, 0.0, 15, null);
            }
            if ((n & 2) != 0) {
                l = 10L;
            }
            if ((n & 4) != 0) {
                d = 1.0;
            }
            return companion.createCustomInstance((Expiry<CacheEntry, Boolean>)expiry, l, d);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$DebugItem;", "", "filePath", "", "hunks", "Lcom/intellij/ml/llm/nextEdits/common/diff/TextDiff;", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/nextEdits/common/diff/TextDiff;)V", "getFilePath", "()Ljava/lang/String;", "getHunks", "()Lcom/intellij/ml/llm/nextEdits/common/diff/TextDiff;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.nextEdits.backend"})
    @ApiStatus.Internal
    public static final class DebugItem {
        @NotNull
        private final String filePath;
        @NotNull
        private final TextDiff hunks;

        public DebugItem(@NotNull String filePath, @NotNull TextDiff hunks) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)hunks, (String)"hunks");
            this.filePath = filePath;
            this.hunks = hunks;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final TextDiff getHunks() {
            return this.hunks;
        }

        @NotNull
        public final String component1() {
            return this.filePath;
        }

        @NotNull
        public final TextDiff component2() {
            return this.hunks;
        }

        @NotNull
        public final DebugItem copy(@NotNull String filePath, @NotNull TextDiff hunks) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)hunks, (String)"hunks");
            return new DebugItem(filePath, hunks);
        }

        public static /* synthetic */ DebugItem copy$default(DebugItem debugItem, String string, TextDiff textDiff, int n, Object object) {
            if ((n & 1) != 0) {
                string = debugItem.filePath;
            }
            if ((n & 2) != 0) {
                textDiff = debugItem.hunks;
            }
            return debugItem.copy(string, textDiff);
        }

        @NotNull
        public String toString() {
            return "DebugItem(filePath=" + this.filePath + ", hunks=" + this.hunks + ")";
        }

        public int hashCode() {
            int result2 = this.filePath.hashCode();
            result2 = result2 * 31 + this.hunks.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DebugItem)) {
                return false;
            }
            DebugItem debugItem = (DebugItem)other;
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)debugItem.filePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hunks, (Object)debugItem.hunks);
        }
    }
}

