/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.editor;

import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.ml.llm.nextEdits.common.install.NextEditInstallUtils;
import com.intellij.ml.llm.nextEdits.frontend.codeInsight.NextEditSuggestedRefactoringStateProcessor;
import com.intellij.ml.llm.nextEdits.frontend.completion.inline.CallNextEditOnInlineCompletionSelectionListener;
import com.intellij.ml.llm.nextEdits.frontend.completion.inline.sync.InlineCompletionSessionStateTracker;
import com.intellij.ml.llm.nextEdits.frontend.diagnostics.FrontendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.frontend.listeners.CancelNextEditOnSelectionListener;
import com.intellij.ml.llm.nextEdits.frontend.listeners.NextEditCaretListener;
import com.intellij.ml.llm.nextEdits.frontend.listeners.NextEditDocumentListener;
import com.intellij.ml.llm.nextEdits.frontend.listeners.NextEditRefreshOnBlockInlayChangesListener;
import com.intellij.ml.llm.nextEdits.frontend.listeners.NextEditRefreshOnFoldingChangesListener;
import com.intellij.ml.llm.nextEdits.frontend.listeners.NextEditRefreshOnFontSizeChangesListener;
import com.intellij.ml.llm.nextEdits.frontend.logs.FrontendNextEditEventsReporter;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSessionManager;
import com.intellij.ml.llm.nextEdits.frontend.settings.FrontendNextEditSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.EDT;
import java.beans.PropertyChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/editor/NextEditInstaller;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLogger;", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/Disposable;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "tryInstall", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "installInlineCompletionListeners", "", "icHandler", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionHandler;", "uninstall", "uninstallInlineCompletionListeners", "doTryInstall", "intellij.ml.llm.nextEdits.frontend"})
@SourceDebugExtension(value={"SMAP\nNextEditInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditInstaller.kt\ncom/intellij/ml/llm/nextEdits/frontend/editor/NextEditInstaller\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FrontendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLoggerKt\n*L\n1#1,125:1\n1#2:126\n125#3:127\n*S KotlinDebug\n*F\n+ 1 NextEditInstaller.kt\ncom/intellij/ml/llm/nextEdits/frontend/editor/NextEditInstaller\n*L\n25#1:127\n*E\n"})
public final class NextEditInstaller {
    @NotNull
    public static final NextEditInstaller INSTANCE;
    @NotNull
    private static final FrontendNextEditDiagnosticsLogger LOG;
    @NotNull
    private static final Key<Disposable> KEY;

    private NextEditInstaller() {
    }

    @RequiresEdt
    public final boolean tryInstall(@NotNull Editor editor2, @NotNull Project project2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!EDT.isCurrentThreadEdt()) {
            FrontendNextEditDiagnosticsLogger.error$default(LOG, "Next Edit must be installed on EDT", null, 2, null);
            return false;
        }
        try {
            bl = this.doTryInstall(editor2, project2);
        }
        catch (Exception e) {
            LOG.error("Failed to install Next Edit", e);
            bl = false;
        }
        return bl;
    }

    @RequiresEdt
    public final void installInlineCompletionListeners(@NotNull Editor editor2, @NotNull InlineCompletionHandler icHandler) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)icHandler, (String)"icHandler");
        if (!EDT.isCurrentThreadEdt()) {
            FrontendNextEditDiagnosticsLogger.error$default(LOG, "Next Edit inline completion listeners must be installed EDT", null, 2, null);
            return;
        }
        try {
            InlineCompletionSessionStateTracker.Companion.install(editor2, icHandler);
            CallNextEditOnInlineCompletionSelectionListener.Companion.install(editor2, icHandler);
        }
        catch (Exception e) {
            LOG.error("Failed to install inline completion listeners for Next Edit", e);
        }
    }

    @RequiresEdt
    public final void uninstall(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!EDT.isCurrentThreadEdt()) {
            FrontendNextEditDiagnosticsLogger.error$default(LOG, "Next Edit must be uninstalled on EDT", null, 2, null);
            return;
        }
        try {
            Disposable disposable = (Disposable)editor2.getUserData(KEY);
            if (disposable != null) {
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            editor2.putUserData(KEY, null);
            FrontendNextEditEventsReporter.Factory.INSTANCE.clear(editor2);
        }
        catch (Exception e) {
            LOG.error("Failed to uninstall Next Edit", e);
        }
    }

    @RequiresEdt
    public final void uninstallInlineCompletionListeners(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!EDT.isCurrentThreadEdt()) {
            FrontendNextEditDiagnosticsLogger.error$default(LOG, "Next Edit inline completion listeners must be uninstalled on EDT", null, 2, null);
            return;
        }
        try {
            InlineCompletionSessionStateTracker.Companion.uninstall(editor2);
        }
        catch (Exception e) {
            LOG.error("Failed to uninstall inline completion listeners for Next Edit", e);
        }
    }

    private final boolean doTryInstall(Editor editor2, Project project2) {
        EditorImpl editorImpl = NextEditInstallUtils.INSTANCE.getEditorIfSupported(editor2, project2);
        if (editorImpl == null) {
            return false;
        }
        EditorImpl editorImpl2 = editorImpl;
        DocumentEx documentEx = editorImpl2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document2 = documentEx;
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile((Document)document2);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile file2 = virtualFile2;
        Disposable disposable = (Disposable)editorImpl2.getUserData(KEY);
        if (disposable != null) {
            Disposable it = disposable;
            boolean bl = false;
            LOG.debug((Function0<String>)((Function0)() -> NextEditInstaller.doTryInstall$lambda$0$0(file2)));
            INSTANCE.uninstall((Editor)editorImpl2);
        }
        FrontendNextEditSettings.Companion.initializeIfNeeded();
        Disposable disposable2 = NextEditInstallUtils.INSTANCE.createDisposableWithEditor((Editor)editorImpl2, file2);
        NextEditSessionManager.Companion.install((Editor)editorImpl2, project2);
        DisposerUtilKt.whenDisposed((Disposable)disposable2, () -> NextEditInstaller.doTryInstall$lambda$1(editorImpl2));
        editorImpl2.getCaretModel().addCaretListener((CaretListener)new NextEditCaretListener(), disposable2);
        editorImpl2.getDocument().addDocumentListener((DocumentListener)new NextEditDocumentListener((Editor)editorImpl2, project2), disposable2);
        editorImpl2.addPropertyChangeListener((PropertyChangeListener)new NextEditRefreshOnFontSizeChangesListener((Editor)editorImpl2), disposable2);
        editorImpl2.getInlayModel().addListener((InlayModel.Listener)new NextEditRefreshOnBlockInlayChangesListener(), disposable2);
        editorImpl2.getFoldingModel().addListener((FoldingListener)new NextEditRefreshOnFoldingChangesListener((Editor)editorImpl2), disposable2);
        editorImpl2.getSelectionModel().addSelectionListener((SelectionListener)new CancelNextEditOnSelectionListener(), disposable2);
        NextEditSuggestedRefactoringStateProcessor.Companion.attachToEditor(project2, editorImpl2);
        editorImpl2.putUserData(KEY, (Object)disposable2);
        return true;
    }

    private static final String doTryInstall$lambda$0$0(VirtualFile $file) {
        return "Next Edit is going to be re-initialized for " + $file.getPath();
    }

    private static final Unit doTryInstall$lambda$1(EditorImpl $editorImpl) {
        NextEditSessionManager.Companion.uninstall((Editor)$editorImpl);
        return Unit.INSTANCE;
    }

    static {
        NextEditInstaller $this$thisNextEditLogger$iv = INSTANCE = new NextEditInstaller();
        boolean $i$f$thisNextEditLogger = false;
        LOG = FrontendNextEditDiagnosticsLogger.Companion.get$intellij_ml_llm_nextEdits_frontend(NextEditInstaller.class);
        Key key = Key.create((String)"ml.llm.next.edit.frontend.disposable");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }
}

