/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.listeners;

import com.intellij.ml.llm.nextEdits.common.NextEditTriggerReason;
import com.intellij.ml.llm.nextEdits.frontend.services.NextEditRequestService;
import com.intellij.ml.llm.nextEdits.frontend.settings.FrontendNextEditSettingsKt;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/listeners/NextEditEditorEnterHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "originalHandler", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "isEnabledForCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "doExecute", "", "intellij.ml.llm.nextEdits.frontend"})
public final class NextEditEditorEnterHandler
extends EditorActionHandler {
    @NotNull
    private final EditorActionHandler originalHandler;

    public NextEditEditorEnterHandler(@NotNull EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        this.originalHandler = originalHandler;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, @Nullable DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.originalHandler.isEnabled(editor2, caret, dataContext2);
    }

    protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Caret caret2 = caret;
        if (caret2 == null) {
            Caret caret3 = editor2.getCaretModel().getCurrentCaret();
            caret2 = caret3;
            Intrinsics.checkNotNullExpressionValue((Object)caret3, (String)"getCurrentCaret(...)");
        }
        Caret currentCaret = caret2;
        int initialOffset = currentCaret.getOffset();
        this.originalHandler.execute(editor2, caret, dataContext2);
        int finalOffset = currentCaret.getOffset();
        Project project2 = (Project)dataContext2.getData(CommonDataKeys.PROJECT);
        if (!FrontendNextEditSettingsKt.isNextEditEnabled()) {
            return;
        }
        if (initialOffset < finalOffset && project2 != null) {
            NextEditRequestService.Companion.getInstance(project2).newRequest(editor2, NextEditTriggerReason.TYPING);
        }
    }
}

