/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.diff.general;

import com.intellij.ml.llm.nextEdits.common.provider.ActionHintPresentation;
import com.intellij.ml.llm.nextEdits.frontend.FrontendNextEditBundle;
import com.intellij.ml.llm.nextEdits.frontend.editor.NextEditRenderingCustomizer;
import com.intellij.ml.llm.nextEdits.frontend.session.highlight.NextEditHighlightingInfo;
import com.intellij.ml.llm.nextEdits.frontend.session.highlight.NextEditHighlightingInfoKt;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditGeneralDiffModel;
import com.intellij.ml.llm.nextEdits.frontend.ui.NextEditColors;
import com.intellij.ml.llm.nextEdits.frontend.ui.NextEditRoundedPanelKt;
import com.intellij.ml.llm.nextEdits.frontend.ui.diff.EnrichedNextEditDiffPresentation;
import com.intellij.ml.llm.nextEdits.frontend.ui.diff.general.NextEditGeneralViewUtils;
import com.intellij.ml.llm.nextEdits.frontend.ui.inlay.NextEditInlineShortcutInlaysKt;
import com.intellij.ml.llm.nextEdits.frontend.ui.inlay.NextEditShortcutHint;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.ColoredSeparator;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.GridAutofitPanel;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditComponentFactory;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditCornersArc;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditEditorUtil;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditHighlightRange;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditRenderingUtils;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.OverEditorPanelFactory;
import com.intellij.ml.llm.nextEdits.frontend.ui.view.NextEditShortcutHintType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0015\b\"\u0018\u00002\u00020\u0001:\u0001dBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J \u0010D\u001a\u00020#2\u0006\u0010E\u001a\u00020F2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010G\u001a\u00020F2\u0006\u0010E\u001a\u00020F2\u0006\u0010&\u001a\u00020'H\u0002J\u001a\u0010H\u001a\u0004\u0018\u00010F2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\n\u0010I\u001a\u0004\u0018\u00010JH\u0002J\u0012\u0010K\u001a\u0004\u0018\u00010F2\u0006\u0010L\u001a\u00020\u001dH\u0002J\f\u0010M\u001a\u00020#*\u00020FH\u0002J\b\u0010X\u001a\u00020\u001dH\u0002J\u0010\u0010Y\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010Z\u001a\u00020\u001dH\u0002J\b\u0010[\u001a\u00020\u001dH\u0002J\u0010\u0010\\\u001a\u00020\u001d2\u0006\u0010]\u001a\u00020\u001dH\u0004J\u0018\u0010^\u001a\u00020\u001d2\u0006\u0010_\u001a\u00020\u001d2\u0006\u0010`\u001a\u00020\u001dH\u0004J\u0018\u0010a\u001a\u00020#2\u0006\u0010b\u001a\u00020\u000b2\u0006\u0010c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0012\u0010(\u001a\u00020)X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001fR\u0012\u0010.\u001a\u00020\u001dX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001fR\u0014\u00100\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001fR\u0014\u00102\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001fR\u0014\u00104\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001fR\u0014\u00106\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u001fR\u0014\u00108\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001fR\u0014\u0010:\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u001fR\u001b\u0010<\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b=\u0010\u001fR\u0014\u0010@\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u001fR\u0014\u0010B\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u001fR\u0014\u0010N\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u001fR\u001b\u0010P\u001a\u00020Q8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bT\u0010?\u001a\u0004\bR\u0010SR\u001b\u0010U\u001a\u00020\u001d8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bW\u0010?\u001a\u0004\bV\u0010\u001f\u00a8\u0006e\u00b2\u0006\n\u0010f\u001a\u00020JX\u008a\u0084\u0002"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditPanelViewBase;", "", "diff", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditGeneralDiffModel;", "presentation", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "additionalHighlighting", "Lcom/intellij/ml/llm/nextEdits/frontend/session/highlight/NextEditHighlightingInfo;", "actionHintPresentation", "Lcom/intellij/ml/llm/nextEdits/common/provider/ActionHintPresentation;", "<init>", "(Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditGeneralDiffModel;Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation;Lcom/intellij/openapi/fileTypes/FileType;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ml/llm/nextEdits/frontend/session/highlight/NextEditHighlightingInfo;Lcom/intellij/ml/llm/nextEdits/common/provider/ActionHintPresentation;)V", "getDiff", "()Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditGeneralDiffModel;", "getPresentation", "()Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation;", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "startOffset", "", "getStartOffset", "()I", "endOffset", "getEndOffset", "show", "", "hintType", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditShortcutHintType;", "disposable", "Lcom/intellij/openapi/Disposable;", "place", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditPanelViewBase$Place;", "getPlace", "()Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditPanelViewBase$Place;", "originalStartLine", "getOriginalStartLine", "additionalSpaceUnderInPixels", "getAdditionalSpaceUnderInPixels", "originalEndLine", "getOriginalEndLine", "originalStartLineOffset", "getOriginalStartLineOffset", "originalEndLineOffset", "getOriginalEndLineOffset", "newLinesNumber", "getNewLinesNumber", "spaceWidth", "getSpaceWidth", "editorLineHeight", "getEditorLineHeight", "commonIndentToTrim", "getCommonIndentToTrim", "commonIndentToTrim$delegate", "Lkotlin/Lazy;", "indentToTrimFromOriginalText", "getIndentToTrimFromOriginalText", "indentToTrimFromNewText", "getIndentToTrimFromNewText", "renderViewPanel", "diffEditorComponent", "Ljavax/swing/JComponent;", "getDiffViewPanel", "getShortcutSidebarPanel", "getEditorBackgroundColorForShortcutHint", "Ljava/awt/Color;", "createEmptyPanelIfNeeded", "heightInPixels", "removePaddingsAndMargins", "topLeftOffsetForFocusedFrame", "getTopLeftOffsetForFocusedFrame", "originalTextFrameSize", "Ljava/awt/Dimension;", "getOriginalTextFrameSize", "()Ljava/awt/Dimension;", "originalTextFrameSize$delegate", "minimalWidthForNewText", "getMinimalWidthForNewText", "minimalWidthForNewText$delegate", "computeOriginalTextHeightInPixels", "addSpaceUnderForDiffEditor", "getCommonIndentForOriginalText", "getCommonIndentForNewText", "ceilToSpaceWidth", "value", "getOriginalLineWidthInPixels", "line", "skipCharactersNumber", "increaseEditorWidth", "diffEditor", "widthDelta", "Place", "intellij.ml.llm.nextEdits.frontend", "defaultBackground"})
@SourceDebugExtension(value={"SMAP\nNextEditDiffGeneralView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditDiffGeneralView.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditPanelViewBase\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,471:1\n1104#2,3:472\n1#3:475\n774#4:476\n865#4,2:477\n*S KotlinDebug\n*F\n+ 1 NextEditDiffGeneralView.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditPanelViewBase\n*L\n171#1:472,3\n395#1:476\n395#1:477,2\n*E\n"})
abstract class NextEditPanelViewBase {
    @NotNull
    private final NextEditGeneralDiffModel diff;
    @NotNull
    private final EnrichedNextEditDiffPresentation presentation;
    @NotNull
    private final FileType fileType;
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final NextEditHighlightingInfo additionalHighlighting;
    @Nullable
    private final ActionHintPresentation actionHintPresentation;
    private final int originalStartLine;
    private final int originalEndLine;
    private final int originalStartLineOffset;
    private final int originalEndLineOffset;
    private final int newLinesNumber;
    private final int spaceWidth;
    private final int editorLineHeight;
    @NotNull
    private final Lazy commonIndentToTrim$delegate;
    @NotNull
    private final Lazy originalTextFrameSize$delegate;
    @NotNull
    private final Lazy minimalWidthForNewText$delegate;

    /*
     * WARNING - void declaration
     */
    public NextEditPanelViewBase(@NotNull NextEditGeneralDiffModel diff2, @NotNull EnrichedNextEditDiffPresentation presentation2, @NotNull FileType fileType2, @NotNull Project project2, @NotNull Editor editor2, @NotNull NextEditHighlightingInfo additionalHighlighting, @Nullable ActionHintPresentation actionHintPresentation) {
        void $this$count$iv;
        Intrinsics.checkNotNullParameter((Object)diff2, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)fileType2, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)additionalHighlighting, (String)"additionalHighlighting");
        this.diff = diff2;
        this.presentation = presentation2;
        this.fileType = fileType2;
        this.project = project2;
        this.editor = editor2;
        this.additionalHighlighting = additionalHighlighting;
        this.actionHintPresentation = actionHintPresentation;
        this.originalStartLine = this.editor.getDocument().getLineNumber(this.getStartOffset());
        this.originalEndLine = this.editor.getDocument().getLineNumber(Math.max(this.getStartOffset(), this.getEndOffset()));
        this.originalStartLineOffset = this.editor.getDocument().getLineStartOffset(this.originalStartLine);
        this.originalEndLineOffset = this.editor.getDocument().getLineEndOffset(this.originalEndLine);
        CharSequence charSequence = this.presentation.getText();
        NextEditPanelViewBase nextEditPanelViewBase = this;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int n = count$iv;
        nextEditPanelViewBase.newLinesNumber = n + 1;
        this.spaceWidth = EditorUtil.getPlainSpaceWidth((Editor)this.editor);
        this.editorLineHeight = this.editor.getLineHeight();
        this.commonIndentToTrim$delegate = LazyKt.lazy(() -> NextEditPanelViewBase.commonIndentToTrim_delegate$lambda$0(this));
        this.originalTextFrameSize$delegate = LazyKt.lazy(() -> NextEditPanelViewBase.originalTextFrameSize_delegate$lambda$0(this));
        this.minimalWidthForNewText$delegate = LazyKt.lazy(() -> NextEditPanelViewBase.minimalWidthForNewText_delegate$lambda$0(this));
    }

    @NotNull
    protected final NextEditGeneralDiffModel getDiff() {
        return this.diff;
    }

    @NotNull
    protected final EnrichedNextEditDiffPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    protected final FileType getFileType() {
        return this.fileType;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final Editor getEditor() {
        return this.editor;
    }

    private final int getStartOffset() {
        return this.diff.getOrigin().getFragment().getStartOffset1();
    }

    private final int getEndOffset() {
        return this.diff.getOrigin().getFragment().getEndOffset1();
    }

    public final void show(@NotNull NextEditShortcutHintType hintType, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)((Object)hintType), (String)"hintType");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        NextEditComponentFactory nextEditComponentFactory = NextEditComponentFactory.INSTANCE;
        EnrichedNextEditDiffPresentation enrichedNextEditDiffPresentation = this.presentation;
        FileType fileType2 = this.fileType;
        Project project2 = this.project;
        int n = NextEditEditorUtil.INSTANCE.getFontSize(this.editor);
        int n2 = this.getIndentToTrimFromNewText();
        Color color = NextEditRenderingUtils.INSTANCE.getGreenEditorBackgroundColor(this.editor);
        NextEditHighlightingInfo nextEditHighlightingInfo = NextEditHighlightingInfoKt.shiftLeft(this.additionalHighlighting, this.getStartOffset());
        EditorEx diffEditor = nextEditComponentFactory.createEditor(disposable, enrichedNextEditDiffPresentation, project2, fileType2, n, n2, color, nextEditHighlightingInfo);
        this.increaseEditorWidth((Editor)diffEditor, this.spaceWidth);
        JComponent jComponent = diffEditor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        this.renderViewPanel(jComponent, hintType, disposable);
        this.addSpaceUnderForDiffEditor(disposable);
    }

    @NotNull
    protected abstract Place getPlace();

    protected final int getOriginalStartLine() {
        return this.originalStartLine;
    }

    protected abstract int getAdditionalSpaceUnderInPixels();

    protected final int getOriginalEndLine() {
        return this.originalEndLine;
    }

    protected final int getOriginalStartLineOffset() {
        return this.originalStartLineOffset;
    }

    protected final int getOriginalEndLineOffset() {
        return this.originalEndLineOffset;
    }

    protected final int getNewLinesNumber() {
        return this.newLinesNumber;
    }

    protected final int getSpaceWidth() {
        return this.spaceWidth;
    }

    protected final int getEditorLineHeight() {
        return this.editorLineHeight;
    }

    private final int getCommonIndentToTrim() {
        Lazy lazy = this.commonIndentToTrim$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final int getIndentToTrimFromOriginalText() {
        return this.getCommonIndentToTrim();
    }

    private final int getIndentToTrimFromNewText() {
        return this.getCommonIndentToTrim();
    }

    private final void renderViewPanel(JComponent diffEditorComponent, NextEditShortcutHintType hintType, Disposable disposable) {
        JComponent diffPanel = this.getDiffViewPanel(diffEditorComponent, disposable);
        JComponent shortcutSidebarPanel = this.getShortcutSidebarPanel(hintType, disposable);
        Object[] objectArray = new JComponent[]{diffPanel, shortcutSidebarPanel};
        GridAutofitPanel panel2 = new GridAutofitPanel(CollectionsKt.listOf((Object)CollectionsKt.listOfNotNull((Object[])objectArray)));
        panel2.getAccessibleContext().setAccessibleName(FrontendNextEditBundle.message("next.edit.accessible.context.diff.panel", new Object[0]));
        OverEditorPanelFactory panelFactory = new OverEditorPanelFactory(this.editor, disposable);
        panelFactory.withinBatch((Function0<Unit>)((Function0)() -> NextEditPanelViewBase.renderViewPanel$lambda$0(panelFactory, panel2, this)));
    }

    private final JComponent getDiffViewPanel(JComponent diffEditorComponent, Disposable disposable) {
        Color color;
        JPanel panel2 = new JPanel();
        panel2.setOpaque(false);
        panel2.setBackground(null);
        Color borderColor = this.editor.getColorsScheme().getColor(NextEditColors.INSTANCE.getDIFF_PANEL_BORDER());
        int axis = switch (WhenMappings.$EnumSwitchMapping$0[this.getPlace().ordinal()]) {
            case 1 -> 0;
            case 2 -> 1;
            default -> throw new NoWhenBranchMatchedException();
        };
        panel2.setLayout(new BoxLayout(panel2, axis));
        JComponent topComponent = NextEditComponentFactory.INSTANCE.createEmptyPanel(this.getOriginalTextFrameSize());
        this.removePaddingsAndMargins(topComponent);
        int arcValue = 7;
        NextEditCornersArc arc = switch (WhenMappings.$EnumSwitchMapping$0[this.getPlace().ordinal()]) {
            case 1 -> new NextEditCornersArc(arcValue, 0, 0, arcValue);
            case 2 -> new NextEditCornersArc(arcValue, arcValue, 0, 0);
            default -> throw new NoWhenBranchMatchedException();
        };
        List<NextEditHighlightRange> highlightsInOriginal = NextEditGeneralViewUtils.INSTANCE.getHighlightRangesInOriginalDocument(this.diff);
        boolean bl = Registry.Companion.is("llm.nextEdit.render.red.background.under.diff", false);
        if (bl) {
            color = NextEditRenderingUtils.INSTANCE.getRedEditorBackgroundColor(this.editor);
        } else if (!bl) {
            color = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Color colorUnderText = color;
        NextEditRenderingUtils nextEditRenderingUtils = NextEditRenderingUtils.INSTANCE;
        Editor editor2 = this.editor;
        int n = this.originalStartLineOffset;
        int n2 = this.originalEndLineOffset;
        nextEditRenderingUtils.drawBackgroundUnderComponent(editor2, topComponent, n, n2, colorUnderText, arc, highlightsInOriginal, disposable);
        panel2.add(topComponent);
        int separatorOrientation = switch (WhenMappings.$EnumSwitchMapping$0[this.getPlace().ordinal()]) {
            case 1 -> 1;
            case 2 -> 0;
            default -> throw new NoWhenBranchMatchedException();
        };
        ColoredSeparator separator = new ColoredSeparator(borderColor, 1, separatorOrientation);
        panel2.add(separator);
        this.removePaddingsAndMargins(diffEditorComponent);
        panel2.add(diffEditorComponent);
        return NextEditRoundedPanelKt.makeRounded$default(panel2, borderColor, 0, 0, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent getShortcutSidebarPanel(NextEditShortcutHintType hintType, Disposable disposable) {
        List list;
        EditorEx editorEx;
        EditorEx editorEx2;
        NextEditShortcutHint nextEditShortcutHint;
        switch (WhenMappings.$EnumSwitchMapping$1[hintType.ordinal()]) {
            case 1: {
                nextEditShortcutHint = new NextEditShortcutHint.ApplyDiff.Replace(this.actionHintPresentation);
                break;
            }
            case 2: {
                nextEditShortcutHint = new NextEditShortcutHint.Jump(this.actionHintPresentation);
                break;
            }
            case 3: {
                return null;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        NextEditShortcutHint shortcutHint = nextEditShortcutHint;
        int emptyPixelsOnBottom = switch (WhenMappings.$EnumSwitchMapping$0[this.getPlace().ordinal()]) {
            case 1 -> Math.max(this.getOriginalTextFrameSize().height, this.newLinesNumber * this.editorLineHeight) - this.editorLineHeight;
            case 2 -> this.getOriginalTextFrameSize().height + this.editorLineHeight * Math.max(0, this.newLinesNumber - 1);
            default -> throw new NoWhenBranchMatchedException();
        };
        Color customEditorBackgroundColor = this.getEditorBackgroundColorForShortcutHint();
        JComponent bottomSpaceComponent = this.createEmptyPanelIfNeeded(emptyPixelsOnBottom);
        EditorEx shortcutEditor = NextEditComponentFactory.INSTANCE.createEmptyEditor(disposable, this.project, NextEditEditorUtil.INSTANCE.getFontSize(this.editor), customEditorBackgroundColor);
        NextEditInlineShortcutInlaysKt.renderShortcutHint((Editor)shortcutEditor, 0, shortcutHint);
        if (shortcutHint.getShowRatings()) {
            EditorEx nesRatingEditor = editorEx2 = NextEditComponentFactory.INSTANCE.createEmptyEditor(disposable, this.project, NextEditEditorUtil.INSTANCE.getFontSize(this.editor), customEditorBackgroundColor);
            boolean bl = false;
            NextEditInlineShortcutInlaysKt.renderNextEditRatingControls((Editor)nesRatingEditor, 0, this.editor, disposable);
            editorEx = editorEx2;
        } else {
            editorEx = null;
        }
        EditorEx nesRatingEditor = editorEx;
        editorEx2 = new List[2];
        Object[] objectArray = new JComponent[2];
        objectArray[0] = shortcutEditor.getContentComponent();
        EditorEx editorEx3 = nesRatingEditor;
        objectArray[1] = editorEx3 != null ? editorEx3.getComponent() : null;
        editorEx2[0] = CollectionsKt.listOfNotNull((Object[])objectArray);
        EditorEx editorEx4 = editorEx2;
        int n = 1;
        JComponent jComponent = bottomSpaceComponent;
        if (jComponent != null) {
            void it;
            JComponent bl = jComponent;
            int n2 = n;
            EditorEx editorEx5 = editorEx4;
            boolean bl2 = false;
            List list2 = CollectionsKt.listOf((Object)it);
            editorEx4 = editorEx5;
            n = n2;
            list = list2;
        } else {
            list = null;
        }
        editorEx4[n] = list;
        List list3 = CollectionsKt.listOfNotNull((Object[])editorEx2);
        return new GridAutofitPanel(list3);
    }

    private final Color getEditorBackgroundColorForShortcutHint() {
        Color color;
        int currentLine = this.editor.getCaretModel().getLogicalPosition().line;
        Lazy defaultBackground$delegate = LazyKt.lazy(() -> NextEditPanelViewBase.getEditorBackgroundColorForShortcutHint$lambda$0(this));
        if (currentLine == this.originalStartLine) {
            color = this.editor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
            if (color == null) {
                color = NextEditPanelViewBase.getEditorBackgroundColorForShortcutHint$lambda$1((Lazy<? extends Color>)defaultBackground$delegate);
            }
        } else {
            color = NextEditPanelViewBase.getEditorBackgroundColorForShortcutHint$lambda$1((Lazy<? extends Color>)defaultBackground$delegate);
        }
        return color;
    }

    private final JComponent createEmptyPanelIfNeeded(int heightInPixels) {
        if (heightInPixels <= 0) {
            return null;
        }
        return NextEditComponentFactory.INSTANCE.createEmptyPanel(0, Math.max(heightInPixels, 0));
    }

    private final void removePaddingsAndMargins(JComponent $this$removePaddingsAndMargins) {
        $this$removePaddingsAndMargins.setBorder(null);
    }

    private final int getTopLeftOffsetForFocusedFrame() {
        return this.originalStartLineOffset + this.getIndentToTrimFromOriginalText();
    }

    @NotNull
    protected final Dimension getOriginalTextFrameSize() {
        Lazy lazy = this.originalTextFrameSize$delegate;
        return (Dimension)lazy.getValue();
    }

    protected final int getMinimalWidthForNewText() {
        Lazy lazy = this.minimalWidthForNewText$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final int computeOriginalTextHeightInPixels() {
        int topY = this.editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)this.originalStartLine, (int)0)).y;
        int bottomY = this.editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)this.originalEndLine, (int)0)).y + this.editorLineHeight;
        return bottomY - topY;
    }

    private final void addSpaceUnderForDiffEditor(Disposable disposable) {
        if (this.getAdditionalSpaceUnderInPixels() <= 0) {
            return;
        }
        NextEditRenderingUtils.INSTANCE.renderVisualEmptySpaceUnder(this.editor, this.originalEndLineOffset, this.getAdditionalSpaceUnderInPixels(), disposable);
    }

    private final int getCommonIndentForOriginalText() {
        Document document2 = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        return NextEditGeneralViewUtils.INSTANCE.getCommonUntouchedIndentInDocument(document2, this.originalStartLine, this.originalEndLine, this.diff);
    }

    /*
     * WARNING - void declaration
     */
    private final int getCommonIndentForNewText() {
        Object object;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)this.presentation.getText());
        boolean $i$f$filter = false;
        Object object2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            String it = (String)iterator.next();
            boolean bl = false;
            object2 = NextEditGeneralViewUtils.INSTANCE.numberOfLeadingWhitespaces(it);
            while (iterator.hasNext()) {
                String it2 = (String)iterator.next();
                $i$a$-minOfOrNull-NextEditPanelViewBase$getCommonIndentForNewText$2 = false;
                Comparable comparable = Integer.valueOf(NextEditGeneralViewUtils.INSTANCE.numberOfLeadingWhitespaces(it2));
                if (object2.compareTo(comparable) <= 0) continue;
                object2 = comparable;
            }
            object = object2;
        }
        Integer n = (Integer)object;
        return n != null ? n : 0;
    }

    protected final int ceilToSpaceWidth(int value) {
        return (value + this.spaceWidth - 1) / this.spaceWidth * this.spaceWidth;
    }

    protected final int getOriginalLineWidthInPixels(int line, int skipCharactersNumber) {
        int endOffset;
        int startOffset = this.editor.getDocument().getLineStartOffset(line) + skipCharactersNumber;
        if (startOffset >= (endOffset = this.editor.getDocument().getLineEndOffset(line))) {
            return 0;
        }
        return this.editor.offsetToXY((int)endOffset).x - this.editor.offsetToXY((int)startOffset).x;
    }

    private final void increaseEditorWidth(Editor diffEditor, int widthDelta) {
        if (widthDelta <= 0) {
            return;
        }
        int n = diffEditor.getDocument().getLineCount();
        for (int line = 0; line < n; ++line) {
            int lineEndOffset = diffEditor.getDocument().getLineEndOffset(line);
            diffEditor.getInlayModel().addInlineElement(lineEndOffset, true, arg_0 -> NextEditPanelViewBase.increaseEditorWidth$lambda$0(widthDelta, arg_0));
        }
    }

    private static final int commonIndentToTrim_delegate$lambda$0(NextEditPanelViewBase this$0) {
        int common = Math.min(this$0.getCommonIndentForOriginalText(), this$0.getCommonIndentForNewText());
        return Math.max(common - 1, 0);
    }

    private static final Unit renderViewPanel$lambda$0(OverEditorPanelFactory $panelFactory, GridAutofitPanel $panel, NextEditPanelViewBase this$0) {
        OverEditorPanelFactory.attachPanelToOffset$default($panelFactory, $panel, this$0.getTopLeftOffsetForFocusedFrame(), 0, 4, null);
        return Unit.INSTANCE;
    }

    private static final Color getEditorBackgroundColorForShortcutHint$lambda$0(NextEditPanelViewBase this$0) {
        return NextEditRenderingCustomizer.Companion.getOrDefault(this$0.editor).getEditorBackgroundColor(this$0.editor);
    }

    private static final Color getEditorBackgroundColorForShortcutHint$lambda$1(Lazy<? extends Color> $defaultBackground$delegate) {
        Lazy<? extends Color> lazy = $defaultBackground$delegate;
        return (Color)lazy.getValue();
    }

    private static final Dimension originalTextFrameSize_delegate$lambda$0(NextEditPanelViewBase this$0) {
        int height = this$0.computeOriginalTextHeightInPixels();
        Iterator iterator = ((Iterable)new IntRange(this$0.originalStartLine, this$0.originalEndLine)).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        int line = ((IntIterator)iterator).nextInt();
        boolean bl = false;
        int n = this$0.getOriginalLineWidthInPixels(line, this$0.getIndentToTrimFromOriginalText());
        while (iterator.hasNext()) {
            int line2 = ((IntIterator)iterator).nextInt();
            $i$a$-maxOf-NextEditPanelViewBase$originalTextFrameSize$2$width$1 = false;
            int n2 = this$0.getOriginalLineWidthInPixels(line2, this$0.getIndentToTrimFromOriginalText());
            if (n >= n2) continue;
            n = n2;
        }
        int width = n;
        return new Dimension(this$0.ceilToSpaceWidth(width) + this$0.spaceWidth, height);
    }

    private static final int minimalWidthForNewText_delegate$lambda$0(NextEditPanelViewBase this$0) {
        Iterator iterator = ((Iterable)StringsKt.lines((CharSequence)this$0.presentation.getText())).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        String line = (String)iterator.next();
        boolean bl = false;
        int n = EditorUtil.textWidth((Editor)this$0.editor, (CharSequence)line, (int)this$0.getIndentToTrimFromNewText(), (int)line.length(), (int)0, (int)0);
        while (iterator.hasNext()) {
            String line2 = (String)iterator.next();
            $i$a$-maxOf-NextEditPanelViewBase$minimalWidthForNewText$2$width$1 = false;
            int n2 = EditorUtil.textWidth((Editor)this$0.editor, (CharSequence)line2, (int)this$0.getIndentToTrimFromNewText(), (int)line2.length(), (int)0, (int)0);
            if (n >= n2) continue;
            n = n2;
        }
        int width = n;
        return this$0.ceilToSpaceWidth(width) + this$0.spaceWidth * 6;
    }

    private static final int increaseEditorWidth$lambda$0(int $widthDelta, Inlay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $widthDelta;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditPanelViewBase$Place;", "", "<init>", "(Ljava/lang/String;I)V", "RIGHT", "UNDER", "intellij.ml.llm.nextEdits.frontend"})
    public static final class Place
    extends Enum<Place> {
        public static final /* enum */ Place RIGHT = new Place();
        public static final /* enum */ Place UNDER = new Place();
        private static final /* synthetic */ Place[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Place[] values() {
            return (Place[])$VALUES.clone();
        }

        public static Place valueOf(String value) {
            return Enum.valueOf(Place.class, value);
        }

        @NotNull
        public static EnumEntries<Place> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = placeArray = new Place[]{Place.RIGHT, Place.UNDER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Place.values().length];
            try {
                nArray[Place.RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Place.UNDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[NextEditShortcutHintType.values().length];
            try {
                nArray[NextEditShortcutHintType.ACCEPT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditShortcutHintType.JUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditShortcutHintType.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

