/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.util;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ApplicationKt;
import java.awt.Font;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/NextEditEditorUtil;", "", "<init>", "()V", "isCorrespondingLineVisible", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "makeVisible", "", "range", "Lcom/intellij/openapi/util/TextRange;", "getFont", "Ljava/awt/Font;", "getFontSize", "getFontSizeAsFloat", "", "getStickyLinesHeight", "intellij.ml.llm.nextEdits.frontend"})
public final class NextEditEditorUtil {
    @NotNull
    public static final NextEditEditorUtil INSTANCE = new NextEditEditorUtil();

    private NextEditEditorUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCorrespondingLineVisible(@NotNull Editor editor2, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (ApplicationKt.getApplication().isHeadlessEnvironment()) {
            return true;
        }
        int lineTopY = editor2.offsetToXY((int)offset).y;
        int lineBottomY = lineTopY + editor2.getLineHeight();
        Rectangle rectangle = editor2.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        IntRange visibleYRange = RangesKt.until((int)(visibleArea.y + this.getStickyLinesHeight(editor2)), (int)(visibleArea.y + visibleArea.height));
        int n = visibleYRange.getFirst();
        if (lineTopY > visibleYRange.getLast()) return false;
        if (n > lineTopY) return false;
        boolean bl = true;
        if (!bl) return false;
        n = visibleYRange.getFirst();
        if (lineBottomY > visibleYRange.getLast()) return false;
        if (n > lineBottomY) return false;
        return true;
    }

    public final void makeVisible(@NotNull Editor editor2, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (ApplicationKt.getApplication().isHeadlessEnvironment() || offset > editor2.getDocument().getTextLength() || offset < 0) {
            return;
        }
        editor2.getScrollingModel().scrollTo(editor2.offsetToLogicalPosition(offset), ScrollType.RELATIVE);
    }

    public final void makeVisible(@NotNull Editor editor2, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.makeVisible(editor2, range.getEndOffset());
        this.makeVisible(editor2, range.getStartOffset());
    }

    @NotNull
    public final Font getFont(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Font font = editor2.getColorsScheme().getFont(EditorFontType.PLAIN).deriveFont(this.getFontSizeAsFloat(editor2));
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"deriveFont(...)");
        return font;
    }

    public final int getFontSize(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return editor2.getColorsScheme().getEditorFontSize();
    }

    public final float getFontSizeAsFloat(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return editor2.getColorsScheme().getEditorFontSize2D();
    }

    private final int getStickyLinesHeight(Editor editor2) {
        EditorImpl editorImpl = editor2 instanceof EditorImpl ? (EditorImpl)editor2 : null;
        return editorImpl != null ? editorImpl.getStickyLinesPanelHeight() : 0;
    }
}

