/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.util;

import com.intellij.ml.llm.nextEdits.frontend.diagnostics.FrontendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.frontend.editor.NextEditRenderingCustomizer;
import com.intellij.ml.llm.nextEdits.frontend.ui.NextEditColors;
import com.intellij.ml.llm.nextEdits.frontend.ui.inlay.NextEditInlayRendererMarker;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditCornersArc;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditHighlightRange;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.PaintRectangleUnderComponentHighlighterRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.EditorGutterColor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.util.Disposer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J6\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJN\u0010\u001e\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u001c\u001a\u00020\u001dJ&\u0010(\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dJ&\u0010+\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010-\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010/\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u00101\u001a\u00020\u0015*\u0002022\u0006\u00103\u001a\u00020\tH\u0002J\f\u00104\u001a\u00020\u001b*\u00020\tH\u0002J\"\u00105\u001a\u00020\u0015*\u00020 2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001507H\u0002J\b\u00108\u001a\u00020\u000eH\u0002J\f\u00109\u001a\u00020\u0007*\u00020\tH\u0002J \u0010:\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/NextEditRenderingUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLogger;", "getRedEditorBackgroundColor", "Ljava/awt/Color;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getGreenInlineAdditionColor", "getGreenEditorBackgroundColor", "getBaseGreenColor", "getLineToEditMarkerAttributesForLines", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getLineToEditMarkerAttributesForLineNumbersArea", "getShadeOfLineToEditMarkerAttributes", "shadeOn", "alpha", "", "drawBackground", "", "color", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/NextEditColors$BackgroundColor;", "startOffset", "endOffset", "highlightIndents", "", "disposable", "Lcom/intellij/openapi/Disposable;", "drawBackgroundUnderComponent", "component", "Ljavax/swing/JComponent;", "affectedStartOffset", "affectedEndOffset", "arc", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/NextEditCornersArc;", "highlights", "", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/NextEditHighlightRange;", "renderVisualEmptySpaceUnder", "offset", "heightInPixels", "renderVisualEmptyLinesUnder", "emptyLinesCount", "getColoredEditorBackgroundColor", "shade", "mergeColors", "onColor", "excludeFromStickyLines", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "currentEditor", "isStickyLinesPanel", "onRectangleChanged", "action", "Lkotlin/Function0;", "emptyAttributes", "getActualBackgroundColor", "validateOffsets", "intellij.ml.llm.nextEdits.frontend"})
@SourceDebugExtension(value={"SMAP\nNextEditRenderingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditRenderingUtils.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/util/NextEditRenderingUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FrontendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLoggerKt\n*L\n1#1,295:1\n1#2:296\n1869#3,2:297\n125#4:299\n*S KotlinDebug\n*F\n+ 1 NextEditRenderingUtils.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/util/NextEditRenderingUtils\n*L\n135#1:297,2\n32#1:299\n*E\n"})
public final class NextEditRenderingUtils {
    @NotNull
    public static final NextEditRenderingUtils INSTANCE;
    @NotNull
    private static final FrontendNextEditDiagnosticsLogger LOG;

    private NextEditRenderingUtils() {
    }

    @Nullable
    public final Color getRedEditorBackgroundColor(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Color color = editor2.getColorsScheme().getColor(NextEditColors.INSTANCE.getRED_BACKGROUND_BASE());
        if (color == null) {
            return null;
        }
        Color color2 = color;
        return this.getColoredEditorBackgroundColor(editor2, color2, 200);
    }

    @Nullable
    public final Color getGreenInlineAdditionColor(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return this.getBaseGreenColor(editor2);
    }

    @Nullable
    public final Color getGreenEditorBackgroundColor(@NotNull Editor editor2) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Color color2 = this.getBaseGreenColor(editor2);
        if (color2 != null) {
            Color it = color2;
            boolean bl = false;
            color = INSTANCE.getColoredEditorBackgroundColor(editor2, it, 120);
        } else {
            color = null;
        }
        return color;
    }

    @Nullable
    public final Color getBaseGreenColor(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        TextAttributes textAttributes = editor2.getColorsScheme().getAttributes(DiffColors.DIFF_INSERTED);
        return textAttributes != null ? textAttributes.getBackgroundColor() : null;
    }

    @NotNull
    public final TextAttributes getLineToEditMarkerAttributesForLines(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return this.getShadeOfLineToEditMarkerAttributes(editor2, this.getActualBackgroundColor(editor2), 190);
    }

    @NotNull
    public final TextAttributes getLineToEditMarkerAttributesForLineNumbersArea(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Color color = editor2 instanceof EditorImpl ? EditorGutterColor.getEditorGutterBackgroundColor((EditorImpl)((EditorImpl)editor2), (boolean)((EditorImpl)editor2).getGutterComponentEx().isPaintBackground()) : this.getActualBackgroundColor(editor2);
        Intrinsics.checkNotNull((Object)color);
        Color editorGutterColor = color;
        return this.getShadeOfLineToEditMarkerAttributes(editor2, editorGutterColor, 110);
    }

    private final TextAttributes getShadeOfLineToEditMarkerAttributes(Editor editor2, Color shadeOn, int alpha) {
        Color baseColor = editor2.getColorsScheme().getColor(NextEditColors.INSTANCE.getEDIT_RANGE_LINE_BACKGROUND());
        if (baseColor == null) {
            LOG.debug("Cannot find color for key " + NextEditColors.INSTANCE.getEDIT_RANGE_LINE_BACKGROUND() + ".");
            return this.emptyAttributes();
        }
        Color color = this.mergeColors(baseColor, shadeOn, alpha);
        return new TextAttributes(null, color, null, null, 0);
    }

    public final void drawBackground(@NotNull Editor editor2, @NotNull NextEditColors.BackgroundColor color, int startOffset, int endOffset, boolean highlightIndents, @NotNull Disposable disposable) {
        Color color2;
        TextAttributes textAttributes;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)color), (String)"color");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        if (!this.validateOffsets(editor2, startOffset, endOffset)) {
            return;
        }
        if (!(editor2 instanceof EditorEx)) {
            LOG.debug("Cannot draw red background. Editor is not an instance of EditorEx.");
            return;
        }
        MarkupModelEx markupModelEx = ((EditorEx)editor2).getFilteredDocumentMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getFilteredDocumentMarkupModel(...)");
        MarkupModelEx markupModel = markupModelEx;
        List highlighters = new ArrayList();
        TextAttributes $this$drawBackground_u24lambda_u240 = textAttributes = new TextAttributes();
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[color.ordinal()]) {
            case 1: {
                color2 = INSTANCE.getRedEditorBackgroundColor(editor2);
                break;
            }
            case 2: {
                Color color3 = ((EditorEx)editor2).getColorsScheme().getColor(NextEditColors.INSTANCE.getREVIEW_HINT_BACKGROUND());
                if (color3 == null) {
                    return;
                }
                Color color4 = color3;
                color2 = INSTANCE.getColoredEditorBackgroundColor(editor2, color4, 150);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$drawBackground_u24lambda_u240.setBackgroundColor(color2);
        TextAttributes attributes = textAttributes;
        int currentOffset = startOffset;
        while (currentOffset < endOffset) {
            int drawUntil;
            int drawSince;
            int lineStartOffset;
            int line = ((EditorEx)editor2).getDocument().getLineNumber(currentOffset);
            int lineEndOffset = ((EditorEx)editor2).getDocument().getLineEndOffset(line);
            if (!highlightIndents) {
                for (lineStartOffset = ((EditorEx)editor2).getDocument().getLineStartOffset(line); lineStartOffset < lineEndOffset && CharsKt.isWhitespace((char)((EditorEx)editor2).getDocument().getCharsSequence().charAt(lineStartOffset)); ++lineStartOffset) {
                }
            }
            if ((drawSince = Math.max(lineStartOffset, currentOffset)) < (drawUntil = Math.min(lineEndOffset, endOffset)) || drawSince == drawUntil && lineStartOffset == lineEndOffset && highlightIndents) {
                RangeHighlighter range;
                HighlighterTargetArea targetArea = highlightIndents && drawSince == lineStartOffset && drawUntil == lineEndOffset ? HighlighterTargetArea.LINES_IN_RANGE : HighlighterTargetArea.EXACT_RANGE;
                Intrinsics.checkNotNullExpressionValue((Object)markupModel.addRangeHighlighter(drawSince, drawUntil, 30000, attributes, targetArea), (String)"addRangeHighlighter(...)");
                this.excludeFromStickyLines(range, editor2);
                highlighters.add(range);
            }
            currentOffset = lineEndOffset + 1;
        }
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> NextEditRenderingUtils.drawBackground$lambda$1(highlighters, markupModel));
    }

    public final void drawBackgroundUnderComponent(@NotNull Editor editor2, @NotNull JComponent component2, int affectedStartOffset, int affectedEndOffset, @Nullable Color color, @NotNull NextEditCornersArc arc, @NotNull List<? extends NextEditHighlightRange> highlights, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)arc, (String)"arc");
        Intrinsics.checkNotNullParameter(highlights, (String)"highlights");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        if (!this.validateOffsets(editor2, affectedStartOffset, affectedEndOffset)) {
            return;
        }
        if (!(editor2 instanceof EditorEx)) {
            LOG.debug("Cannot draw red background. Editor is not an instance of EditorEx.");
            return;
        }
        MarkupModelEx markupModelEx = ((EditorEx)editor2).getFilteredDocumentMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getFilteredDocumentMarkupModel(...)");
        MarkupModelEx markupModel = markupModelEx;
        TextAttributes emptyAttributes = this.emptyAttributes();
        Ref.ObjectRef currentHighlighter = new Ref.ObjectRef();
        NextEditRenderingUtils.drawBackgroundUnderComponent$renderHighlighter((Ref.ObjectRef<RangeHighlighter>)currentHighlighter, markupModel, affectedStartOffset, affectedEndOffset, emptyAttributes, editor2, component2, color, arc, highlights);
        this.onRectangleChanged(component2, disposable, (Function0<Unit>)((Function0)() -> NextEditRenderingUtils.drawBackgroundUnderComponent$lambda$1(currentHighlighter, markupModel, affectedStartOffset, affectedEndOffset, emptyAttributes, editor2, component2, color, arc, highlights)));
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> NextEditRenderingUtils.drawBackgroundUnderComponent$lambda$2(currentHighlighter, markupModel));
    }

    public final void renderVisualEmptySpaceUnder(@NotNull Editor editor2, int offset, int heightInPixels, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        NextEditInlayRendererMarker renderer2 = new NextEditInlayRendererMarker(heightInPixels){
            final /* synthetic */ int $heightInPixels;
            {
                this.$heightInPixels = $heightInPixels;
            }

            public int calcWidthInPixels(Inlay<?> inlay) {
                Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                Editor editor2 = inlay.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                NextEditRenderingCustomizer nextEditRenderingCustomizer = NextEditRenderingCustomizer.Companion.getOrDefault(editor2);
                Editor editor3 = inlay.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
                return nextEditRenderingCustomizer.getEditorWidth(editor3);
            }

            public int calcHeightInPixels(Inlay<?> inlay) {
                Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                return this.$heightInPixels;
            }

            public void paint(Inlay<?> inlay, Graphics g, Rectangle targetRegion, TextAttributes textAttributes) {
                Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
                Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
                Editor editor2 = inlay.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                NextEditRenderingCustomizer customizer = NextEditRenderingCustomizer.Companion.getOrDefault(editor2);
                Editor editor3 = inlay.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
                Color backgroundColor = customizer.getEditorBackgroundColor(editor3);
                Editor editor4 = inlay.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor4, (String)"getEditor(...)");
                int editorWidth = customizer.getEditorWidth(editor4);
                g.setColor(backgroundColor);
                g.fillRect(targetRegion.x, targetRegion.y, editorWidth, inlay.getHeightInPixels());
            }
        };
        Inlay inlay = editor2.getInlayModel().addBlockElement(offset, true, false, 11, (EditorCustomElementRenderer)renderer2);
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> NextEditRenderingUtils.renderVisualEmptySpaceUnder$lambda$0(inlay));
    }

    public final void renderVisualEmptyLinesUnder(@NotNull Editor editor2, int offset, int emptyLinesCount, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.renderVisualEmptySpaceUnder(editor2, offset, editor2.getLineHeight() * emptyLinesCount, disposable);
    }

    private final Color getColoredEditorBackgroundColor(Editor editor2, Color shade, int alpha) {
        Color onColor = this.getActualBackgroundColor(editor2);
        return this.mergeColors(shade, onColor, alpha);
    }

    private final Color mergeColors(Color shade, Color onColor, int alpha) {
        return new Color(NextEditRenderingUtils.mergeColors$on(onColor.getRed(), alpha, shade.getRed()), NextEditRenderingUtils.mergeColors$on(onColor.getGreen(), alpha, shade.getGreen()), NextEditRenderingUtils.mergeColors$on(onColor.getBlue(), alpha, shade.getBlue()), onColor.getAlpha());
    }

    private final void excludeFromStickyLines(RangeHighlighter $this$excludeFromStickyLines, Editor currentEditor) {
        MarkupEditorFilter markupEditorFilter = $this$excludeFromStickyLines.getEditorFilter();
        Intrinsics.checkNotNullExpressionValue((Object)markupEditorFilter, (String)"getEditorFilter(...)");
        MarkupEditorFilter initialFilter = markupEditorFilter;
        $this$excludeFromStickyLines.setEditorFilter(arg_0 -> NextEditRenderingUtils.excludeFromStickyLines$lambda$0(initialFilter, currentEditor, arg_0));
    }

    private final boolean isStickyLinesPanel(Editor $this$isStickyLinesPanel) {
        return $this$isStickyLinesPanel instanceof EditorImpl && ((EditorImpl)$this$isStickyLinesPanel).isStickyLinePainting();
    }

    private final void onRectangleChanged(JComponent $this$onRectangleChanged, Disposable disposable, Function0<Unit> action2) {
        ComponentAdapter listener2 = new ComponentAdapter(action2){
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$action = $action;
            }

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$action.invoke();
            }

            public void componentMoved(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$action.invoke();
            }
        };
        RevertOnDisposeUtilKt.addComponentListener((Component)$this$onRectangleChanged, (Disposable)disposable, (ComponentListener)listener2);
    }

    private final TextAttributes emptyAttributes() {
        TextAttributes textAttributes;
        TextAttributes $this$emptyAttributes_u24lambda_u240 = textAttributes = new TextAttributes();
        boolean bl = false;
        $this$emptyAttributes_u24lambda_u240.setBackgroundColor(null);
        $this$emptyAttributes_u24lambda_u240.setForegroundColor(null);
        $this$emptyAttributes_u24lambda_u240.setEffectColor(null);
        $this$emptyAttributes_u24lambda_u240.setEffectType(null);
        return textAttributes;
    }

    private final Color getActualBackgroundColor(Editor $this$getActualBackgroundColor) {
        return NextEditRenderingCustomizer.Companion.getOrDefault($this$getActualBackgroundColor).getEditorBackgroundColor($this$getActualBackgroundColor);
    }

    private final boolean validateOffsets(Editor editor2, int startOffset, int endOffset) {
        if (startOffset < 0) {
            FrontendNextEditDiagnosticsLogger.error$default(LOG, "Invalid start offset: " + startOffset + ". Cannot draw red background.", null, 2, null);
            return false;
        }
        if (endOffset < startOffset) {
            FrontendNextEditDiagnosticsLogger.error$default(LOG, "Invalid start-end offsets: " + endOffset + " < " + startOffset + ". Cannot draw red background.", null, 2, null);
            return false;
        }
        if (endOffset > editor2.getDocument().getTextLength()) {
            FrontendNextEditDiagnosticsLogger.error$default(LOG, "Invalid end offset: " + endOffset + ". Cannot draw red background.", null, 2, null);
            return false;
        }
        return true;
    }

    private static final Unit drawBackground$lambda$1(List $highlighters, MarkupModelEx $markupModel) {
        Iterable $this$forEach$iv = $highlighters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv;
            boolean bl = false;
            $markupModel.removeHighlighter(it);
        }
        return Unit.INSTANCE;
    }

    private static final void drawBackgroundUnderComponent$renderHighlighter(Ref.ObjectRef<RangeHighlighter> currentHighlighter, MarkupModelEx markupModel, int $affectedStartOffset, int $affectedEndOffset, TextAttributes emptyAttributes, Editor $editor, JComponent $component, Color $color, NextEditCornersArc $arc, List<? extends NextEditHighlightRange> $highlights) {
        RangeHighlighter rangeHighlighter = (RangeHighlighter)currentHighlighter.element;
        if (rangeHighlighter != null) {
            RangeHighlighter it = rangeHighlighter;
            boolean bl = false;
            markupModel.removeHighlighter(it);
        }
        currentHighlighter.element = null;
        RangeHighlighter rangeHighlighter2 = markupModel.addRangeHighlighter($affectedStartOffset, $affectedEndOffset, 30000, emptyAttributes, HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter2;
        INSTANCE.excludeFromStickyLines(highlighter, $editor);
        highlighter.setCustomRenderer((CustomHighlighterRenderer)new PaintRectangleUnderComponentHighlighterRenderer($component, $color, $arc, $highlights));
        currentHighlighter.element = highlighter;
    }

    private static final Unit drawBackgroundUnderComponent$lambda$1(Ref.ObjectRef $currentHighlighter, MarkupModelEx $markupModel, int $affectedStartOffset, int $affectedEndOffset, TextAttributes $emptyAttributes, Editor $editor, JComponent $component, Color $color, NextEditCornersArc $arc, List $highlights) {
        NextEditRenderingUtils.drawBackgroundUnderComponent$renderHighlighter((Ref.ObjectRef<RangeHighlighter>)$currentHighlighter, $markupModel, $affectedStartOffset, $affectedEndOffset, $emptyAttributes, $editor, $component, $color, $arc, $highlights);
        return Unit.INSTANCE;
    }

    private static final Unit drawBackgroundUnderComponent$lambda$2(Ref.ObjectRef $currentHighlighter, MarkupModelEx $markupModel) {
        block0: {
            RangeHighlighter rangeHighlighter = (RangeHighlighter)$currentHighlighter.element;
            if (rangeHighlighter == null) break block0;
            RangeHighlighter it = rangeHighlighter;
            boolean bl = false;
            $markupModel.removeHighlighter(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderVisualEmptySpaceUnder$lambda$0(Inlay $inlay) {
        block0: {
            Inlay inlay = $inlay;
            if (inlay == null) break block0;
            Inlay it = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        return Unit.INSTANCE;
    }

    private static final int mergeColors$on(int $this$mergeColors_u24on, int $alpha, int x) {
        return ($this$mergeColors_u24on * $alpha + x * (255 - $alpha)) / 255;
    }

    private static final boolean excludeFromStickyLines$lambda$0(MarkupEditorFilter $initialFilter, Editor $currentEditor, Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return $initialFilter.avaliableIn(editor2) && !INSTANCE.isStickyLinesPanel(editor2) && $currentEditor == editor2;
    }

    static {
        NextEditRenderingUtils $this$thisNextEditLogger$iv = INSTANCE = new NextEditRenderingUtils();
        boolean $i$f$thisNextEditLogger = false;
        LOG = FrontendNextEditDiagnosticsLogger.Companion.get$intellij_ml_llm_nextEdits_frontend(NextEditRenderingUtils.class);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NextEditColors.BackgroundColor.values().length];
            try {
                nArray[NextEditColors.BackgroundColor.RED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditColors.BackgroundColor.PURPLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

