/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.aiignore;

import com.intellij.ml.llm.privacy.TracerKt;
import com.intellij.ml.llm.privacy.aiignore.RootAIIgnoreHolderKt;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TracerLevel;
import io.opentelemetry.api.trace.Span;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.eclipse.jgit.ignore.FastIgnoreRule;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/privacy/aiignore/RootAIIgnoreHolder;", "", "projectRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "rootAIIgnoreNode", "Lorg/eclipse/jgit/ignore/IgnoreNode;", "ts", "Ljava/time/LocalDateTime;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/eclipse/jgit/ignore/IgnoreNode;Ljava/time/LocalDateTime;)V", "getParentsToCheck", "", "file", "isIgnored", "", "dump", "", "Companion", "intellij.ml.llm.privacy"})
@SourceDebugExtension(value={"SMAP\nRootAIIgnoreHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootAIIgnoreHolder.kt\ncom/intellij/ml/llm/privacy/aiignore/RootAIIgnoreHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1869#2,2:81\n*S KotlinDebug\n*F\n+ 1 RootAIIgnoreHolder.kt\ncom/intellij/ml/llm/privacy/aiignore/RootAIIgnoreHolder\n*L\n74#1:81,2\n*E\n"})
public final class RootAIIgnoreHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile projectRoot;
    @NotNull
    private final IgnoreNode rootAIIgnoreNode;
    @NotNull
    private final LocalDateTime ts;

    public RootAIIgnoreHolder(@NotNull VirtualFile projectRoot, @NotNull IgnoreNode rootAIIgnoreNode, @NotNull LocalDateTime ts) {
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        Intrinsics.checkNotNullParameter((Object)rootAIIgnoreNode, (String)"rootAIIgnoreNode");
        Intrinsics.checkNotNullParameter((Object)ts, (String)"ts");
        this.projectRoot = projectRoot;
        this.rootAIIgnoreNode = rootAIIgnoreNode;
        this.ts = ts;
    }

    private final List<VirtualFile> getParentsToCheck(VirtualFile file2) {
        List parentsToCheck = new ArrayList();
        for (VirtualFile currentFile = file2; currentFile != null && !Intrinsics.areEqual((Object)currentFile, (Object)this.projectRoot); currentFile = currentFile.getParent()) {
            parentsToCheck.add(currentFile);
        }
        CollectionsKt.reverse((List)parentsToCheck);
        return parentsToCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isIgnored(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = this.projectRoot.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path path = NioPathUtil.toNioPathOrNull((String)string);
        if (path == null) {
            return false;
        }
        Path projectRootPath = path;
        if (Intrinsics.areEqual((Object)file2.getName(), (Object)".aiignore") && Intrinsics.areEqual((Object)file2.getParent(), (Object)this.projectRoot)) {
            return false;
        }
        Span aiIgnoreSpan = TracerKt.getPrivacyTracer().spanBuilder("ai-ignore", TracerLevel.DEFAULT).startSpan();
        try {
            for (VirtualFile fileToCheck : this.getParentsToCheck(file2)) {
                Path relativePathToCheck;
                Path fileToCheckPath;
                String string2 = fileToCheck.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                if (NioPathUtil.toNioPathOrNull((String)string2) == null || projectRootPath.relativize(fileToCheckPath) == null || this.rootAIIgnoreNode.isIgnored(PathsKt.getInvariantSeparatorsPathString((Path)relativePathToCheck), fileToCheck.isDirectory()) != IgnoreNode.MatchResult.IGNORED) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            RootAIIgnoreHolderKt.access$getLOG$p().warn("[aiignore] Error checking if file is ignored", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            aiIgnoreSpan.end();
        }
    }

    @NotNull
    public final String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append("time=" + this.ts).append('\n');
        List rules = this.rootAIIgnoreNode.getRules();
        sb.append("rules=" + rules.size()).append('\n');
        Intrinsics.checkNotNull((Object)rules);
        Iterable $this$forEach$iv = rules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FastIgnoreRule rule = (FastIgnoreRule)element$iv;
            boolean bl = false;
            sb.append("\t" + rule).append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/privacy/aiignore/RootAIIgnoreHolder$Companion;", "", "<init>", "()V", "parse", "Lcom/intellij/ml/llm/privacy/aiignore/RootAIIgnoreHolder;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "", "intellij.ml.llm.privacy"})
    @SourceDebugExtension(value={"SMAP\nRootAIIgnoreHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootAIIgnoreHolder.kt\ncom/intellij/ml/llm/privacy/aiignore/RootAIIgnoreHolder$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RootAIIgnoreHolder parse(@NotNull VirtualFile root, @NotNull String content2) {
            IgnoreNode ignoreNode;
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            try {
                IgnoreNode $this$parse_u24lambda_u240 = ignoreNode = new IgnoreNode();
                boolean bl = false;
                String string = content2;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                $this$parse_u24lambda_u240.parse((InputStream)new ByteArrayInputStream(byArray));
            }
            catch (IOException e) {
                RootAIIgnoreHolderKt.access$getLOG$p().warn("Failed to parse .aiignore file", (Throwable)e);
                ignoreNode = null;
            }
            IgnoreNode ignoreNode2 = ignoreNode;
            if (ignoreNode2 == null) {
                return null;
            }
            IgnoreNode parsedNode = ignoreNode2;
            LocalDateTime localDateTime = LocalDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
            return new RootAIIgnoreHolder(root, parsedNode, localDateTime);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

