/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.aiignore.notifications;

import com.intellij.ml.llm.privacy.LLMPrivacyBundle;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreSettingsManager;
import com.intellij.ml.llm.privacy.aiignore.notifications.AiIgnoreCreationNotifier;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/privacy/aiignore/notifications/AiIgnoreCreationNotifier;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "notifySuggestSetAiIgnore", "", "newAiIgnoreFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createSuggestSetAiIgnoreNotification", "Lcom/intellij/notification/Notification;", "createSetAiIgnoreAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "aiIgnoreSettingsManager", "Lcom/intellij/ml/llm/privacy/aiignore/AiIgnoreSettingsManager;", "notifyAiIgnoreWasSet", "createAiIgnoreWasSetNotification", "createOpenAiIgnoreSettingsAction", "intellij.ml.llm.privacy"})
public final class AiIgnoreCreationNotifier {
    @NotNull
    private final Project project;
    @NotNull
    private final AiIgnoreSettingsManager aiIgnoreSettingsManager;

    public AiIgnoreCreationNotifier(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.aiIgnoreSettingsManager = AiIgnoreSettingsManager.Companion.getInstance(this.project);
    }

    public final void notifySuggestSetAiIgnore(@NotNull VirtualFile newAiIgnoreFile) {
        Intrinsics.checkNotNullParameter((Object)newAiIgnoreFile, (String)"newAiIgnoreFile");
        this.createSuggestSetAiIgnoreNotification(newAiIgnoreFile).notify(this.project);
    }

    private final Notification createSuggestSetAiIgnoreNotification(VirtualFile newAiIgnoreFile) {
        Object[] objectArray = new Object[]{".aiignore"};
        Notification notification2 = new Notification("AiIgnore Related Notifications", LLMPrivacyBundle.message("notification.content.new.code.code.file.was.created", objectArray), NotificationType.INFORMATION);
        Notification notification3 = notification2.addAction(this.createSetAiIgnoreAction(notification2, newAiIgnoreFile));
        Intrinsics.checkNotNullExpressionValue((Object)notification3, (String)"addAction(...)");
        return notification3;
    }

    private final AnAction createSetAiIgnoreAction(Notification $this$createSetAiIgnoreAction, VirtualFile newAiIgnoreFile) {
        Notification notification2 = $this$createSetAiIgnoreAction;
        Object[] objectArray = new Object[]{".aiignore"};
        String string = LLMPrivacyBundle.message("action.set.this.file.as.new.for.this.project.text", objectArray);
        return (AnAction)new DumbAwareAction(this, newAiIgnoreFile, notification2, string){
            final /* synthetic */ AiIgnoreCreationNotifier this$0;
            final /* synthetic */ VirtualFile $newAiIgnoreFile;
            final /* synthetic */ Notification $notification;
            {
                this.this$0 = $receiver;
                this.$newAiIgnoreFile = $newAiIgnoreFile;
                this.$notification = $notification;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                AiIgnoreCreationNotifier.access$getAiIgnoreSettingsManager$p(this.this$0).setAIIgnoreURL(this.$newAiIgnoreFile.getUrl());
                this.this$0.notifyAiIgnoreWasSet(this.$newAiIgnoreFile);
                this.$notification.expire();
            }
        };
    }

    public final void notifyAiIgnoreWasSet(@NotNull VirtualFile newAiIgnoreFile) {
        Intrinsics.checkNotNullParameter((Object)newAiIgnoreFile, (String)"newAiIgnoreFile");
        this.createAiIgnoreWasSetNotification(newAiIgnoreFile).notify(this.project);
    }

    private final Notification createAiIgnoreWasSetNotification(VirtualFile newAiIgnoreFile) {
        Object[] objectArray = new Object[]{".aiignore"};
        String string = LLMPrivacyBundle.message("notification.title.new.code.code.file.set", objectArray);
        objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)newAiIgnoreFile.getPath(), (String)"getPath(...)");
        objectArray[1] = ".aiignore";
        Notification notification2 = new Notification("AiIgnore Related Notifications", string, LLMPrivacyBundle.message("notification.content.file.code.code.was.set.as.for.this.project", objectArray), NotificationType.INFORMATION).addAction(this.createOpenAiIgnoreSettingsAction());
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"addAction(...)");
        return notification2;
    }

    private final AnAction createOpenAiIgnoreSettingsAction() {
        String string = LLMPrivacyBundle.message("action.open.settings.text", new Object[0]);
        return (AnAction)new DumbAwareAction(this, string){
            final /* synthetic */ AiIgnoreCreationNotifier this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ApplicationManager.getApplication().invokeLater(() -> createOpenAiIgnoreSettingsAction.1.actionPerformed$lambda$0(this.this$0));
            }

            private static final void actionPerformed$lambda$0(AiIgnoreCreationNotifier this$0) {
                ShowSettingsUtil.getInstance().showSettingsDialog(AiIgnoreCreationNotifier.access$getProject$p(this$0), LLMPrivacyBundle.message("configurable.name.project.settings", new Object[0]));
            }
        };
    }

    public static final /* synthetic */ AiIgnoreSettingsManager access$getAiIgnoreSettingsManager$p(AiIgnoreCreationNotifier $this) {
        return $this.aiIgnoreSettingsManager;
    }

    public static final /* synthetic */ Project access$getProject$p(AiIgnoreCreationNotifier $this) {
        return $this.project;
    }
}

