/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0001H\u0016J\u0018\u0010\u0014\u001a\u00110\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0002\b\u0018H\u0097\u0001J\u0018\u0010\u0019\u001a\u00110\u0015\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u0018H\u0097\u0001J=\u0010\u001b\u001a\u00020\u000f2\u0012\b\u0001\u0010\u001c\u001a\f0\t\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u00182\u000e\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\u001f\u001a\n \u001e*\u0004\u0018\u00010\r0\rH\u0096\u0001J\t\u0010 \u001a\u00020\u000fH\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/privacy/intentions/AiIgnoreAwareIntentionActionWrapper;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/actionSystem/ActionWithDelegate;", "wrapped", "<init>", "(Lcom/intellij/codeInsight/intention/IntentionAction;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isFileAiIgnored", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "notifyAiIgnoreIntentionUnavailable", "getDelegate", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "Lkotlin/jvm/internal/EnhancedNullability;", "getText", "Lcom/intellij/codeInspection/util/IntentionName;", "isAvailable", "p0", "p1", "kotlin.jvm.PlatformType", "p2", "startInWriteAction", "intellij.ml.llm.privacy"})
public final class AiIgnoreAwareIntentionActionWrapper
implements IntentionAction,
ActionWithDelegate<IntentionAction> {
    @NotNull
    private final IntentionAction wrapped;

    public AiIgnoreAwareIntentionActionWrapper(@NotNull IntentionAction wrapped) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        this.wrapped = wrapped;
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PsiFile psiFile = file2;
        if (psiFile != null && (psiFile = psiFile.getVirtualFile()) != null) {
            PsiFile virtualFile2 = psiFile;
            boolean bl = false;
            if (this.isFileAiIgnored(project2, (VirtualFile)virtualFile2)) {
                this.notifyAiIgnoreIntentionUnavailable(project2, (VirtualFile)virtualFile2);
                return;
            }
        }
        this.wrapped.invoke(project2, editor2, file2);
    }

    private final boolean isFileAiIgnored(Project project2, VirtualFile virtualFile2) {
        return PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, virtualFile2);
    }

    private final void notifyAiIgnoreIntentionUnavailable(Project project2, VirtualFile virtualFile2) {
        PrivacyPathCheckerKt.notifyFileIsIgnored(project2);
    }

    @NotNull
    public IntentionAction getDelegate() {
        return this.wrapped;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.wrapped.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project p0, Editor p1, PsiFile p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return this.wrapped.isAvailable(p0, p1, p2);
    }

    public boolean startInWriteAction() {
        return this.wrapped.startInWriteAction();
    }

    @IntentionFamilyName
    @NotNull
    @Contract(pure=true)
    public String getFamilyName() {
        String string = this.wrapped.getFamilyName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFamilyName(...)");
        return string;
    }
}

