/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.python.smartChat.fileSummarization;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.ml.llm.smartChat.psiSummarization.LanguageSummaryProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/python/smartChat/fileSummarization/PythonSummaryProvider;", "Lcom/intellij/ml/llm/smartChat/psiSummarization/LanguageSummaryProvider;", "<init>", "()V", "generateSummary", "Lcom/intellij/ml/llm/privacy/PSString;", "psiElement", "Lcom/intellij/psi/PsiElement;", "addAttributeInfo", "", "attribute", "Lcom/jetbrains/python/psi/PyTargetExpression;", "stringBuilder", "Lcom/intellij/ml/llm/privacy/trustedStringBuilders/ConcatenateBuilder;", "addFunctionInfo", "function", "Lcom/jetbrains/python/psi/PyFunction;", "addClassInfo", "pyClass", "Lcom/jetbrains/python/psi/PyClass;", "outerClass", "intellij.ml.llm.python"})
public final class PythonSummaryProvider
implements LanguageSummaryProvider {
    @Nullable
    public PSString generateSummary(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked(psiElement)) {
            return null;
        }
        ConcatenateBuilder stringBuilder = new ConcatenateBuilder(null, 1, null);
        if (psiElement instanceof PyFile) {
            for (PyTargetExpression attribute : ((PyFile)psiElement).getTopLevelAttributes()) {
                Intrinsics.checkNotNull((Object)attribute);
                this.addAttributeInfo(attribute, stringBuilder);
            }
            stringBuilder.append(ConstantsKt.getPrivacyConst((String)"\n"));
            for (PyFunction function : ((PyFile)psiElement).getTopLevelFunctions()) {
                Intrinsics.checkNotNull((Object)function);
                this.addFunctionInfo(function, stringBuilder);
            }
            for (PyClass pyClass : ((PyFile)psiElement).getTopLevelClasses()) {
                Intrinsics.checkNotNull((Object)pyClass);
                this.addClassInfo(pyClass, null, stringBuilder);
            }
            stringBuilder.append(ConstantsKt.getPrivacyConst((String)"\n"));
            return stringBuilder.toPSString();
        }
        return null;
    }

    private final void addAttributeInfo(PyTargetExpression attribute, ConcatenateBuilder stringBuilder) {
        TextRange range = attribute.getTextRange();
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((PsiNamedElement)attribute).getName(), PSStringOperatorsKt.toPSString((int)range.getStartOffset()), PSStringOperatorsKt.toPSString((int)(range.getEndOffset() - 1))};
        stringBuilder.append(ConstantsKt.getPrivacyConst((String)"attribute %s (charRange: [%s, %s])\n").format(pSStringConvertibleArray));
    }

    private final void addFunctionInfo(PyFunction function, ConcatenateBuilder stringBuilder) {
        TextRange range = function.getTextRange();
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((PsiNamedElement)function).getName(), PSStringOperatorsKt.toPSString((int)range.getStartOffset()), PSStringOperatorsKt.toPSString((int)(range.getEndOffset() - 1))};
        stringBuilder.append(ConstantsKt.getPrivacyConst((String)"function %s (charRange: [%s, %s])\n").format(pSStringConvertibleArray));
    }

    private final void addClassInfo(PyClass pyClass, PyClass outerClass, ConcatenateBuilder stringBuilder) {
        PSStringConvertible[] pSStringConvertibleArray;
        TextRange range;
        PSString pSString;
        Object object;
        TextRange classRange = pyClass.getTextRange();
        if (outerClass != null) {
            object = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((PsiNamedElement)outerClass).getName()};
            pSString = ConstantsKt.getPrivacyConst((String)"inside %s ").format((PSStringConvertible[])object);
        } else {
            pSString = ConstantsKt.getPrivacyConst((String)"");
        }
        PSString insideInfo = pSString;
        object = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((PsiNamedElement)pyClass).getName(), insideInfo, PSStringOperatorsKt.toPSString((int)classRange.getStartOffset()), PSStringOperatorsKt.toPSString((int)(classRange.getEndOffset() - 1))};
        stringBuilder.append(ConstantsKt.getPrivacyConst((String)"\nclass %s %s(charRange:[%s, %s]) :\n").format((PSStringConvertible[])object));
        for (PyTargetExpression classAttribute : pyClass.getClassAttributes()) {
            range = classAttribute.getTextRange();
            PSString pSString2 = ConstantsKt.getPrivacyConst((String)"class attribute %s (charRange: [%s, %s])\n");
            pSStringConvertibleArray = new PSStringConvertible[3];
            Intrinsics.checkNotNull((Object)classAttribute);
            pSStringConvertibleArray[0] = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)classAttribute).getName();
            pSStringConvertibleArray[1] = PSStringOperatorsKt.toPSString((int)range.getStartOffset());
            pSStringConvertibleArray[2] = PSStringOperatorsKt.toPSString((int)(range.getEndOffset() - 1));
            stringBuilder.append(pSString2.format(pSStringConvertibleArray));
        }
        for (PyTargetExpression instanceAttribute : pyClass.getInstanceAttributes()) {
            range = instanceAttribute.getTextRange();
            PSString pSString3 = ConstantsKt.getPrivacyConst((String)"instance attribute %s (charRange: [%s, %s])\n");
            pSStringConvertibleArray = new PSStringConvertible[3];
            Intrinsics.checkNotNull((Object)instanceAttribute);
            pSStringConvertibleArray[0] = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)instanceAttribute).getName();
            pSStringConvertibleArray[1] = PSStringOperatorsKt.toPSString((int)range.getStartOffset());
            pSStringConvertibleArray[2] = PSStringOperatorsKt.toPSString((int)(range.getEndOffset() - 1));
            stringBuilder.append(pSString3.format(pSStringConvertibleArray));
        }
        PyFunction[] pyFunctionArray = pyClass.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)pyFunctionArray, (String)"getMethods(...)");
        for (PyFunction psiMethod : pyFunctionArray) {
            TextRange methodRange = psiMethod.getTextRange();
            PSString pSString4 = ConstantsKt.getPrivacyConst((String)"method %s (charRange: [%s, %s])\n");
            PSStringConvertible[] pSStringConvertibleArray2 = new PSStringConvertible[3];
            Intrinsics.checkNotNull((Object)psiMethod);
            pSStringConvertibleArray2[0] = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)psiMethod).getName();
            pSStringConvertibleArray2[1] = PSStringOperatorsKt.toPSString((int)methodRange.getStartOffset());
            pSStringConvertibleArray2[2] = PSStringOperatorsKt.toPSString((int)(methodRange.getEndOffset() - 1));
            stringBuilder.append(pSString4.format(pSStringConvertibleArray2));
        }
        PyClass[] pyClassArray = pyClass.getNestedClasses();
        Intrinsics.checkNotNullExpressionValue((Object)pyClassArray, (String)"getNestedClasses(...)");
        for (PyClass nestedClass : pyClassArray) {
            Intrinsics.checkNotNull((Object)nestedClass);
            this.addClassInfo(nestedClass, pyClass, stringBuilder);
        }
    }
}

