/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rider.csharp.errorExplanation;

import com.intellij.ml.llm.errorExplanation.filters.ErrorExplainFilter;
import com.intellij.ml.llm.errorExplanation.filters.ExceptionRangePostprocessor;
import com.intellij.ml.llm.rider.csharp.errorExplanation.DotnetExceptionPostprocessor;
import com.intellij.openapi.project.DumbAware;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/rider/csharp/errorExplanation/DotnetExceptionLLMExplainFilter;", "Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "exceptionPattern", "Lkotlin/text/Regex;", "isErrorBegin", "", "line", "", "entireLength", "", "isErrorEnd", "getPostprocessor", "Lcom/intellij/ml/llm/errorExplanation/filters/ExceptionRangePostprocessor;", "intellij.ml.llm.rider.csharp"})
public final class DotnetExceptionLLMExplainFilter
extends ErrorExplainFilter
implements DumbAware {
    @NotNull
    private final Regex exceptionPattern = new Regex("([\\d\\p{L}]*)Exception\\s*:");

    public boolean isErrorBegin(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.getCurrentState() == ErrorExplainFilter.State.NO_EXCEPTION && this.exceptionPattern.containsMatchIn((CharSequence)line);
    }

    public boolean isErrorEnd(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.getCurrentState() == ErrorExplainFilter.State.COLLECTING;
    }

    @NotNull
    public ExceptionRangePostprocessor getPostprocessor() {
        return new DotnetExceptionPostprocessor();
    }
}

