/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.events.listeners;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.riderNext.latest.NextRegistryKt;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.ChroniclesEvents;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.listeners.ChroniclesDocumentListener;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.mergeableEvents.ChronicleEventScrollEvent;
import com.intellij.ml.llm.util.CoroutineScopeKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/events/listeners/ChroniclesEditorListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorTypeSupported", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
public final class ChroniclesEditorListener
implements EditorFactoryListener {
    @NotNull
    private final CoroutineScope coroutineScope;
    public static final int $stable = 8;

    public ChroniclesEditorListener(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
    }

    public void editorCreated(@NotNull EditorFactoryEvent event2) {
        Project project2;
        Editor editor2;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                if (!NextRegistryKt.isChroniclesEnabled()) {
                    return;
                }
                Editor editor3 = event2.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
                editor2 = editor3;
                project2 = editor2.getProject();
                if (project2 == null || editor2.isDisposed() || !(editor2 instanceof EditorImpl) || !this.editorTypeSupported(editor2)) break block4;
                Project project3 = ((EditorImpl)editor2).getProject();
                if (project3 != null ? !project3.isDisposed() : false) break block5;
            }
            return;
        }
        Disposable disposable = CoroutineScopeKt.newEditorDisposable((Editor)editor2, (CoroutineScope)this.coroutineScope);
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile((Document)((EditorImpl)editor2).getDocument());
        ((EditorImpl)editor2).getDocument().addDocumentListener((DocumentListener)new ChroniclesDocumentListener((EditorImpl)editor2, project2, virtualFile2), disposable);
        ((EditorImpl)editor2).getScrollingModel().addVisibleAreaListener(new VisibleAreaListener(virtualFile2, project2){
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ Project $project;
            {
                this.$virtualFile = $virtualFile;
                this.$project = $project;
            }

            public void visibleAreaChanged(VisibleAreaEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!NextRegistryKt.isChroniclesEnabled()) {
                    return;
                }
                if (this.$virtualFile == null) {
                    return;
                }
                if (e.getOldRectangle() == null || e.getOldRectangle().isEmpty() || e.getNewRectangle().isEmpty() || Intrinsics.areEqual((Object)e.getOldRectangle(), (Object)e.getNewRectangle())) {
                    return;
                }
                ChroniclesEvents.Companion.getInstance(this.$project).add(new ChronicleEventScrollEvent(this.$virtualFile, 0L, 2, null));
            }
        }, disposable);
    }

    private final boolean editorTypeSupported(Editor editor2) {
        return editor2.getEditorKind() == EditorKind.MAIN_EDITOR;
    }
}

