/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.view;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.riderNext.latest.chronicles.ai.RecapAgentResult;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\b\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapResultsStorage;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "load", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/ai/RecapAgentResult;", "save", "", "result", "getPath", "Ljava/nio/file/Path;", "Companion", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRecapResultsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecapResultsStorage.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapResultsStorage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n57#2:61\n35#2,2:62\n57#2:64\n35#2,2:65\n*S KotlinDebug\n*F\n+ 1 RecapResultsStorage.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapResultsStorage\n*L\n31#1:61\n31#1:62,2\n43#1:64\n43#1:65,2\n*E\n"})
public final class RecapResultsStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    public static final int $stable = 8;

    public RecapResultsStorage(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final RecapAgentResult load() {
        Path path = this.getPath();
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            String json = Files.readString(path);
            DeserializationStrategy deserializationStrategy = (DeserializationStrategy)RecapAgentResult.Companion.serializer();
            Intrinsics.checkNotNull((Object)json);
            return (RecapAgentResult)Json.Default.decodeFromString(deserializationStrategy, json);
        }
        catch (Throwable e) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to load recap results", e);
            return null;
        }
    }

    public final void save(@NotNull RecapAgentResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        String json = Json.Default.encodeToString((SerializationStrategy)RecapAgentResult.Companion.serializer(), (Object)result2);
        Path path = this.getPath();
        try {
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to save recap results", (Throwable)e);
        }
    }

    private final Path getPath() {
        Path dirPath = ProjectUtil.getProjectDataPath((Project)this.project, (String)"recap");
        if (!Files.exists(dirPath, new LinkOption[0])) {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        Path path = dirPath.resolve("recap.results.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapResultsStorage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapResultsStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.riderNext.latest"})
    @SourceDebugExtension(value={"SMAP\nRecapResultsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecapResultsStorage.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapResultsStorage$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,60:1\n30#2,2:61\n*S KotlinDebug\n*F\n+ 1 RecapResultsStorage.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapResultsStorage$Companion\n*L\n18#1:61,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RecapResultsStorage getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<RecapResultsStorage> serviceClass$iv = RecapResultsStorage.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RecapResultsStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

