/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.recap.ai;

import ai.grazie.model.llm.prompt.LLMPromptID;
import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.ai.RecapDiffPrivacyWrapper;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.ai.RecapLLMRequest;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.lvcs.RecapLVCSTimestamp;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0003H\u0014J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/ai/RecapLLMWhatsNextRequest;", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/ai/RecapLLMRequest;", "summary", "Lcom/intellij/ml/llm/privacy/PSString;", "diff", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/ai/RecapDiffPrivacyWrapper;", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/ai/RecapDiffPrivacyWrapper;)V", "getSummary", "()Lcom/intellij/ml/llm/privacy/PSString;", "getDiff", "()Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/ai/RecapDiffPrivacyWrapper;", "promptId", "Lai/grazie/model/llm/prompt/LLMPromptID;", "getPromptId", "()Lai/grazie/model/llm/prompt/LLMPromptID;", "composeSystemPrompt", "composeUserPrompt", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/lvcs/RecapLVCSTimestamp;", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "Companion", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
public final class RecapLLMWhatsNextRequest
extends RecapLLMRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PSString summary;
    @NotNull
    private final RecapDiffPrivacyWrapper diff;
    public static final int $stable = 8;
    @NotNull
    public static final String SYSTEM_PROMPT = "\nA programmer has made the following changes:\n\n```\n%s\n```\n\nPlease, suggest the next business logic tasks, that is related to the changes above. \n\nYou MUST NOT suggest Unit Tests, Documentation or other common tasks.\nYou MUST NOT write code.\nYou MUST wrap with <b></b> tag keywords, names of files and entities. You MUST NOT use any other highlights.\nSplit to short paragraphs with bullet points. You MUST NOT add anything except the bullet point text.\n\nResponse must be short and precise.\nYou MUST NOT add anything except the bullet point text.\nYou MUST NOT add backticks to response.\nYou MUST use JSON format\n\nExample:\n{\n  \"items: [\n    \"Handle missing usages of <b>IsEmployee</b> property of <b>User` entity in <b>User.py</b>\", \n    \"Add <b>User.Age</b> validation to support unexpected age in <b>User.kt</b><br>\",\n    \"Respond <b>HTTP 500</b> on any exception in <b>MainController.cs</b>\"\n  ]\n}\n    ";
    @NotNull
    public static final String USER_PROMPT = "\nThe changed files diff:\n%s\n";

    public RecapLLMWhatsNextRequest(@NotNull PSString summary2, @NotNull RecapDiffPrivacyWrapper diff2) {
        Intrinsics.checkNotNullParameter((Object)summary2, (String)"summary");
        Intrinsics.checkNotNullParameter((Object)((Object)diff2), (String)"diff");
        this.summary = summary2;
        this.diff = diff2;
    }

    @NotNull
    public final PSString getSummary() {
        return this.summary;
    }

    @NotNull
    public final RecapDiffPrivacyWrapper getDiff() {
        return this.diff;
    }

    @Override
    @NotNull
    protected LLMPromptID getPromptId() {
        return new LLMPromptID("riderNext.recap.whatsnext");
    }

    @Override
    @NotNull
    protected PSString composeSystemPrompt() {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{this.summary};
        return ConstantsKt.getPrivacyConst((String)SYSTEM_PROMPT).format(pSStringConvertibleArray);
    }

    @Override
    @NotNull
    protected Pair<PSString, RecapLVCSTimestamp> composeUserPrompt(@NotNull Tokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        int userTokens = tokenizer.count(USER_PROMPT);
        int systemTokens = tokenizer.count(SYSTEM_PROMPT);
        int summaryTokens = tokenizer.count(this.summary.toString());
        Pair<PSString, RecapLVCSTimestamp> pair = this.diff.getDiff(userTokens + systemTokens + summaryTokens);
        PSString diffString = (PSString)pair.component1();
        RecapLVCSTimestamp timestamp = (RecapLVCSTimestamp)pair.component2();
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{diffString};
        PSString prompt2 = ConstantsKt.getPrivacyConst((String)USER_PROMPT).format(pSStringConvertibleArray);
        return new Pair((Object)prompt2, (Object)timestamp);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/ai/RecapLLMWhatsNextRequest$Companion;", "", "<init>", "()V", "SYSTEM_PROMPT", "", "USER_PROMPT", "intellij.ml.llm.riderNext.latest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

