/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.git.selfReview.ui.inspectionWidget;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.UISettings;
import com.intellij.ml.llm.riderNext.latest.NextRegistryKt;
import com.intellij.ml.llm.riderNext.latest.git.selfReview.agent.rulesVerifier.SelfReviewRunner;
import com.intellij.ml.llm.riderNext.latest.git.selfReview.agent.rulesVerifier.store.ReviewResultManager;
import com.intellij.ml.llm.riderNext.latest.git.selfReview.ui.SelfReviewSettings;
import com.intellij.ml.llm.riderNext.latest.git.selfReview.ui.inspectionWidget.SelfReviewActionWidgetProviderKt;
import com.intellij.ml.llm.riderNext.latest.git.selfReview.ui.inspectionWidget.SelfReviewLoadingIcon;
import com.intellij.ml.llm.riderNext.latest.icons.MLLlmRiderNextLatestIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.markup.InspectionWidgetActionProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider;", "Lcom/intellij/openapi/editor/markup/InspectionWidgetActionProvider;", "<init>", "()V", "createAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "SelfReviewAction", "intellij.ml.llm.riderNext.latest.git"})
@ApiStatus.Internal
public final class SelfReviewActionWidgetProvider
implements InspectionWidgetActionProvider {
    @Nullable
    public AnAction createAction(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!NextRegistryKt.isSelfReviewEnabled()) {
            return null;
        }
        if (editor2.getEditorKind() != EditorKind.MAIN_EDITOR) {
            return null;
        }
        AnAction[] anActionArray = new AnAction[]{new SelfReviewAction(editor2), Separator.create()};
        AnAction[] anActionArray2 = anActionArray;
        return (AnAction)new ActionRemoteBehaviorSpecification.Frontend(anActionArray2){

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabledAndVisible(NextRegistryKt.isSelfReviewEnabled());
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0017\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "MousePressType", "SelfReviewSplitControl", "intellij.ml.llm.riderNext.latest.git"})
    private static final class SelfReviewAction
    extends DumbAwareToggleAction
    implements CustomComponentAction {
        @NotNull
        private final Editor editor;

        public SelfReviewAction(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.editor = editor2;
            this.getTemplatePresentation().putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
            this.getTemplatePresentation().putClientProperty(ActionUtil.USE_SMALL_FONT_IN_TOOLBAR, (Object)true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            return new SelfReviewSplitControl(this.editor, (AnAction)this, presentation2);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return true;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            Project project3 = project2;
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project3).getSelectedEditor();
            if (fileEditor == null || (fileEditor = fileEditor.getFile()) == null) {
                return;
            }
            FileEditor virtualFile2 = fileEditor;
            SelfReviewSettings settings2 = SelfReviewSettings.Companion.getInstance(project3);
            SelfReviewRunner runner = SelfReviewRunner.Companion.getInstance(project3);
            SelfReviewRunner.FileReviewState fileState = runner.getFileState((VirtualFile)virtualFile2);
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
            Presentation presentation3 = presentation2;
            Object object = presentation3.getClientProperty(CustomComponentAction.COMPONENT_KEY);
            SelfReviewSplitControl component2 = object instanceof SelfReviewSplitControl ? (SelfReviewSplitControl)object : null;
            Object object2 = component2;
            if (object2 == null || (object2 = object2.getMousePressType()) == null) {
                object2 = MousePressType.MAIN;
            }
            Object mousePressType = object2;
            switch (WhenMappings.$EnumSwitchMapping$0[fileState.ordinal()]) {
                case 1: {
                    settings2.setEnabled(true);
                    Job job2 = runner.runForFile((VirtualFile)virtualFile2);
                    ActivityTracker.getInstance().inc();
                    Job job3 = job2;
                    if (job3 != null) {
                        job3.invokeOnCompletion(arg_0 -> SelfReviewAction.setSelected$lambda$0(project3, arg_0));
                    }
                    break;
                }
                case 2: {
                    settings2.setEnabled(false);
                    ReviewResultManager.Companion.getInstance(project3).clearDescriptorsAll();
                    ActivityTracker.getInstance().inc();
                    break;
                }
                case 3: {
                    if (mousePressType == MousePressType.DROPDOWN) {
                        runner.runIncrementalForFile((VirtualFile)virtualFile2);
                        ActivityTracker.getInstance().inc();
                        break;
                    }
                    settings2.setEnabled(false);
                    ReviewResultManager.Companion.getInstance(project3).clearDescriptorsAll();
                    ActivityTracker.getInstance().inc();
                    break;
                }
                case 4: {
                    settings2.setEnabled(false);
                    ReviewResultManager.Companion.getInstance(project3).clearDescriptorsAll();
                    ActivityTracker.getInstance().inc();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            block8: {
                VirtualFile currentFile;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project2 = e.getProject();
                if (project2 == null) {
                    return;
                }
                Project project3 = project2;
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
                Presentation presentation3 = presentation2;
                FileEditor fileEditor = FileEditorManager.getInstance((Project)project3).getSelectedEditor();
                Object object = currentFile = fileEditor != null ? fileEditor.getFile() : null;
                if (currentFile == null) {
                    presentation3.setEnabledAndVisible(false);
                    return;
                }
                SelfReviewRunner runner = SelfReviewRunner.Companion.getInstance(project3);
                SelfReviewRunner.FileReviewState fileState = runner.getFileState(currentFile);
                switch (WhenMappings.$EnumSwitchMapping$0[fileState.ordinal()]) {
                    case 1: {
                        presentation3.setText("Self Review");
                        presentation3.setDescription("Enable AI Review");
                        presentation3.setIcon(MLLlmRiderNextLatestIcons.Icons.SelfReview.Gray);
                        break;
                    }
                    case 2: {
                        presentation3.setText("Self Review");
                        presentation3.setDescription("Disable AI Review");
                        presentation3.setIcon((Icon)new SelfReviewLoadingIcon(0, 0, 3, null));
                        break;
                    }
                    case 4: {
                        presentation3.setText("Self Review");
                        presentation3.setDescription("Disable AI Review");
                        presentation3.setIcon(MLLlmRiderNextLatestIcons.Icons.SelfReview.Purple);
                        break;
                    }
                    case 3: {
                        presentation3.setText("Self Review");
                        presentation3.setDescription("Update AI Review results");
                        presentation3.setIcon(MLLlmRiderNextLatestIcons.Icons.SelfReview.Outdated);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Object object2 = presentation3.getClientProperty(CustomComponentAction.COMPONENT_KEY);
                JComponent jComponent = object2 instanceof JComponent ? (JComponent)object2 : null;
                if (jComponent == null) break block8;
                jComponent.repaint();
            }
        }

        private static final Unit setSelected$lambda$0(Project $project, Throwable throwable) {
            if (throwable != null) {
                ApplicationManager.getApplication().invokeLater(() -> SelfReviewAction.setSelected$lambda$0$0($project));
            }
            return Unit.INSTANCE;
        }

        private static final void setSelected$lambda$0$0(Project $project) {
            SelfReviewSettings.Companion.getInstance($project).setEnabled(false);
            ActivityTracker.getInstance().inc();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction$MousePressType;", "", "<init>", "(Ljava/lang/String;I)V", "MAIN", "DROPDOWN", "NONE", "intellij.ml.llm.riderNext.latest.git"})
        private static final class MousePressType
        extends Enum<MousePressType> {
            public static final /* enum */ MousePressType MAIN = new MousePressType();
            public static final /* enum */ MousePressType DROPDOWN = new MousePressType();
            public static final /* enum */ MousePressType NONE = new MousePressType();
            private static final /* synthetic */ MousePressType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static MousePressType[] values() {
                return (MousePressType[])$VALUES.clone();
            }

            public static MousePressType valueOf(String value) {
                return Enum.valueOf(MousePressType.class, value);
            }

            @NotNull
            public static EnumEntries<MousePressType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = mousePressTypeArray = new MousePressType[]{MousePressType.MAIN, MousePressType.DROPDOWN, MousePressType.NONE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001:\u0004 !\"#B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\rJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction$SelfReviewSplitControl;", "Ljavax/swing/JComponent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/Presentation;)V", "model", "Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction$SelfReviewSplitControl$SplitControlModel;", "mousePressType", "Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction$MousePressType;", "getMousePressType", "getCurrentFileState", "Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/agent/rulesVerifier/SelfReviewRunner$FileReviewState;", "getPreferredSize", "Ljava/awt/Dimension;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "calculateRefreshIconBounds", "Ljava/awt/Rectangle;", "getZoneAt", "Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction$SelfReviewSplitControl$Zone;", "point", "Ljava/awt/Point;", "handleClick", "zone", "updateTooltip", "Zone", "SplitControlModel", "MyClickListener", "MyMotionListener", "intellij.ml.llm.riderNext.latest.git"})
        private static final class SelfReviewSplitControl
        extends JComponent {
            @NotNull
            private final Editor editor;
            @NotNull
            private final AnAction action;
            @NotNull
            private final Presentation presentation;
            @NotNull
            private final SplitControlModel model;
            @NotNull
            private MousePressType mousePressType;

            public SelfReviewSplitControl(@NotNull Editor editor2, @NotNull AnAction action2, @NotNull Presentation presentation2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
                this.editor = editor2;
                this.action = action2;
                this.presentation = presentation2;
                this.model = new SplitControlModel();
                this.mousePressType = MousePressType.NONE;
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.addMouseListener(new MyClickListener());
                this.addMouseMotionListener(new MyMotionListener());
                this.presentation.putClientProperty(CustomComponentAction.COMPONENT_KEY, (Object)this);
                this.updateTooltip();
            }

            @NotNull
            public final MousePressType getMousePressType() {
                return this.mousePressType;
            }

            private final SelfReviewRunner.FileReviewState getCurrentFileState() {
                Project project2 = this.editor.getProject();
                if (project2 == null) {
                    return SelfReviewRunner.FileReviewState.DISABLED;
                }
                Project project3 = project2;
                FileEditor fileEditor = FileEditorManager.getInstance((Project)project3).getSelectedEditor();
                if (fileEditor == null || (fileEditor = fileEditor.getFile()) == null) {
                    return SelfReviewRunner.FileReviewState.DISABLED;
                }
                FileEditor currentFile = fileEditor;
                return SelfReviewRunner.Companion.getInstance(project3).getFileState((VirtualFile)currentFile);
            }

            @Override
            @NotNull
            public Dimension getPreferredSize() {
                Icon icon2;
                String text2;
                FontMetrics fm = this.getFontMetrics(this.getFont());
                String string = this.presentation.getText();
                if (string == null) {
                    string = text2 = "Self Review";
                }
                if ((icon2 = this.presentation.getIcon()) == null) {
                    Icon icon3 = MLLlmRiderNextLatestIcons.Icons.SelfReview.Gray;
                    icon2 = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Gray");
                }
                Icon icon4 = icon2;
                int textWidth = fm.stringWidth(text2);
                int iconWidth = icon4.getIconWidth();
                int iconTextGap = JBUI.scale((int)2);
                int width = JBUI.scale((int)4) + iconWidth + iconTextGap + textWidth + JBUI.scale((int)4);
                int height = Math.max(icon4.getIconHeight(), fm.getHeight()) + JBUI.scale((int)4);
                SelfReviewRunner.FileReviewState fileState = this.getCurrentFileState();
                if (fileState == SelfReviewRunner.FileReviewState.OUTDATED) {
                    width += AllIcons.Actions.Refresh.getIconWidth() + JBUI.scale((int)12);
                }
                return new Dimension(width, height);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintComponent(@NotNull Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paintComponent(g);
                SelfReviewRunner.FileReviewState fileState = this.getCurrentFileState();
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2d = (Graphics2D)graphics;
                try {
                    int n;
                    Icon icon2;
                    Rectangle refreshBounds;
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    int arc = JBUI.scale((int)8);
                    if (fileState != SelfReviewRunner.FileReviewState.DISABLED) {
                        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, (Color)SelfReviewActionWidgetProviderKt.access$getGRADIENT_START$p(), rect.width, 0.0f, (Color)SelfReviewActionWidgetProviderKt.access$getGRADIENT_END$p());
                        g2d.setPaint(gradient);
                        g2d.fillRoundRect(rect.x, rect.y, rect.width, rect.height, arc, arc);
                    }
                    Rectangle rectangle = refreshBounds = fileState == SelfReviewRunner.FileReviewState.OUTDATED ? this.calculateRefreshIconBounds() : null;
                    if (this.model.getMainHovered()) {
                        g2d.setColor(JBUI.CurrentTheme.ActionButton.hoverBackground());
                        g2d.fillRoundRect(rect.x, rect.y, rect.width, rect.height, arc, arc);
                    }
                    if (this.model.getDropdownHovered() && refreshBounds != null) {
                        g2d.setColor(JBUI.CurrentTheme.ActionButton.hoverBackground());
                        int padding = JBUI.scale((int)2);
                        g2d.fillRoundRect(refreshBounds.x - padding, refreshBounds.y - padding, refreshBounds.width + padding * 2, refreshBounds.height + padding * 2, JBUI.scale((int)4), JBUI.scale((int)4));
                    }
                    if ((icon2 = this.presentation.getIcon()) == null) {
                        Icon icon3 = MLLlmRiderNextLatestIcons.Icons.SelfReview.Gray;
                        icon2 = icon3;
                        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Gray");
                    }
                    Icon icon4 = icon2;
                    String string = this.presentation.getText();
                    if (string == null) {
                        string = "Self Review";
                    }
                    String text2 = string;
                    FontMetrics fm = g2d.getFontMetrics();
                    int iconTextGap = JBUI.scale((int)2);
                    int contentWidth = icon4.getIconWidth() + iconTextGap + fm.stringWidth(text2);
                    int n2 = this.getWidth();
                    Rectangle rectangle2 = refreshBounds;
                    if (rectangle2 != null) {
                        Rectangle rectangle3 = rectangle2;
                        int n3 = n2;
                        boolean bl = false;
                        int n4 = AllIcons.Actions.Refresh.getIconWidth() + JBUI.scale((int)12);
                        n2 = n3;
                        n = n4;
                    } else {
                        n = 0;
                    }
                    int availableWidth = n2 - n;
                    int contentX = (availableWidth - contentWidth) / 2;
                    int iconY = (this.getHeight() - icon4.getIconHeight()) / 2;
                    icon4.paintIcon(this, g2d, contentX, iconY);
                    g2d.setColor(this.getForeground());
                    int textX = contentX + icon4.getIconWidth() + iconTextGap;
                    int textY = (this.getHeight() - fm.getHeight()) / 2 + fm.getAscent();
                    g2d.drawString(text2, textX, textY);
                    Rectangle rectangle4 = refreshBounds;
                    if (rectangle4 != null) {
                        Rectangle it = rectangle4;
                        boolean bl = false;
                        AllIcons.Actions.Refresh.paintIcon(this, g2d, it.x, it.y);
                    }
                }
                finally {
                    g2d.dispose();
                }
            }

            private final Rectangle calculateRefreshIconBounds() {
                Icon icon2 = AllIcons.Actions.Refresh;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Refresh");
                Icon refreshIcon = icon2;
                int padding = JBUI.scale((int)6);
                int iconX = this.getWidth() - refreshIcon.getIconWidth() - padding;
                int iconY = (this.getHeight() - refreshIcon.getIconHeight()) / 2;
                return new Rectangle(iconX, iconY, refreshIcon.getIconWidth(), refreshIcon.getIconHeight());
            }

            private final Zone getZoneAt(Point point) {
                SelfReviewRunner.FileReviewState fileState = this.getCurrentFileState();
                if (fileState != SelfReviewRunner.FileReviewState.OUTDATED) {
                    return Zone.MAIN;
                }
                Rectangle refreshBounds = this.calculateRefreshIconBounds();
                Rectangle clickableArea = new Rectangle(refreshBounds.x - JBUI.scale((int)4), refreshBounds.y - JBUI.scale((int)4), refreshBounds.width + JBUI.scale((int)8), refreshBounds.height + JBUI.scale((int)8));
                return clickableArea.contains(point) ? Zone.DROPDOWN : Zone.MAIN;
            }

            private final void handleClick(Zone zone) {
                this.mousePressType = switch (WhenMappings.$EnumSwitchMapping$0[zone.ordinal()]) {
                    case 1 -> MousePressType.MAIN;
                    case 2 -> MousePressType.DROPDOWN;
                    case 3 -> MousePressType.NONE;
                    default -> throw new NoWhenBranchMatchedException();
                };
                if (this.mousePressType != MousePressType.NONE) {
                    DataContext dataContext2 = ActionToolbar.getDataContextFor((Component)this);
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContextFor(...)");
                    DataContext dataContext3 = dataContext2;
                    AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"EditorInspectionsToolbar", (Presentation)this.presentation, (DataContext)dataContext3);
                    Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
                    AnActionEvent event2 = anActionEvent;
                    this.action.actionPerformed(event2);
                }
            }

            private final void updateTooltip() {
                VirtualFile currentFile;
                Project project2 = this.editor.getProject();
                if (project2 == null) {
                    this.setToolTipText(this.presentation.getDescription());
                    return;
                }
                FileEditor fileEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor();
                Object object = currentFile = fileEditor != null ? fileEditor.getFile() : null;
                if (currentFile == null) {
                    this.setToolTipText("No file selected");
                    return;
                }
                SelfReviewRunner.FileReviewState fileState = this.getCurrentFileState();
                String text2 = switch (WhenMappings.$EnumSwitchMapping$1[fileState.ordinal()]) {
                    case 1 -> "Enable AI Review";
                    case 2 -> "Disable AI Review";
                    case 3 -> "Disable AI Review";
                    case 4 -> "Toggle AI Review / Update results";
                    default -> throw new NoWhenBranchMatchedException();
                };
                if (UISettings.Companion.isIdeHelpTooltipEnabled()) {
                    HelpTooltip tooltip = new HelpTooltip().setTitle(text2);
                    switch (WhenMappings.$EnumSwitchMapping$1[fileState.ordinal()]) {
                        case 4: {
                            Unit unit = tooltip.setDescription("Click to toggle | Refresh icon to update results");
                            break;
                        }
                        case 2: {
                            Unit unit = tooltip.setDescription("AI Review is currently running. Click to disable it.");
                            break;
                        }
                        default: {
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    tooltip.installOn((JComponent)this);
                } else {
                    this.setToolTipText(text2);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction$SelfReviewSplitControl$MyClickListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction$SelfReviewSplitControl;)V", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "intellij.ml.llm.riderNext.latest.git"})
            private final class MyClickListener
            extends MouseAdapter {
                @Override
                public void mouseClicked(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    Zone zone = SelfReviewSplitControl.this.getZoneAt(point);
                    SelfReviewSplitControl.this.handleClick(zone);
                }

                @Override
                public void mouseExited(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SelfReviewSplitControl.this.model.reset();
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction$SelfReviewSplitControl$MyMotionListener;", "Ljava/awt/event/MouseMotionAdapter;", "<init>", "(Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction$SelfReviewSplitControl;)V", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "intellij.ml.llm.riderNext.latest.git"})
            private final class MyMotionListener
            extends MouseMotionAdapter {
                @Override
                public void mouseMoved(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    Zone zone = SelfReviewSplitControl.this.getZoneAt(point);
                    SelfReviewSplitControl.this.model.setMainHoveredAndRepaint(zone == Zone.MAIN);
                    SelfReviewSplitControl.this.model.setDropdownHoveredAndRepaint(zone == Zone.DROPDOWN);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction$SelfReviewSplitControl$SplitControlModel;", "", "<init>", "(Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction$SelfReviewSplitControl;)V", "mainHovered", "", "getMainHovered", "()Z", "setMainHovered", "(Z)V", "dropdownHovered", "getDropdownHovered", "setDropdownHovered", "setMainHoveredAndRepaint", "", "v", "setDropdownHoveredAndRepaint", "reset", "intellij.ml.llm.riderNext.latest.git"})
            private final class SplitControlModel {
                private boolean mainHovered;
                private boolean dropdownHovered;

                public final boolean getMainHovered() {
                    return this.mainHovered;
                }

                public final void setMainHovered(boolean bl) {
                    this.mainHovered = bl;
                }

                public final boolean getDropdownHovered() {
                    return this.dropdownHovered;
                }

                public final void setDropdownHovered(boolean bl) {
                    this.dropdownHovered = bl;
                }

                public final void setMainHoveredAndRepaint(boolean v) {
                    if (this.mainHovered != v) {
                        this.mainHovered = v;
                        SelfReviewSplitControl.this.repaint();
                    }
                }

                public final void setDropdownHoveredAndRepaint(boolean v) {
                    if (this.dropdownHovered != v) {
                        this.dropdownHovered = v;
                        SelfReviewSplitControl.this.repaint();
                    }
                }

                public final void reset() {
                    if (this.mainHovered || this.dropdownHovered) {
                        this.mainHovered = false;
                        this.dropdownHovered = false;
                        SelfReviewSplitControl.this.repaint();
                    }
                }
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;
                public static final /* synthetic */ int[] $EnumSwitchMapping$1;

                static {
                    int[] nArray = new int[Zone.values().length];
                    try {
                        nArray[Zone.MAIN.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Zone.DROPDOWN.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Zone.NONE.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                    nArray = new int[SelfReviewRunner.FileReviewState.values().length];
                    try {
                        nArray[SelfReviewRunner.FileReviewState.DISABLED.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[SelfReviewRunner.FileReviewState.LOADING.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[SelfReviewRunner.FileReviewState.ACTUAL.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[SelfReviewRunner.FileReviewState.OUTDATED.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$1 = nArray;
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ui/inspectionWidget/SelfReviewActionWidgetProvider$SelfReviewAction$SelfReviewSplitControl$Zone;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "MAIN", "DROPDOWN", "intellij.ml.llm.riderNext.latest.git"})
            private static final class Zone
            extends Enum<Zone> {
                public static final /* enum */ Zone NONE = new Zone();
                public static final /* enum */ Zone MAIN = new Zone();
                public static final /* enum */ Zone DROPDOWN = new Zone();
                private static final /* synthetic */ Zone[] $VALUES;
                private static final /* synthetic */ EnumEntries $ENTRIES;

                public static Zone[] values() {
                    return (Zone[])$VALUES.clone();
                }

                public static Zone valueOf(String value) {
                    return Enum.valueOf(Zone.class, value);
                }

                @NotNull
                public static EnumEntries<Zone> getEntries() {
                    return $ENTRIES;
                }

                static {
                    $VALUES = zoneArray = new Zone[]{Zone.NONE, Zone.MAIN, Zone.DROPDOWN};
                    $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SelfReviewRunner.FileReviewState.values().length];
                try {
                    nArray[SelfReviewRunner.FileReviewState.DISABLED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SelfReviewRunner.FileReviewState.LOADING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SelfReviewRunner.FileReviewState.OUTDATED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SelfReviewRunner.FileReviewState.ACTUAL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

