/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rust.context;

import com.intellij.lang.Language;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.smartChat.psiSummarization.LanguageSummaryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.FilteredTraverserBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.RsLanguage;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsUseItem;
import org.rust.lang.core.psi.ext.RsAttr;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsMod;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/rust/context/RsSummaryProvider;", "Lcom/intellij/ml/llm/smartChat/psiSummarization/LanguageSummaryProvider;", "<init>", "()V", "functionPlaceholderMessage", "", "importPlaceholderMessage", "generateSummary", "Lcom/intellij/ml/llm/privacy/PSString;", "psiElement", "Lcom/intellij/psi/PsiElement;", "deleteWithFollowingWhitespace", "", "createImportPlaceholder", "Lcom/intellij/psi/PsiComment;", "factory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "intellij.ml.llm.rust"})
@SourceDebugExtension(value={"SMAP\nRsSummaryProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsSummaryProvider.kt\ncom/intellij/ml/llm/rust/context/RsSummaryProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,96:1\n4225#2,11:97\n1#3:108\n1878#4,3:109\n121#5:112\n*S KotlinDebug\n*F\n+ 1 RsSummaryProvider.kt\ncom/intellij/ml/llm/rust/context/RsSummaryProvider\n*L\n60#1:97,11\n62#1:109,3\n91#1:112\n*E\n"})
public final class RsSummaryProvider
implements LanguageSummaryProvider {
    @NotNull
    private final String functionPlaceholderMessage;
    @NotNull
    private final String importPlaceholderMessage;

    public RsSummaryProvider() {
        this.functionPlaceholderMessage = "todo!(\"omitted\")";
        this.importPlaceholderMessage = "/* imports omitted for shortness */";
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PSString generateSummary(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!psiElement.getLanguage().isKindOf((Language)RsLanguage.INSTANCE)) {
            return null;
        }
        Project project2 = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        RsPsiFactory factory = new RsPsiFactory(project2, false, false, 6, null);
        PsiElement psiElementCopy = psiElement.copy();
        FilteredTraverserBase filteredTraverserBase = SyntaxTraverser.psiTraverser((PsiElement)psiElementCopy).expand(arg_0 -> RsSummaryProvider.generateSummary$lambda$1(RsSummaryProvider::generateSummary$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"expand(...)");
        SyntaxTraverser traverser = (SyntaxTraverser)filteredTraverserBase;
        List comments = new ArrayList();
        List functions = new ArrayList();
        List mods = new ArrayList();
        Iterator iterator = traverser.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            PsiElement element2 = (PsiElement)iterator2.next();
            PsiElement psiElement2 = element2;
            if (psiElement2 instanceof PsiComment) {
                ((Collection)comments).add(element2);
                continue;
            }
            if (psiElement2 instanceof RsFunction) {
                ((Collection)functions).add(element2);
                continue;
            }
            if (!(psiElement2 instanceof RsMod)) continue;
            ((Collection)mods).add(element2);
        }
        for (PsiElement element2 : functions) {
            PsiElement rbrace;
            PsiElement lbrace;
            RsBlock block;
            if (RsFunctionKt.getBlock((RsFunction)element2) == null || block.getTextLength() - 2 < this.functionPlaceholderMessage.length()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)block.getLbrace(), (String)"getLbrace(...)");
            PsiElement firstStmt = lbrace.getNextSibling();
            if (block.getRbrace() == null || Intrinsics.areEqual((Object)firstStmt, (Object)rbrace)) continue;
            block.deleteChildRange(firstStmt, rbrace.getPrevSibling());
            block.addAfter((PsiElement)factory.createStatement(this.functionPlaceholderMessage), lbrace);
        }
        for (PsiElement element2 : mods) {
            Iterator $this$filterIsInstanceTo$iv$iv;
            PsiElement[] psiElementArray = element2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object $this$filterIsInstance$iv = psiElementArray;
            int $i$f$filterIsInstance = 0;
            Object[] rbrace = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof RsUseItem)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List imports = (List)destination$iv$iv;
            $this$filterIsInstance$iv = imports;
            $i$f$filterIsInstance = 0;
            $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv.iterator();
            while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                void it;
                Object t = $this$filterIsInstanceTo$iv$iv.next();
                RsUseItem $i$f$filterIsInstanceTo2 = (RsUseItem)t;
                int n = $i$f$filterIsInstance;
                boolean bl = false;
                int n2 = it.getTextLength();
                $i$f$filterIsInstance = n + n2;
            }
            if ($i$f$filterIsInstance <= this.importPlaceholderMessage.length()) continue;
            Iterable $this$forEachIndexed$iv = imports;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void import_;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                RsUseItem rsUseItem = (RsUseItem)item$iv;
                int i = n;
                boolean bl = false;
                if (i == 0) {
                    import_.replace((PsiElement)this.createImportPlaceholder(factory));
                    continue;
                }
                this.deleteWithFollowingWhitespace((PsiElement)import_);
            }
        }
        for (PsiComment comment : comments) {
            this.deleteWithFollowingWhitespace((PsiElement)comment);
        }
        Intrinsics.checkNotNull((Object)psiElementCopy);
        return ExtensionsKtKt.getPrivacySafe(psiElementCopy).getText();
    }

    private final void deleteWithFollowingWhitespace(PsiElement $this$deleteWithFollowingWhitespace) {
        if ($this$deleteWithFollowingWhitespace.isValid()) {
            PsiElement psiElement = $this$deleteWithFollowingWhitespace.getNextSibling();
            if (psiElement == null) {
                return;
            }
            PsiElement next = psiElement;
            $this$deleteWithFollowingWhitespace.delete();
            if (next.isValid() && next instanceof PsiWhiteSpace) {
                next.delete();
            }
        }
    }

    private final PsiComment createImportPlaceholder(RsPsiFactory factory) {
        PsiElement $this$descendantOfTypeStrict$iv = (PsiElement)factory.createFile((CharSequence)this.importPlaceholderMessage);
        boolean $i$f$descendantOfTypeStrict = false;
        PsiComment psiComment = (PsiComment)PsiTreeUtil.findChildOfType((PsiElement)$this$descendantOfTypeStrict$iv, PsiComment.class, (boolean)true);
        if (psiComment == null) {
            throw new IllegalStateException(("Can't create comment from a text: " + this.importPlaceholderMessage).toString());
        }
        return psiComment;
    }

    private static final boolean generateSummary$lambda$0(PsiElement it) {
        return !(it instanceof RsBlock) && !(it instanceof PsiComment) && !(it instanceof RsAttr);
    }

    private static final boolean generateSummary$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

