/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rust.documentation;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.ml.llm.core.LLMDocumentationSupport;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.rust.documentation.RsLLMDocumentationSupportKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsEnumItem;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMacro;
import org.rust.lang.core.psi.RsMacro2;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsNamedElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001e\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J,\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\t2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/rust/documentation/RsLLMDocumentationSupport;", "Lcom/intellij/ml/llm/core/LLMDocumentationSupport;", "<init>", "()V", "emptyDocumentation", "", "getEmptyDocumentation", "()Ljava/lang/String;", "computeTargetRangesForEditor", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "buildDocFromSuggestion", "suggestion", "containsCompleteDoc", "", "findExampleDoc", "Lcom/intellij/ml/llm/privacy/PSString;", "documentationTarget", "Lcom/intellij/psi/PsiElement;", "updateDoc", "Lcom/intellij/openapi/editor/RangeMarker;", "documentationRange", "newDocText", "findNearestDocumentationTarget", "element", "findDocTargetsInSelection", "root", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "computeDocRange", "isDocumentable", "intellij.ml.llm.rust"})
@SourceDebugExtension(value={"SMAP\nRsLLMDocumentationSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsLLMDocumentationSupport.kt\ncom/intellij/ml/llm/rust/documentation/RsLLMDocumentationSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,116:1\n1#2:117\n66#3,2:118\n*S KotlinDebug\n*F\n+ 1 RsLLMDocumentationSupport.kt\ncom/intellij/ml/llm/rust/documentation/RsLLMDocumentationSupport\n*L\n62#1:118,2\n*E\n"})
public final class RsLLMDocumentationSupport
implements LLMDocumentationSupport {
    @NotNull
    private final String emptyDocumentation;

    public RsLLMDocumentationSupport() {
        this.emptyDocumentation = "///";
    }

    @NotNull
    public String getEmptyDocumentation() {
        return this.emptyDocumentation;
    }

    @NotNull
    public List<Pair<TextRange, TextRange>> computeTargetRangesForEditor(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return CollectionsKt.emptyList();
        }
        Project project3 = project2;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project3);
        PsiFile psiFile = psiDocumentManager != null ? psiDocumentManager.getPsiFile(editor2.getDocument()) : null;
        RsFile rsFile = psiFile instanceof RsFile ? (RsFile)psiFile : null;
        if (rsFile == null) {
            return CollectionsKt.emptyList();
        }
        RsFile rsFile2 = rsFile;
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)PsiTreeUtilKt.descendants$default((PsiElement)((PsiElement)rsFile2), (boolean)false, null, (int)3, null), arg_0 -> RsLLMDocumentationSupport.computeTargetRangesForEditor$lambda$0(this, arg_0)), arg_0 -> RsLLMDocumentationSupport.computeTargetRangesForEditor$lambda$1(this, arg_0)));
    }

    @NotNull
    public String buildDocFromSuggestion(@NotNull String suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        return suggestion;
    }

    public boolean containsCompleteDoc(@NotNull String suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        List lines2 = new ArrayList();
        for (String line : StringsKt.lines((CharSequence)suggestion)) {
            if (StringsKt.startsWith$default((String)line, (String)"///", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"//!", (boolean)false, (int)2, null)) {
                lines2.add(line);
                continue;
            }
            if (!(!((Collection)lines2).isEmpty()) || !(((CharSequence)line).length() > 0)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Pair<PSString, PSString> findExampleDoc(@NotNull PsiElement documentationTarget) {
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        return null;
    }

    @Nullable
    public RangeMarker updateDoc(@NotNull Editor editor2, @NotNull PsiElement documentationTarget, @Nullable RangeMarker documentationRange, @NotNull String newDocText) {
        RangeMarker rangeMarker;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        Intrinsics.checkNotNullParameter((Object)newDocText, (String)"newDocText");
        String docText = RsLLMDocumentationSupportKt.access$adjustSuggestion(newDocText, documentationTarget);
        Project project2 = documentationTarget.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        PsiComment psiComment = new RsPsiFactory(project2, false, false, 6, null).createDocComment(docText);
        if (psiComment == null) {
            return null;
        }
        PsiComment comment = psiComment;
        PsiElement psiElement = documentationTarget.getFirstChild();
        PsiComment psiComment2 = psiElement instanceof PsiComment ? (PsiComment)psiElement : null;
        if (psiComment2 == null || (psiComment2 = psiComment2.replace((PsiElement)comment)) == null) {
            psiComment2 = documentationTarget.addBefore((PsiElement)comment, documentationTarget.getFirstChild());
        }
        PsiComment updatedComment = psiComment2;
        TextRange textRange = updatedComment.getTextRange();
        if (textRange != null) {
            TextRange it = textRange;
            boolean bl = false;
            rangeMarker = editor2.getDocument().createRangeMarker(it);
        } else {
            rangeMarker = null;
        }
        return rangeMarker;
    }

    @Nullable
    public PsiElement findNearestDocumentationTarget(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement $this$parentOfType_u24default$iv = element2;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, RsNamedElement.class, (boolean)true);
    }

    @NotNull
    public List<PsiElement> findDocTargetsInSelection(@NotNull PsiElement root, @NotNull SelectionModel selectionModel) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        List ret = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)PsiTreeUtilKt.descendants$default((PsiElement)root, (boolean)false, null, (int)3, null), arg_0 -> RsLLMDocumentationSupport.findDocTargetsInSelection$lambda$0(this, selectionModel, arg_0)));
        if (!((Collection)ret).isEmpty()) {
            return ret;
        }
        PsiElement psiElement = CollectHighlightsUtil.findCommonParent((PsiElement)root, (int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement commonParent = psiElement;
        PsiElement psiElement2 = this.findNearestDocumentationTarget(commonParent);
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement closestNamedElement = psiElement2;
        return CollectionsKt.listOf((Object)closestNamedElement);
    }

    @NotNull
    public TextRange computeDocRange(@NotNull PsiElement documentationTarget) {
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        PsiElement psiElement = documentationTarget.getFirstChild();
        PsiComment psiComment = psiElement instanceof PsiComment ? (PsiComment)psiElement : null;
        if (psiComment == null || (psiComment = psiComment.getTextRange()) == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            psiComment = textRange;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
        }
        return psiComment;
    }

    private final boolean isDocumentable(PsiElement element2) {
        PsiElement psiElement = element2;
        return psiElement instanceof RsMod || psiElement instanceof RsFunction || psiElement instanceof RsEnumItem || psiElement instanceof RsStructItem || psiElement instanceof RsTraitItem || psiElement instanceof RsConstant || psiElement instanceof RsMacro || psiElement instanceof RsMacro2;
    }

    private static final boolean computeTargetRangesForEditor$lambda$0(RsLLMDocumentationSupport this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isDocumentable(it);
    }

    private static final Pair computeTargetRangesForEditor$lambda$1(RsLLMDocumentationSupport this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = it.getFirstChild();
        PsiComment psiComment = psiElement instanceof PsiComment ? (PsiComment)psiElement : null;
        if (psiComment == null) {
            return null;
        }
        PsiComment comment = psiComment;
        String string = comment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)this$0.getEmptyDocumentation())) {
            return null;
        }
        return TuplesKt.to((Object)comment.getTextRange(), (Object)it.getTextRange());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findDocTargetsInSelection$lambda$0(RsLLMDocumentationSupport this$0, SelectionModel $selectionModel, PsiElement it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.isDocumentable(it)) {
            return false;
        }
        int elStart = it.getTextRange().getStartOffset();
        int elEnd = it.getTextRange().getEndOffset();
        int selectionStart = $selectionModel.getSelectionStart();
        int selectionEnd = $selectionModel.getSelectionEnd();
        if (selectionStart <= elStart) {
            if (elStart <= selectionEnd) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (selectionStart > elEnd) return false;
        if (elEnd > selectionEnd) return false;
        return true;
    }
}

