/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rust.fix;

import com.intellij.ml.llm.rust.fix.RsMultiShotFixWithAiIntentionKt;
import com.intellij.ml.llm.rust.fix.RsOneShotFixWithAiIntentionKt;
import com.intellij.ml.llm.rust.statistics.RsAICounterUsagesCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.impl.UndoRedoListener;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/rust/fix/RsFixWithAiUndoListener;", "Lcom/intellij/openapi/command/impl/UndoRedoListener;", "<init>", "()V", "undoRedoStarted", "", "project", "Lcom/intellij/openapi/project/Project;", "undoManager", "Lcom/intellij/openapi/command/undo/UndoManager;", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "isUndo", "", "disposable", "Lcom/intellij/openapi/Disposable;", "logNonAgenticUndo", "Lcom/intellij/openapi/fileEditor/TextEditor;", "logAgenticUndo", "intellij.ml.llm.rust"})
public final class RsFixWithAiUndoListener
implements UndoRedoListener {
    public void undoRedoStarted(@Nullable Project project2, @NotNull UndoManager undoManager, @Nullable FileEditor editor2, boolean isUndo, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)undoManager, (String)"undoManager");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        if (project2 == null) {
            return;
        }
        if (!isUndo) {
            return;
        }
        if (!(editor2 instanceof TextEditor)) {
            return;
        }
        this.logNonAgenticUndo((TextEditor)editor2, project2);
        this.logAgenticUndo((TextEditor)editor2, project2);
    }

    private final void logNonAgenticUndo(TextEditor editor2, Project project2) {
        Editor editor3 = editor2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
        Long l = (Long)RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)editor3), RsOneShotFixWithAiIntentionKt.getRS_FIX_WITH_AI_DOC_MODIFICATION_STAMP());
        if (l == null) {
            return;
        }
        long fixWithAiStamp = l;
        long currentStamp = editor2.getEditor().getDocument().getModificationStamp();
        if (fixWithAiStamp != currentStamp) {
            return;
        }
        RsAICounterUsagesCollector.INSTANCE.undoOfFixWithAi(project2, false);
    }

    private final void logAgenticUndo(TextEditor editor2, Project project2) {
        Editor editor3 = editor2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
        Long l = (Long)RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)editor3), RsMultiShotFixWithAiIntentionKt.getAGENTIC_RS_FIX_WITH_AI_DOC_MODIFICATION_STAMP());
        if (l == null) {
            return;
        }
        long fixWithAiStamp = l;
        long currentStamp = editor2.getEditor().getDocument().getModificationStamp();
        if (fixWithAiStamp != currentStamp) {
            return;
        }
        RsAICounterUsagesCollector.INSTANCE.undoOfFixWithAi(project2, true);
    }
}

