/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.consent;

import com.intellij.CommonBundle;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.ml.llm.sql.SqlLLMBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u001a$\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\n\u001a\u00020\u00052\b\b\u0001\u0010\u000b\u001a\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"canAttachSchema", "", "project", "Lcom/intellij/openapi/project/Project;", "schemaName", "", "canAttachContextSchema", "canAttachMentionedSchemas", "canAttachContextObjects", "confirmAttachmentImpl", "title", "message", "intellij.ml.llm.sql"})
public final class ConsentKt {
    @RequiresEdt
    public static final boolean canAttachSchema(@NotNull Project project2, @NotNull String schemaName) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        String string = SqlLLMBundle.message("dialog.title.attach.schema", objectArray);
        objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName(), schemaName};
        return ConsentKt.confirmAttachmentImpl(project2, string, SqlLLMBundle.message("dialog.message.attach.schema", objectArray));
    }

    @RequiresEdt
    public static final boolean canAttachContextSchema(@NotNull Project project2, @NotNull String schemaName) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        String string = SqlLLMBundle.message("dialog.title.attach.schema", objectArray);
        objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName(), schemaName};
        return ConsentKt.confirmAttachmentImpl(project2, string, SqlLLMBundle.message("dialog.message.attach.context.schema", objectArray));
    }

    @RequiresEdt
    public static final boolean canAttachMentionedSchemas(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        String string = SqlLLMBundle.message("dialog.title.attach.schemas", objectArray);
        objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        return ConsentKt.confirmAttachmentImpl(project2, string, SqlLLMBundle.message("dialog.message.attach.mentioned.schemas", objectArray));
    }

    @RequiresEdt
    public static final boolean canAttachContextObjects(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        String string = SqlLLMBundle.message("dialog.title.attach.referenced.objects", objectArray);
        objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        return ConsentKt.confirmAttachmentImpl(project2, string, SqlLLMBundle.message("dialog.message.attach.referenced.objects", objectArray));
    }

    private static final boolean confirmAttachmentImpl(Project project2, @NlsContexts.DialogTitle String title, @NlsContexts.DialogMessage String message) {
        if (LLMSettingsManager.Companion.getInstance().isDatabaseContextEnabled()) {
            return true;
        }
        MessageDialogBuilder.YesNo yesNo = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(title, message).yesText(SqlLLMBundle.message("button.attach", new Object[0]));
        String string = CommonBundle.message((String)"button.cancel", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)yesNo.noText(string)).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(){

            public String getDoNotShowMessage() {
                Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
                return SqlLLMBundle.message("dialog.enable.database.context.message", objectArray);
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected && exitCode == 0) {
                    LLMSettingsManager.Companion.getInstance().setDatabaseContextEnabled(true);
                }
            }
        })).ask(project2);
    }
}

