/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.formatting.settings;

import com.intellij.database.util.SqlDialects;
import com.intellij.lang.Language;
import com.intellij.ml.llm.sql.SqlLLMBundle;
import com.intellij.ml.llm.sql.formatting.SqlAiFormatExamples;
import com.intellij.ml.llm.sql.formatting.settings.SqlDialectWithExample;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0002+,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u001cH\u0002J'\u0010$\u001a\u00020%\"\f\b\u0000\u0010&*\u00020'*\u00020(*\u0002H&2\u0006\u0010)\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ml/llm/sql/formatting/settings/SqlAiExamplesConfigurationPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "exampleService", "Lcom/intellij/ml/llm/sql/formatting/SqlAiFormatExamples;", "dialects", "", "Lcom/intellij/ml/llm/sql/formatting/settings/SqlDialectWithExample;", "myDialectListModel", "Ljavax/swing/DefaultListModel;", "myDialectList", "Lcom/intellij/ui/components/JBList;", "myDialectPanel", "myViewLabel", "Ljavax/swing/JLabel;", "myViewBox", "Ljavax/swing/JTextArea;", "myEditButton", "Ljavax/swing/JButton;", "built", "", "currDialect", "showDialectExample", "", "d", "dialectListSelectionChanged", "ev", "Ljavax/swing/event/ListSelectionEvent;", "editExampleAction", "Ljava/awt/event/ActionEvent;", "closeThisWindow", "wrapWithScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "J", "Ljava/awt/Component;", "Ljavax/swing/Scrollable;", "withBorder", "(Ljava/awt/Component;Z)Lcom/intellij/ui/components/JBScrollPane;", "Companion", "DialectCellRenderer", "intellij.ml.llm.sql"})
@SourceDebugExtension(value={"SMAP\nSqlAiExamplesConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlAiExamplesConfigurationPanel.kt\ncom/intellij/ml/llm/sql/formatting/settings/SqlAiExamplesConfigurationPanel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n30#2,2:192\n1011#3,2:194\n295#3,2:196\n*S KotlinDebug\n*F\n+ 1 SqlAiExamplesConfigurationPanel.kt\ncom/intellij/ml/llm/sql/formatting/settings/SqlAiExamplesConfigurationPanel\n*L\n24#1:192,2\n51#1:194,2\n101#1:196,2\n*E\n"})
public final class SqlAiExamplesConfigurationPanel
extends JPanel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SqlAiFormatExamples exampleService;
    @NotNull
    private final Collection<SqlDialectWithExample> dialects;
    @NotNull
    private final DefaultListModel<SqlDialectWithExample> myDialectListModel;
    @NotNull
    private final JBList<SqlDialectWithExample> myDialectList;
    @NotNull
    private final JPanel myDialectPanel;
    @NotNull
    private final JLabel myViewLabel;
    @NotNull
    private final JTextArea myViewBox;
    @NotNull
    private final JButton myEditButton;
    private boolean built;
    @Nullable
    private SqlDialectWithExample currDialect;
    @Nullable
    private static String lastDialectId;

    /*
     * WARNING - void declaration
     */
    public SqlAiExamplesConfigurationPanel(@NotNull Project project2) {
        Splitter splitter;
        void $this$_init__u24lambda_u247;
        JPanel $this$_init__u24lambda_u245;
        JComponent $this$_init__u24lambda_u244;
        JComponent $this$_init__u24lambda_u243;
        void $this$lambda_u242_u240;
        JComponent $this$_init__u24lambda_u241;
        Object $this$_init__u24lambda_u240;
        Object de;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(new BorderLayout());
        this.project = project2;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<SqlAiFormatExamples> serviceClass$iv = SqlAiFormatExamples.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.exampleService = (SqlAiFormatExamples)object;
        SqlDialects.ensureSqlDialectsLoaded();
        ArrayList dialects = new ArrayList();
        List list = SqlDialects.getSqlDialects();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSqlDialects(...)");
        List allDialects = list;
        SqlDialectWithExample theDialectToShow = null;
        for (SqlLanguageDialect d : allDialects) {
            Path path;
            String string = d.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            if (this.exampleService.makeProjectExampleFilePath(string) == null) continue;
            boolean exampleExists = this.exampleService.checkExampleExists$intellij_ml_llm_sql(path);
            Intrinsics.checkNotNull((Object)d);
            de = new SqlDialectWithExample(d, path, exampleExists);
            ((Collection)dialects).add(de);
            if (lastDialectId == null || !Intrinsics.areEqual((Object)d.getID(), (Object)lastDialectId)) continue;
            theDialectToShow = de;
        }
        Object $this$sortBy$iv = dialects;
        boolean $i$f$sortBy22 = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    SqlDialectWithExample p0 = (SqlDialectWithExample)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)p0.getDisplayName());
                    p0 = (SqlDialectWithExample)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getDisplayName())));
                }
            });
        }
        this.dialects = dialects;
        Object $i$f$sortBy22 = $this$sortBy$iv = new DefaultListModel();
        SqlAiExamplesConfigurationPanel sqlAiExamplesConfigurationPanel = this;
        boolean bl = false;
        ((DefaultListModel)$this$_init__u24lambda_u240).addAll(dialects);
        sqlAiExamplesConfigurationPanel.myDialectListModel = $this$sortBy$iv;
        $this$_init__u24lambda_u240 = $this$sortBy$iv = new JBList((ListModel)this.myDialectListModel);
        sqlAiExamplesConfigurationPanel = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setSelectionMode(0);
        $this$_init__u24lambda_u241.setEmptyText(SqlLLMBundle.message("configurable.database.sql.ai.formatter.settings.noDialectsWithExamplesPrompt", new Object[0]));
        $this$_init__u24lambda_u241.setCellRenderer(new DialectCellRenderer());
        sqlAiExamplesConfigurationPanel.myDialectList = $this$sortBy$iv;
        JPanel $this$_init__u24lambda_u242 = $this$_init__u24lambda_u241 = new JPanel(new BorderLayout());
        boolean bl3 = false;
        $this$_init__u24lambda_u242.add((Component)this.wrapWithScrollPane((Component)this.myDialectList, true));
        Object object2 = de = new JLabel(SqlLLMBundle.message("configurable.database.sql.ai.formatter.settings.label.dialect", new Object[0]));
        JPanel jPanel = $this$_init__u24lambda_u242;
        boolean bl4 = false;
        $this$lambda_u242_u240.setForeground(JBColor.foreground());
        $this$lambda_u242_u240.setLabelFor((Component)this.myDialectList);
        jPanel.add((Component)de, "North");
        JPanel theDialectListPanel = $this$_init__u24lambda_u241;
        $this$_init__u24lambda_u242 = $this$_init__u24lambda_u241 = new JTextArea();
        sqlAiExamplesConfigurationPanel = this;
        boolean bl5 = false;
        ((JTextComponent)$this$_init__u24lambda_u243).setEditable(false);
        $this$_init__u24lambda_u243.setBackground(JBColor.background());
        ((JTextArea)$this$_init__u24lambda_u243).setFont($this$_init__u24lambda_u243.getFont().deriveFont((float)$this$_init__u24lambda_u243.getFont().getSize() * 0.666f));
        sqlAiExamplesConfigurationPanel.myViewBox = $this$_init__u24lambda_u241;
        $this$_init__u24lambda_u243 = $this$_init__u24lambda_u241 = new JLabel(SqlLLMBundle.message("configurable.database.sql.ai.formatter.settings.label.viewExample.empty", new Object[0]));
        sqlAiExamplesConfigurationPanel = this;
        boolean bl6 = false;
        ((JLabel)$this$_init__u24lambda_u244).setLabelFor(this.myViewBox);
        sqlAiExamplesConfigurationPanel.myViewLabel = $this$_init__u24lambda_u241;
        $this$_init__u24lambda_u244 = $this$_init__u24lambda_u241 = new JButton(SqlLLMBundle.message("configurable.database.sql.ai.formatter.settings.edit.button.text", new Object[0]));
        sqlAiExamplesConfigurationPanel = this;
        boolean bl7 = false;
        ((AbstractButton)((Object)$this$_init__u24lambda_u245)).setEnabled(false);
        ((AbstractButton)((Object)$this$_init__u24lambda_u245)).addActionListener(this::editExampleAction);
        sqlAiExamplesConfigurationPanel.myEditButton = $this$_init__u24lambda_u241;
        JPanel $this$_init__u24lambda_u246 = $this$_init__u24lambda_u245 = new JPanel(new BorderLayout());
        boolean bl8 = false;
        $this$_init__u24lambda_u246.add((Component)this.myEditButton, "West");
        JPanel theEditBottomPanel = $this$_init__u24lambda_u245;
        $this$_init__u24lambda_u246 = $this$_init__u24lambda_u245 = new JPanel(new BorderLayout());
        sqlAiExamplesConfigurationPanel = this;
        boolean bl9 = false;
        $this$_init__u24lambda_u247.add((Component)this.wrapWithScrollPane((Component)this.myViewBox, true));
        $this$_init__u24lambda_u247.add((Component)this.myViewLabel, "North");
        $this$_init__u24lambda_u247.add((Component)theEditBottomPanel, "South");
        sqlAiExamplesConfigurationPanel.myDialectPanel = $this$_init__u24lambda_u245;
        Splitter $this$_init__u24lambda_u248 = splitter = new Splitter(false, 0.26f);
        boolean bl10 = false;
        $this$_init__u24lambda_u248.setFirstComponent((JComponent)theDialectListPanel);
        $this$_init__u24lambda_u248.setSecondComponent((JComponent)this.myDialectPanel);
        $this$_init__u24lambda_u248.setAutoscrolls(false);
        Splitter splitterPanel = splitter;
        this.add((Component)splitterPanel);
        SqlDialectWithExample sqlDialectWithExample = theDialectToShow;
        if (sqlDialectWithExample == null) {
            Object v4;
            block7: {
                Iterable $this$firstOrNull$iv = dialects;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SqlDialectWithExample p0 = (SqlDialectWithExample)element$iv;
                    boolean bl11 = false;
                    if (!p0.getExampleExists()) continue;
                    v4 = element$iv;
                    break block7;
                }
                v4 = null;
            }
            if ((sqlDialectWithExample = (SqlDialectWithExample)v4) == null) {
                sqlDialectWithExample = (SqlDialectWithExample)CollectionsKt.firstOrNull((List)dialects);
            }
        }
        if ((theDialectToShow = sqlDialectWithExample) != null) {
            this.showDialectExample(theDialectToShow);
        }
        this.myDialectList.addListSelectionListener(this::dialectListSelectionChanged);
        this.built = true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void showDialectExample(SqlDialectWithExample d) {
        this.myDialectList.setSelectedValue((Object)d, true);
        this.currDialect = d;
        lastDialectId = d.getDialect().getID();
        VirtualFile exampleFile = this.exampleService.getProjectExampleFile$intellij_ml_llm_sql(d.getExamplePath());
        if (exampleFile != null) {
            String text2 = VirtualFileUtil.readText((VirtualFile)exampleFile);
            this.myViewBox.setText(text2);
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)d.getDialect().getDisplayName(), (String)"getDisplayName(...)");
            this.myViewLabel.setText(SqlLLMBundle.message("configurable.database.sql.ai.formatter.settings.label.viewExample.forDialect", objectArray));
            this.myEditButton.setEnabled(true);
        } else {
            this.myViewLabel.setText(SqlLLMBundle.message("configurable.database.sql.ai.formatter.settings.label.viewExample.empty", new Object[0]));
            this.myEditButton.setEnabled(false);
            this.myViewBox.setText(null);
        }
    }

    private final void dialectListSelectionChanged(ListSelectionEvent ev) {
        if (!this.built) {
            return;
        }
        SqlDialectWithExample newDialect = (SqlDialectWithExample)this.myDialectList.getSelectedValue();
        if (newDialect == null || Intrinsics.areEqual((Object)newDialect, (Object)this.currDialect)) {
            return;
        }
        this.showDialectExample(newDialect);
    }

    private final void editExampleAction(ActionEvent ev) {
        if (!this.built) {
            return;
        }
        SqlDialectWithExample sqlDialectWithExample = this.currDialect;
        if (sqlDialectWithExample == null) {
            return;
        }
        SqlDialectWithExample d = sqlDialectWithExample;
        this.closeThisWindow();
        this.exampleService.openExampleFileInEditorInBG$intellij_ml_llm_sql(d.getExamplePath(), (Language)d.getDialect());
    }

    private final void closeThisWindow() {
        Container gp;
        Container p = this;
        while (p.getParent() != null && !((p = gp) instanceof Window)) {
        }
        if (p instanceof Window) {
            if (p instanceof DialogWrapperDialog) {
                DialogWrapper dialogWrapper = ((DialogWrapperDialog)p).getDialogWrapper();
                dialogWrapper.clickDefaultButton();
            } else {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((Window)p, 201));
            }
        }
    }

    private final <J extends Component> JBScrollPane wrapWithScrollPane(J $this$wrapWithScrollPane, boolean withBorder) {
        JBScrollPane sp = new JBScrollPane($this$wrapWithScrollPane);
        sp.setBorder(withBorder ? JBUI.Borders.customLine((Color)JBColor.border()) : null);
        return sp;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/sql/formatting/settings/SqlAiExamplesConfigurationPanel$Companion;", "", "<init>", "()V", "lastDialectId", "", "intellij.ml.llm.sql"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J:\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/sql/formatting/settings/SqlAiExamplesConfigurationPanel$DialectCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/ml/llm/sql/formatting/settings/SqlDialectWithExample;", "<init>", "()V", "dcr", "Ljavax/swing/DefaultListCellRenderer;", "getDcr", "()Ljavax/swing/DefaultListCellRenderer;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.ml.llm.sql"})
    private static final class DialectCellRenderer
    implements ListCellRenderer<SqlDialectWithExample> {
        @NotNull
        private final DefaultListCellRenderer dcr = new DefaultListCellRenderer();

        @NotNull
        public final DefaultListCellRenderer getDcr() {
            return this.dcr;
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends SqlDialectWithExample> list, @Nullable SqlDialectWithExample value, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Component r = this.dcr.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null && r instanceof JLabel && !value.getExampleExists()) {
                ((JLabel)r).setForeground((Color)JBColor.GRAY);
            }
            Intrinsics.checkNotNull((Object)r);
            return r;
        }
    }
}

