/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.collector;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ml.llm.vcs.diff.groupedDiff.ChangesGroup;
import com.intellij.ml.llm.vcs.diff.groupedDiff.FileChangeSubset;
import com.intellij.ml.llm.vcs.diff.groupedDiff.GroupedRange;
import com.intellij.ml.llm.vcs.diff.groupedDiff.LLMVcsDiffBundle;
import com.intellij.ml.llm.vcs.diff.groupedDiff.collector.Description;
import com.intellij.ml.llm.vcs.diff.groupedDiff.collector.GroupedDiffEventsLogger;
import com.intellij.ml.llm.vcs.diff.groupedDiff.collector.GroupedDiffRating;
import com.intellij.ml.llm.vcs.diff.groupedDiff.collector.Groups;
import com.intellij.ml.llm.vcs.diff.groupedDiff.collector.SerializableChange;
import com.intellij.ml.llm.vcs.diff.groupedDiff.collector.SerializableFileChangeSubset;
import com.intellij.ml.llm.vcs.diff.groupedDiff.collector.SerializableGroup;
import com.intellij.ml.llm.vcs.diff.groupedDiff.collector.SerializableGroupedRange;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.GroupedDiffData;
import com.intellij.openapi.diff.impl.patch.TextPatchBuilder;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eJ\b\u0010\u0018\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/collector/ChangesDumper;", "", "data", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupedDiffData;", "<init>", "(Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupedDiffData;)V", "serializableChanges", "", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/collector/SerializableChange;", "projectBasePath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "fileContents", "Lkotlin/Pair;", "", "generateFileContents", "", "dumpChangesToDisk", "showMessageAfterCompletion", "", "sendChangesToCollector", "rating", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/collector/GroupedDiffRating;", "textFeedback", "generateDirectoryName", "findUniqueDirectoryName", "parentDir", "baseName", "findUniqueFileName", "showCompletionDialog", "targetDir", "intellij.ml.llm.vcs.diff"})
@SourceDebugExtension(value={"SMAP\nChangesDumper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesDumper.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/collector/ChangesDumper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,303:1\n1878#2,3:304\n1563#2:308\n1634#2,2:309\n1563#2:311\n1634#2,2:312\n1563#2:314\n1634#2,3:315\n1636#2:318\n774#2:319\n865#2,2:320\n1636#2:322\n1869#2,2:324\n1617#2,9:327\n1869#2:336\n1870#2:338\n1626#2:339\n1761#2,3:340\n205#3:307\n205#3:323\n1#4:326\n1#4:337\n*S KotlinDebug\n*F\n+ 1 ChangesDumper.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/collector/ChangesDumper\n*L\n78#1:304,3\n132#1:308\n132#1:309,2\n133#1:311\n133#1:312,2\n135#1:314\n135#1:315,3\n133#1:318\n151#1:319\n151#1:320,2\n132#1:322\n193#1:324,2\n241#1:327,9\n241#1:336\n241#1:338\n241#1:339\n265#1:340,3\n128#1:307\n162#1:323\n241#1:337\n*E\n"})
public final class ChangesDumper {
    @NotNull
    private final GroupedDiffData data;
    @NotNull
    private final List<SerializableChange> serializableChanges;
    private final Path projectBasePath;
    @NotNull
    private final List<Pair<String, String>> fileContents;

    public ChangesDumper(@NotNull GroupedDiffData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.data = data2;
        this.serializableChanges = new ArrayList();
        String string = this.data.getProject().getBasePath();
        if (string == null) {
            string = "";
        }
        this.projectBasePath = Paths.get(string, new String[0]);
        this.fileContents = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFileContents() {
        void this_$iv;
        Json $this$mapTo$iv$iv;
        void this_$iv2;
        Object afterRelativePath;
        Object afterRevision2;
        this.fileContents.clear();
        this.serializableChanges.clear();
        Iterable $this$forEachIndexed$iv = this.data.getChanges();
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String content2;
            void change;
            int n;
            if ((n = index$iv22++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Change change2 = (Change)item$iv;
            int index = n;
            boolean bl = false;
            ContentRevision beforeRevision = change.getBeforeRevision();
            afterRevision2 = change.getAfterRevision();
            String beforeFileName = null;
            String afterFileName = null;
            String beforeRelativePath = null;
            afterRelativePath = null;
            if (beforeRevision != null) {
                beforeFileName = this.findUniqueFileName("before_" + beforeRevision.getFile().getName());
                beforeRelativePath = TextPatchBuilder.getRelativePath((Path)this.projectBasePath, (FilePath)beforeRevision.getFile());
                try {
                    String string = beforeRevision.getContent();
                    if (string == null) {
                        string = "";
                    }
                    content2 = string;
                    this.fileContents.add((Pair<String, String>)TuplesKt.to((Object)beforeFileName, (Object)content2));
                }
                catch (VcsException vcsException) {
                    this.fileContents.add((Pair<String, String>)TuplesKt.to((Object)beforeFileName, (Object)""));
                }
            }
            if (afterRevision2 != null) {
                afterFileName = this.findUniqueFileName("after_" + afterRevision2.getFile().getName());
                afterRelativePath = TextPatchBuilder.getRelativePath((Path)this.projectBasePath, (FilePath)afterRevision2.getFile());
                try {
                    String string = afterRevision2.getContent();
                    if (string == null) {
                        string = "";
                    }
                    content2 = string;
                    this.fileContents.add((Pair<String, String>)TuplesKt.to((Object)afterFileName, (Object)content2));
                }
                catch (VcsException vcsException) {
                    this.fileContents.add((Pair<String, String>)TuplesKt.to((Object)afterFileName, (Object)""));
                }
            }
            this.serializableChanges.add(new SerializableChange(index, beforeRelativePath, (String)afterRelativePath, beforeFileName, afterFileName));
        }
        String string = this.data.getProject().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Description description = new Description(string, this.data.getMessage(), this.serializableChanges);
        Json index$iv22 = (Json)Json.Default;
        Description value$iv = description;
        boolean $i$f$encodeToString = false;
        this_$iv2.getSerializersModule();
        String descriptionJson = this_$iv2.encodeToString((SerializationStrategy)Description.Companion.serializer(), (Object)value$iv);
        this.fileContents.add((Pair<String, String>)TuplesKt.to((Object)"description.json", (Object)descriptionJson));
        Iterable $this$map$iv = this.data.getGroups();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapTo$iv$iv2;
            void group;
            afterRevision2 = (ChangesGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = group.getFiles();
            boolean $i$f$map2 = false;
            afterRelativePath = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void $this$mapTo$iv$iv3;
                void fileChangeSubset;
                FileChangeSubset fileChangeSubset2 = (FileChangeSubset)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                int changeIndex = this.data.getChanges().indexOf(fileChangeSubset.getChange());
                List list = fileChangeSubset.getChanges();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Iterable $this$map$iv3 = list;
                boolean $i$f$map3 = false;
                Iterable iterable2 = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                    void groupedRange;
                    GroupedRange groupedRange2 = (GroupedRange)item$iv$iv3;
                    Collection collection3 = destination$iv$iv3;
                    boolean bl3 = false;
                    collection3.add(new SerializableGroupedRange(groupedRange.getAfterLine1(), groupedRange.getAfterLine2(), groupedRange.getBeforeLine1(), groupedRange.getBeforeLine2(), groupedRange.getGroupId()));
                }
                List serializableChanges = (List)destination$iv$iv3;
                collection2.add(new SerializableFileChangeSubset(changeIndex, serializableChanges, fileChangeSubset.getSummary(), fileChangeSubset.getImportance()));
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SerializableFileChangeSubset it = (SerializableFileChangeSubset)element$iv$iv;
                boolean bl4 = false;
                if (!(it.getChangeIndex() >= 0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List fileChangeSubsets = (List)destination$iv$iv2;
            collection.add(new SerializableGroup(group.getId(), group.getName(), group.getDescription(), group.getImportance(), fileChangeSubsets));
        }
        List serializableGroups = (List)destination$iv$iv;
        Groups groupsData = new Groups(serializableGroups);
        $this$mapTo$iv$iv = (Json)Json.Default;
        Groups value$iv2 = groupsData;
        boolean $i$f$encodeToString2 = false;
        this_$iv.getSerializersModule();
        String groupsJson = this_$iv.encodeToString((SerializationStrategy)Groups.Companion.serializer(), (Object)value$iv2);
        this.fileContents.add((Pair<String, String>)TuplesKt.to((Object)"groups.json", (Object)groupsJson));
        this.fileContents.add((Pair<String, String>)TuplesKt.to((Object)"changes.patch", (Object)this.data.getPatch()));
        this.fileContents.add((Pair<String, String>)TuplesKt.to((Object)"aiDiffTrace.log", (Object)this.data.getTracer().getTracesAsString()));
    }

    public final void dumpChangesToDisk(boolean showMessageAfterCompletion) {
        try {
            this.generateFileContents();
            String userHome = System.getProperty("user.home");
            String[] stringArray = new String[]{"GroupedDiffCases"};
            Path groupedDiffCasesDir = Paths.get(userHome, stringArray);
            Files.createDirectories(groupedDiffCasesDir, new FileAttribute[0]);
            String baseDirName = this.generateDirectoryName();
            Intrinsics.checkNotNull((Object)groupedDiffCasesDir);
            String uniqueDirName = this.findUniqueDirectoryName(groupedDiffCasesDir, baseDirName);
            Path targetDir = groupedDiffCasesDir.resolve(uniqueDirName);
            Files.createDirectories(targetDir, new FileAttribute[0]);
            Iterable $this$forEach$iv = this.fileContents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                String fileName = (String)pair.component1();
                String content2 = (String)pair.component2();
                Path path = targetDir.resolve(fileName);
                byte[] byArray = content2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                Files.write(path, byArray, new OpenOption[0]);
            }
            if (showMessageAfterCompletion) {
                Intrinsics.checkNotNull((Object)targetDir);
                this.showCompletionDialog(targetDir);
            }
        }
        catch (Exception e) {
            Project project2 = this.data.getProject();
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            Messages.showErrorDialog((Project)project2, (String)LLMVcsDiffBundle.message("grouped.diff.dump.error.message", objectArray), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
        }
    }

    public final void sendChangesToCollector(@NotNull GroupedDiffData data2, @NotNull GroupedDiffRating rating, @NotNull String textFeedback) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)rating), (String)"rating");
        Intrinsics.checkNotNullParameter((Object)textFeedback, (String)"textFeedback");
        try {
            this.generateFileContents();
            long groupedDiffId = data2.getId();
            GroupedDiffEventsLogger.INSTANCE.logRated(groupedDiffId, data2.getOrigin(), rating, textFeedback, data2.getChanges().size(), this.fileContents);
        }
        catch (Exception e) {
            Project project2 = data2.getProject();
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            Messages.showErrorDialog((Project)project2, (String)LLMVcsDiffBundle.message("grouped.diff.dump.error.message", objectArray), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String generateDirectoryName() {
        String string;
        CharSequence charSequence = this.data.getMessage();
        if (!(charSequence == null || charSequence.length() == 0)) {
            CharSequence charSequence2;
            charSequence = this.data.getMessage();
            Regex regex = new Regex("[^a-zA-Z0-9]");
            String string2 = "_";
            charSequence = regex.replace(charSequence, string2);
            regex = new Regex("^_+");
            string2 = "";
            charSequence = regex.replace(charSequence, string2);
            regex = new Regex("_+");
            string2 = "_";
            charSequence = StringsKt.take((String)regex.replace(charSequence, string2), (int)50);
            regex = new Regex("_+$");
            string2 = "";
            if ((charSequence = (CharSequence)regex.replace(charSequence, string2)).length() == 0) {
                boolean bl = false;
                charSequence2 = "unnamed";
            } else {
                charSequence2 = charSequence;
            }
            string = (String)charSequence2;
        } else {
            CharSequence charSequence3;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.data.getChanges();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Change change = (Change)element$iv$iv;
                boolean bl2 = false;
                Object object2 = change.getAfterRevision();
                if (object2 != null && (object2 = object2.getFile()) != null && (object2 = object2.getName()) != null) {
                    Object object3;
                    Object it = object3 = object2;
                    boolean bl3 = false;
                    object = ((CharSequence)it).length() > 0 ? object3 : null;
                } else {
                    object = null;
                }
                if (object == null) continue;
                Object it$iv$iv = object;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List fileNames = (List)destination$iv$iv;
            List baseName = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.data.getProject().getName()), (Iterable)fileNames);
            CharSequence charSequence4 = StringsKt.take((String)CollectionsKt.joinToString$default((Iterable)baseName, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null), (int)50);
            if (charSequence4.length() == 0) {
                boolean bl = false;
                charSequence3 = "unnamed";
            } else {
                charSequence3 = charSequence4;
            }
            string = (String)charSequence3;
        }
        return string;
    }

    private final String findUniqueDirectoryName(Path parentDir, String baseName) {
        int counter = 0;
        Object candidateName = baseName;
        while (Files.exists(parentDir.resolve((String)candidateName), new LinkOption[0])) {
            candidateName = baseName + "_" + ++counter;
        }
        return candidateName;
    }

    private final String findUniqueFileName(String baseName) {
        int counter = 0;
        Object candidateName = null;
        candidateName = baseName;
        while (true) {
            String string;
            boolean bl;
            block6: {
                Iterable $this$any$iv = this.fileContents;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)candidateName)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) break;
            ++counter;
            int dotIndex = StringsKt.lastIndexOf$default((CharSequence)baseName, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIndex > 0) {
                String string2 = baseName.substring(0, dotIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String string3 = baseName.substring(dotIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                string = string2 + "_" + counter + string3;
            } else {
                string = baseName + "_" + counter;
            }
            candidateName = string;
        }
        return candidateName;
    }

    private final void showCompletionDialog(Path targetDir) {
        Object[] objectArray = new Object[]{((Object)targetDir.toAbsolutePath()).toString()};
        String message = LLMVcsDiffBundle.message("grouped.diff.dump.success.message", objectArray);
        String[] stringArray = new String[]{DiagnosticBundle.message((String)"action.copy.path.text", (Object[])new Object[0]), DiagnosticBundle.message((String)"action.open.folder.text", (Object[])new Object[0]), CommonBundle.message((String)"button.ok", (Object[])new Object[0])};
        int result2 = Messages.showDialog((Project)this.data.getProject(), (String)message, (String)LLMVcsDiffBundle.message("grouped.diff.dump.success.title", new Object[0]), (String[])stringArray, (int)2, (Icon)Messages.getInformationIcon());
        switch (result2) {
            case 0: {
                CopyPasteManager clipboard = CopyPasteManager.getInstance();
                StringSelection stringSelection = new StringSelection(((Object)targetDir.toAbsolutePath()).toString());
                clipboard.setContents((Transferable)stringSelection);
                break;
            }
            case 1: {
                RevealFileAction.openDirectory((Path)targetDir);
            }
        }
    }
}

