/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.commit;

import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.ml.llm.vcs.diff.groupedDiff.commit.AIDiffSplitService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProvider;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.lang.invoke.MethodHandles;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIDiffChangeDiffRequestProvider;", "Lcom/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProvider;", "<init>", "()V", "isEquals", "Lcom/intellij/util/ThreeState;", "change1", "Lcom/intellij/openapi/vcs/changes/Change;", "change2", "canCreate", "", "project", "Lcom/intellij/openapi/project/Project;", "change", "createSimpleRequest", "Lcom/intellij/diff/requests/SimpleDiffRequest;", "presentable", "Lcom/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestProducer;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "process", "Lcom/intellij/diff/requests/DiffRequest;", "intellij.ml.llm.vcs.diff"})
@SourceDebugExtension(value={"SMAP\nAIDiffChangeDiffRequestProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIDiffChangeDiffRequestProvider.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIDiffChangeDiffRequestProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n30#2,2:102\n57#3:104\n35#3,2:105\n*S KotlinDebug\n*F\n+ 1 AIDiffChangeDiffRequestProvider.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIDiffChangeDiffRequestProvider\n*L\n37#1:102,2\n50#1:104\n50#1:105,2\n*E\n"})
public final class AIDiffChangeDiffRequestProvider
implements ChangeDiffRequestProvider {
    @NotNull
    public ThreeState isEquals(@NotNull Change change1, @NotNull Change change2) {
        Intrinsics.checkNotNullParameter((Object)change1, (String)"change1");
        Intrinsics.checkNotNullParameter((Object)change2, (String)"change2");
        return ThreeState.UNSURE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canCreate(@Nullable Project project2, @NotNull Change change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (change.getType() != Change.Type.NEW) return false;
        if (!(change instanceof ChangeListChange)) return false;
        if (ChangesUtil.isTextConflictingChange((Change)change)) return false;
        Project project3 = project2;
        Object object = project3;
        if (project3 == null) return false;
        ComponentManager $this$service$iv = (ComponentManager)object;
        boolean $i$f$service = false;
        Class<AIDiffSplitService> serviceClass$iv = AIDiffSplitService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        AIDiffSplitService aIDiffSplitService = (AIDiffSplitService)object2;
        object = aIDiffSplitService;
        if (aIDiffSplitService == null) return false;
        boolean bl = ((AIDiffSplitService)object).hasAiChangeLists();
        if (!bl) return false;
        return true;
    }

    @NotNull
    public final SimpleDiffRequest createSimpleRequest(@NotNull ChangeDiffRequestProducer presentable, @Nullable Project project2, @NotNull Change change, @NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator) {
        String editorTabTitle;
        String string;
        Intrinsics.checkNotNullParameter((Object)presentable, (String)"presentable");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        if (bRev == null && aRev == null) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Both revision contents are empty");
            throw new DiffRequestProducerException(DiffBundle.message((String)"error.cant.show.diff.content.not.found", (Object[])new Object[0]));
        }
        if (bRev != null) {
            ChangeDiffRequestProducer.checkContentRevision((Project)project2, (ContentRevision)bRev, (UserDataHolder)context2, (ProgressIndicator)indicator);
        }
        if (aRev != null) {
            ChangeDiffRequestProducer.checkContentRevision((Project)project2, (ContentRevision)aRev, (UserDataHolder)context2, (ProgressIndicator)indicator);
        }
        if ((string = (editorTabTitle = presentable.getEditorTabTitle())) == null) {
            String string2 = ChangeDiffRequestProducer.getRequestTitle((Change)change);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRequestTitle(...)");
        }
        String title = string;
        indicator.setIndeterminate(true);
        DiffContent diffContent = bRev == null ? (DiffContent)new DocumentContentImpl((Document)new DocumentImpl("")) : ChangeDiffRequestProducer.createContent((Project)project2, (ContentRevision)bRev, (UserDataHolder)context2, (ProgressIndicator)indicator);
        Intrinsics.checkNotNull((Object)diffContent);
        DiffContent content1 = diffContent;
        DiffContent diffContent2 = ChangeDiffRequestProducer.createContent((Project)project2, (ContentRevision)aRev, (UserDataHolder)context2, (ProgressIndicator)indicator);
        Intrinsics.checkNotNullExpressionValue((Object)diffContent2, (String)"createContent(...)");
        DiffContent content2 = diffContent2;
        String userLeftRevisionTitle = presentable.getLeftContentTitle();
        String string3 = userLeftRevisionTitle;
        if (string3 == null) {
            String string4 = ChangeDiffRequestProducer.getRevisionTitle((ContentRevision)bRev, (String)ChangeDiffRequestProducer.getBaseVersion());
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getRevisionTitle(...)");
        }
        String beforeRevisionTitle = string3;
        String userRightRevisionTitle = presentable.getRightContentTitle();
        String string5 = userRightRevisionTitle;
        if (string5 == null) {
            String string6 = ChangeDiffRequestProducer.getRevisionTitle((ContentRevision)aRev, (String)ChangeDiffRequestProducer.getYourVersion());
            string5 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getRevisionTitle(...)");
        }
        String afterRevisionTitle = string5;
        SimpleDiffRequest request2 = new SimpleDiffRequest(title, content1, content2, beforeRevisionTitle, afterRevisionTitle);
        boolean bRevCurrent = bRev instanceof CurrentContentRevision;
        boolean aRevCurrent = aRev instanceof CurrentContentRevision;
        if (bRevCurrent && !aRevCurrent) {
            request2.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.LEFT);
        }
        if (!bRevCurrent && aRevCurrent) {
            request2.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.RIGHT);
        }
        return request2;
    }

    @NotNull
    public DiffRequest process(@NotNull ChangeDiffRequestProducer presentable, @NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator) {
        DocumentContent content2;
        Intrinsics.checkNotNullParameter((Object)presentable, (String)"presentable");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Project project2 = presentable.getProject();
        Change change = presentable.getChange();
        Intrinsics.checkNotNullExpressionValue((Object)change, (String)"getChange(...)");
        SimpleDiffRequest request2 = this.createSimpleRequest(presentable, project2, change, context2, indicator);
        DiffUtil.addTitleCustomizers((DiffRequest)((DiffRequest)request2), (List)presentable.createTitleCustomizers());
        Change change2 = presentable.getChange();
        Intrinsics.checkNotNullExpressionValue((Object)change2, (String)"getChange(...)");
        Change change3 = change2;
        if (project2 == null) {
            return (DiffRequest)request2;
        }
        if (!(change3 instanceof ChangeListChange)) {
            return (DiffRequest)request2;
        }
        List list = request2.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
        List contents = list;
        if (contents.size() != 2) {
            return (DiffRequest)request2;
        }
        Object object = Side.RIGHT.select(contents);
        DocumentContent documentContent = content2 = object instanceof DocumentContent ? (DocumentContent)object : null;
        if (content2 == null || !(content2 instanceof FileContent)) {
            return (DiffRequest)request2;
        }
        VirtualFile virtualFile2 = ((FileContent)content2).getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        VirtualFile virtualFile3 = virtualFile2;
        if (!LineStatusTrackerManager.Companion.getInstance(project2).arePartialChangelistsEnabled(virtualFile3)) {
            return (DiffRequest)request2;
        }
        return (DiffRequest)new LocalChangeListDiffRequest(project2, virtualFile3, ((ChangeListChange)change3).getChangeListId(), ((ChangeListChange)change3).getChangeListName(), (ContentDiffRequest)request2);
    }
}

