/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.metrics;

import com.intellij.ml.llm.vcs.LLMCommitMessageActionKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001e\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/vcs/metrics/CMGMetricsState;", "", "message", "", "changesInput", "", "Lcom/intellij/openapi/vcs/changes/Change;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/openapi/project/Project;)V", "getMessage", "()Ljava/lang/String;", "changes", "diffHash", "", "sortChanges", "getDiff", "isExpired", "", "currentChangesInput", "intellij.ml.llm.vcs"})
@SourceDebugExtension(value={"SMAP\nCMGMetricsState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMGMetricsState.kt\ncom/intellij/ml/llm/vcs/metrics/CMGMetricsState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1056#2:36\n*S KotlinDebug\n*F\n+ 1 CMGMetricsState.kt\ncom/intellij/ml/llm/vcs/metrics/CMGMetricsState\n*L\n17#1:36\n*E\n"})
public final class CMGMetricsState {
    @NotNull
    private final String message;
    @NotNull
    private final List<Change> changes;
    private final int diffHash;

    public CMGMetricsState(@NotNull String message, @NotNull List<? extends Change> changesInput, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(changesInput, (String)"changesInput");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.message = message;
        this.changes = this.sortChanges(changesInput);
        this.diffHash = this.getDiff(this.changes, project2);
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    private final List<Change> sortChanges(List<? extends Change> changesInput) {
        Iterable $this$sortedBy$iv = changesInput;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Change it = (Change)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.hashCode());
                it = (Change)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.hashCode()));
            }
        });
    }

    private final int getDiff(List<? extends Change> changesInput, Project project2) {
        return LLMCommitMessageActionKt.calculateDiff$default(changesInput, project2, false, 4, null).hashCode();
    }

    public final boolean isExpired(@NotNull List<? extends Change> currentChangesInput, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter(currentChangesInput, (String)"currentChangesInput");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List<Change> currentChanges = this.sortChanges(currentChangesInput);
        int currentDiffHash = this.getDiff(currentChanges, project2);
        return !Intrinsics.areEqual(currentChanges, this.changes) || currentDiffHash != this.diffHash;
    }
}

