/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.selfReview.ui;

import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.ml.llm.vcs.selfReview.agent.model.VcsAISelfReviewResult;
import com.intellij.ml.llm.vcs.selfReview.ui.VcsAISelfReviewFileProblemsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010$\u001a\u00020\u001bH\u0016J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006*"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/ui/VcsAISelfReviewFileProblem;", "Lcom/intellij/analysis/problemsView/FileProblem;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "reviewProblem", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult$Problem;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult$Problem;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "getProvider", "()Lcom/intellij/analysis/problemsView/ProblemsProvider;", "severity", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult$Severity;", "getSeverity", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult$Severity;", "description", "", "getDescription", "()Ljava/lang/String;", "text", "getText", "line", "", "getLine", "()I", "lineEnd", "getLineEnd", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "hashCode", "equals", "", "other", "", "toString", "intellij.ml.llm.vcs"})
public final class VcsAISelfReviewFileProblem
implements FileProblem {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final VcsAISelfReviewResult.Problem reviewProblem;
    @NotNull
    private final ProblemsProvider provider;

    public VcsAISelfReviewFileProblem(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull VcsAISelfReviewResult.Problem reviewProblem) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)reviewProblem, (String)"reviewProblem");
        this.file = file2;
        this.reviewProblem = reviewProblem;
        this.provider = new VcsAISelfReviewFileProblemsProvider(project2);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public ProblemsProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final VcsAISelfReviewResult.Severity getSeverity() {
        return this.reviewProblem.getSeverity();
    }

    @NotNull
    public String getDescription() {
        return this.reviewProblem.getReasoning();
    }

    @NotNull
    public String getText() {
        return this.reviewProblem.getMessage();
    }

    public int getLine() {
        return Math.max(0, this.reviewProblem.getLineStart() - 1);
    }

    public final int getLineEnd() {
        return Math.max(0, this.reviewProblem.getLineEnd() - 1);
    }

    @NotNull
    public Icon getIcon() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.reviewProblem.getSeverity().ordinal()]) {
            case 1 -> HighlightDisplayLevel.ERROR.getIcon();
            case 2 -> HighlightDisplayLevel.WARNING.getIcon();
            case 3 -> HighlightDisplayLevel.WARNING.getIcon();
            case 4 -> HighlightDisplayLevel.WEAK_WARNING.getIcon();
            case 5 -> HighlightDisplayLevel.INFO.getIcon();
            case 6 -> HighlightDisplayLevel.WEAK_WARNING.getIcon();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getFile(), this.reviewProblem};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        VcsAISelfReviewFileProblem vcsAISelfReviewFileProblem = object2 instanceof VcsAISelfReviewFileProblem ? (VcsAISelfReviewFileProblem)object2 : null;
        if (vcsAISelfReviewFileProblem == null) {
            return false;
        }
        VcsAISelfReviewFileProblem that = vcsAISelfReviewFileProblem;
        return Intrinsics.areEqual((Object)that.getFile(), (Object)this.getFile()) && Intrinsics.areEqual((Object)that.reviewProblem, (Object)this.reviewProblem);
    }

    @NotNull
    public String toString() {
        return "Problem(file=" + this.getFile().getPath() + ", severity=" + this.getSeverity() + ", text='" + this.getText() + "', lines=" + this.getLine() + "-" + this.getLineEnd() + ")";
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VcsAISelfReviewResult.Severity.values().length];
            try {
                nArray[VcsAISelfReviewResult.Severity.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VcsAISelfReviewResult.Severity.StrongWarning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VcsAISelfReviewResult.Severity.Warning.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VcsAISelfReviewResult.Severity.WeakWarning.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VcsAISelfReviewResult.Severity.Info.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VcsAISelfReviewResult.Severity.Typo.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

