/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.dircache.BaseDirCacheEditor;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.git.AddFile;
import org.jetbrains.settingsRepository.git.AddLoadedFile;
import org.jetbrains.settingsRepository.git.DeleteDirectory;
import org.jetbrains.settingsRepository.git.DeleteFile;
import org.jetbrains.settingsRepository.git.DirCacheEditorKt;
import org.jetbrains.settingsRepository.git.PathEdit;
import org.jetbrains.settingsRepository.git.PathEditBase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/settingsRepository/git/DirCacheEditor;", "Lorg/eclipse/jgit/dircache/BaseDirCacheEditor;", "edits", "", "Lorg/jetbrains/settingsRepository/git/PathEdit;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "dirCache", "Lorg/eclipse/jgit/dircache/DirCache;", "estimatedNumberOfEntries", "", "<init>", "(Ljava/util/List;Lorg/eclipse/jgit/lib/Repository;Lorg/eclipse/jgit/dircache/DirCache;I)V", "commit", "", "finish", "", "applyEdits", "intellij.settingsRepository"})
public final class DirCacheEditor
extends BaseDirCacheEditor {
    @NotNull
    private final Repository repository;
    @NotNull
    private final List<PathEdit> edits;

    public DirCacheEditor(@NotNull List<? extends PathEdit> edits, @NotNull Repository repository, @NotNull DirCache dirCache, int estimatedNumberOfEntries) {
        Intrinsics.checkNotNullParameter(edits, (String)"edits");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)dirCache, (String)"dirCache");
        super(dirCache, estimatedNumberOfEntries);
        this.repository = repository;
        this.edits = CollectionsKt.sortedWith((Iterable)edits, (Comparator)DirCacheEditorKt.access$getEDIT_CMP$p());
    }

    public boolean commit() {
        if (this.edits.isEmpty()) {
            this.cache.unlock();
            return true;
        }
        return super.commit();
    }

    public void finish() {
        if (!this.edits.isEmpty()) {
            this.applyEdits();
            this.replace();
        }
    }

    private final void applyEdits() {
        int maxIndex = this.cache.getEntryCount();
        int lastIndex = 0;
        for (PathEdit edit : this.edits) {
            int count;
            boolean missing;
            int entryIndex = this.cache.findEntry(edit.getPath(), edit.getPath().length);
            boolean bl = missing = entryIndex < 0;
            if (entryIndex < 0) {
                entryIndex = -(entryIndex + 1);
            }
            if ((count = Math.min(entryIndex, maxIndex) - lastIndex) > 0) {
                this.fastKeep(lastIndex, count);
            }
            int n = lastIndex = missing ? entryIndex : this.cache.nextEntry(entryIndex);
            if (edit instanceof DeleteFile) continue;
            if (edit instanceof DeleteDirectory) {
                lastIndex = this.cache.nextEntry(((DeleteDirectory)edit).getPath(), ((DeleteDirectory)edit).getPath().length, entryIndex);
                continue;
            }
            if (missing) {
                DirCacheEntry entry = new DirCacheEntry(edit.getPath());
                edit.apply(entry, this.repository);
                if (entry.getRawMode() == 0) {
                    Object[] objectArray = new Object[]{entry.getPathString()};
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().fileModeNotSetForPath, objectArray));
                }
                this.fastAdd(entry);
                continue;
            }
            if (edit instanceof AddFile || edit instanceof AddLoadedFile) {
                DirCacheEntry firstEntry = this.cache.getEntry(entryIndex);
                DirCacheEntry entry = null;
                if (firstEntry.isMerged()) {
                    Intrinsics.checkNotNull((Object)firstEntry);
                    entry = firstEntry;
                } else {
                    entry = new DirCacheEntry(((PathEditBase)edit).getPath());
                    entry.setCreationTime(firstEntry.getCreationTime());
                }
                edit.apply(entry, this.repository);
                this.fastAdd(entry);
                continue;
            }
            int n2 = lastIndex;
            for (int i = entryIndex; i < n2; ++i) {
                DirCacheEntry entry = this.cache.getEntry(i);
                Intrinsics.checkNotNull((Object)entry);
                edit.apply(entry, this.repository);
                this.fastAdd(entry);
            }
        }
        int count = maxIndex - lastIndex;
        if (count > 0) {
            this.fastKeep(lastIndex, count);
        }
    }
}

