#ifndef GUI_CORNERCROSSLETTERS_H
#define GUI_CORNERCROSSLETTERS_H

namespace Gui
{

//****************************************************************************

// Pixel map representations of an "X", a "Y" and a "Z" for the axis cross.
// Each character is defined as a 21x27 grayscale RGBA pixel map
// 21x27 is 3x a standard 5x7 representation with 1px margin
// This allows good anti-aliasing aspect at any usable size
// It is generated with Gimp using Bitstream Charter Bold font, 28 px, on transparent background
// It is then directly exported as C source type after image is vertically flipped for direct GL
// usage With enabled options "Use macros instead of struct" and "Save alpha channel"

#define XPM_WIDTH (21)
#define XPM_HEIGHT (27)
#define XPM_BYTES_PER_PIXEL (4) /* 2:RGB16, 3:RGB, 4:RGBA */
#define XPM_PIXEL_MASK ((unsigned char*)::XPM_pixel_mask)
static const unsigned char XPM_pixel_mask[21 * 27 * 4 + 1]
    = ("\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\261\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\320\000\000\000\003\000"
       "\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000w\000\000"
       "\000\377\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000Y\000\000\000\000\000\000\000\000\000\000\000\036\000\000\000\364"
       "\000\000\000\377\000\000\000\377\000\000"
       "\000\377\000\000\000j\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\032\000\000"
       "\000\363\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\264\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000u\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\355\000"
       "\000\000\023\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\245\000\000\000\377\000"
       "\000\000\377\000\000\000\377\000\000\000\363"
       "\000\000\000\035\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\004\000\000\000\322\000\000\000\377\000\000"
       "\000\377\000\000\000\377\000\000\000\230\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000<\000\000\000\377"
       "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000l\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000:"
       "\000\000\000\376\000\000\000\377\000\000\000\377\000\000\000\375\000\000\000\062\000\000"
       "\000"
       "\000\000\000\000\000\000\000\000\002\000\000\000\317\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\306\000\000\000"
       "\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\233\000\000\000"
       "\377\000\000\000\377\000\000\000\377\000\000\000\305\000\000\000\001\000\000\000\000\000"
       "\000\000h\000\000\000\377\000\000\000"
       "\377\000\000\000\377\000\000\000\371\000\000\000*"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\021\000\000\000\352\000\000\000"
       "\377\000\000\000\377\000\000\000\377\000"
       "\000\000]"
       "\000\000\000\022\000\000\000\354\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
       "\000\177\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000^"
       "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\347\000\000\000\241\000\000"
       "\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\325\000\000\000\006\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\277\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\375\000\000\000"
       "\071\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000("
       "\000\000\000\371\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
       "\000\377"
       "\000\000\000\222\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\215\000\000\000\377\000\000\000"
       "\377\000\000\000\377\000\000\000\377\000\000\000\375\000\000\000\026\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\003\000\000\000\315\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
       "\000\377\000\000\000\377\000\000\000"
       "\202\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000l\000\000"
       "\000\377\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\370\000\000\000$"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\027\000\000"
       "\000\360\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\305\000\000\000\377"
       "\000\000\000\377\000\000\000\377"
       "\000\000\000\265\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\243\000\000\000\377\000\000"
       "\000\377\000\000\000\377\000\000\000\302"
       "\000\000\000\015\000\000\000\351\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
       "\000N\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000>\000\000\000\377\000"
       "\000\000\377\000\000\000\377\000\000\000\376\000\000\000\063\000\000\000\000\000\000\000i"
       "\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\337\000\000\000\011\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\004\000\000\000\324\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\241\000\000\000"
       "\000\000\000\000\000\000\000\000\003\000\000\000\326\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\201\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000u\000\000\000\377\000\000\000"
       "\377\000\000\000\377\000\000\000\365\000\000\000\033\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000M\000\000\000\377"
       "\000\000\000\377\000\000\000\377\000\000\000\367\000\000\000#"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\034\000\000\000\363\000\000\000\377\000\000\000\377\000\000\000\377"
       "\000\000\000\200\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\276\000\000\000"
       "\377\000\000\000\377\000\000\000\377\000\000"
       "\000\264\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\253\000\000\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\345\000\000\000\012\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\062\000\000\000\376\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000M\000"
       "\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000G\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
       "\000_\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\243\000\000\000\377\000\000\000\377\000\000\000"
       "\377\000\000\000\336\000\000\000\010\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000");

#define YPM_WIDTH (21)
#define YPM_HEIGHT (27)
#define YPM_BYTES_PER_PIXEL (4) /* 2:RGB16, 3:RGB, 4:RGBA */
#define YPM_PIXEL_MASK ((unsigned char*)::YPM_pixel_mask)
static const unsigned char YPM_pixel_mask[21 * 27 * 4 + 1]
    = ("\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\\\000\000\000\377\000\000\000"
       "\377\000\000\000\377\000\000\000\330\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\\\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\330\000"
       "\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\\000\000\000"
       "\377\000\000\000\377\000\000\000\377\000\000"
       "\000\330\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\\\000\000\000"
       "\377\000\000\000\377\000\000\000\377\000\000\000\330\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\\\000\000\000\377\000\000\000\377\000\000\000\377"
       "\000\000\000\330\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\\\000\000\000\377\000\000\000\377\000\000"
       "\000\377\000\000\000\330\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\\\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\330\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\\000\000\000\377\000\000\000"
       "\377\000\000\000\377\000\000\000\330\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\242\000\000\000\377\000"
       "\000\000\377\000\000\000\377\000\000\000\365\000\000\000\026\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000'"
       "\000\000\000\374\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
       "\000\216\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\246\000"
       "\000\000\377\000\000\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\377\000\000\000\367\000\000\000\033\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000+\000\000"
       "\000\375\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\225"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\253\000\000\000\377\000\000\000"
       "\377\000\000\000\377\000\000\000\371\000"
       "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\371\000\000\000\037\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000/\000\000\000\376\000"
       "\000\000\377\000\000\000\377\000\000\000\377\000\000\000d\000\000\000\340\000\000\000\377"
       "\000\000\000\377\000\000\000\377"
       "\000\000\000\235\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\260\000\000\000\377\000\000\000\377\000\000"
       "\000\377\000\000\000\332\000\000\000\003"
       "\000\000\000e\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\373\000\000\000$"
       "\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\063\000\000\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\377\000\000\000\\\000\000\000\000\000\000\000\004\000\000\000"
       "\335\000\000\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\244\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\265\000\000\000\377\000\000\000\377\000\000\000\377\000"
       "\000\000\330\000\000\000\003\000\000\000"
       "\000\000\000\000\000\000\000\000a\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
       "\000\375\000\000\000*\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\070\000\000\000\377\000\000\000\377\000\000\000"
       "\377\000\000\000\377\000\000\000Z\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\003\000\000\000\332\000\000\000\377"
       "\000\000\000\377\000\000\000\377\000\000\000\253\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\272\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\327"
       "\000\000\000\002\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000]"
       "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\376\000\000\000"
       "\060\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000<"
       "\000\000\000\377\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000X\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\002\000\000\000\327"
       "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\262\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\277\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\325\000\000\000"
       "\002\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000Y\000\000\000\377"
       "\000\000\000\377\000\000\000\377\000\000\000"
       "\377\000\000\000\066\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000");

#define ZPM_WIDTH (21)
#define ZPM_HEIGHT (27)
#define ZPM_BYTES_PER_PIXEL (4) /* 2:RGB16, 3:RGB, 4:RGBA */
#define ZPM_PIXEL_MASK ((unsigned char*)::ZPM_pixel_mask)
static const unsigned char ZPM_pixel_mask[21 * 27 * 4 + 1]
    = ("\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000T\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
       "\000\377\000\000\000\377\000\000\000"
       "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\214\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000T\000\000\000"
       "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
       "\000\377\000\000\000\214\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000L\000"
       "\000\000\377\000\000\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
       "\000\377\000\000\000\377\000\000"
       "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\214\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\003\000\000\000\312\000\000\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\360\000\000"
       "\000u\000\000\000t\000\000\000t\000\000\000t\000\000\000t\000\000\000t\000\000\000t\000\000"
       "\000t\000\000\000t\000\000\000?\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000.\000\000\000\372\000\000\000\377\000\000\000"
       "\377\000\000\000\377\000\000\000d\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\204\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\357\000"
       "\000\000\031\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\000"
       "\000\000\327\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000;"
       "\000\000\000\376\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000R\000\000\000"
       "\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\225\000\000"
       "\000\377\000\000\000\377\000\000\000\377\000"
       "\000\000\346\000\000\000\020\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\015"
       "\000\000\000\342\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\233\000\000"
       "\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000K\000\000\000\377"
       "\000\000\000\377\000\000\000\377\000\000\000"
       "\377\000\000\000A\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\246"
       "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\334\000\000\000\011\000\000"
       "\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\025\000\000\000\353\000\000\000"
       "\377\000\000\000\377\000\000\000\377\000"
       "\000\000\212\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\\\000\000"
       "\000\377\000\000\000\377\000\000\000\377\000\000\000\374\000\000\000\062\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\266\000\000\000\377\000"
       "\000\000\377\000\000\000\377\000\000\000\317"
       "\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\036\000\000\000\363"
       "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000x\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000m\000\000\000\377\000\000\000\377\000\000"
       "\000\377\000\000\000\367\000\000\000%\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\011\000\000\000t\000\000\000t\000\000"
       "\000t\000\000\000t\000\000\000t\000\000\000t\000\000\000t\000\000\000t\000\000\000v\000\000"
       "\000\363\000\000\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\300\000\000\000\001\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\024\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
       "\000\377\000\000\000\377\000\000"
       "\000?"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\024\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
       "\377\000\000\000\377\000\000\000"
       "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000H\000\000"
       "\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\024\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\377\000\000\000"
       "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
       "\000\000\377\000\000\000\377"
       "\000\000\000\377\000\000\000\377\000\000\000H\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
       "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000");

}  // namespace Gui

#endif  // GUI_CORNERCROSSLETTERS_H
