// SPDX-License-Identifier: LGPL-2.1-or-later
/****************************************************************************
 *                                                                          *
 *   Copyright (c) 2025 Alfredo Monclus <alfredomonclus@gmail.com>          *
 *                                                                          *
 *   This file is part of FreeCAD.                                          *
 *                                                                          *
 *   FreeCAD is free software: you can redistribute it and/or modify it     *
 *   under the terms of the GNU Lesser General Public License as            *
 *   published by the Free Software Foundation, either version 2.1 of the   *
 *   License, or (at your option) any later version.                        *
 *                                                                          *
 *   FreeCAD is distributed in the hope that it will be useful, but         *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU       *
 *   Lesser General Public License for more details.                        *
 *                                                                          *
 *   You should have received a copy of the GNU Lesser General Public       *
 *   License along with FreeCAD. If not, see                                *
 *   <https://www.gnu.org/licenses/>.                                       *
 *                                                                          *
 ***************************************************************************/

// This custom widget scales an svg according to fonts

#ifndef FONTSCALEDSVG_H
#define FONTSCALEDSVG_H

#include <QWidget>
#include <QSvgRenderer>
#include <QPainter>
#include <QFontMetrics>

#include <FCGlobal.h>

namespace Gui
{

class GuiExport FontScaledSVG: public QWidget
{
    Q_OBJECT

public:
    explicit FontScaledSVG(QWidget* parent = nullptr);
    void setSvg(const QString& svgPath);

protected:
    void paintEvent(QPaintEvent* event) override;
    void resizeEvent(QResizeEvent* event) override;

private:
    QSvgRenderer* m_svgRenderer;

    void updateScaledSize();
};

}  // namespace Gui

#endif  // FONTSCALEDSVG_H
