
# ADR-002: Internal Representation of tool paths

## Status
Legacy

## Context
We require a data structure to hold the computed tool path data. The internal representation will be directly rendered into the 3D scene.
Tool paths may contain hundreds of thousands or even millions of elements so memory utilization should be considered.  The tool paths will be converted into
g-code during post-processing.

## Decision
We will use an abbreviated subset of gcode as the internal representation. The intent is not to support the full range
of RS274 features but to provide enough to capture user intent and to efficiently render the tool paths visually.

The internal representation (Path Commands) resembles gcode but does not support all gcode features.  It differs from gcode in significant ways.


| FreeCAD Path Commands                                                                                | Gcode                                                                 |
| ---                                                                                                  | ---                                                                   |
| always in FreeCAD native units (MM)                                                                  | May be in MM or IN                                                    |
| velocity is represented in units per second                                                          | velocity is represented in units per minute                           |
| absolute coordinates are in the FreeCAD global coordinate system. No other coordinate systems exist. | absolute coordinates are relative to the active coordinate system     |
| gcode command coordinates are always absolute                                                        | gcode coordinates may be either absolute or relative                  |
| no modal commands                                                                                    | some gcodes affect how subsequent gcodes are interpreted              |
| machine agnostic                                                                                     | machine specific                                                      |


# List of currently supported G-code commands
| Command   | Description                                   | Supported Arguments    | Displayed |
| ----      | ----                                          | ----                   | ----      |
| G0, G00   | Rapid move                                    | X,Y,Z,A,B,C            | Red       |
| G1, G01   | Normal interpolated move                      | X,Y,Z,A,B,C            | Green     |
| G2, G02   | Clockwise arc                                 | X,Y,Z,A,B,C,I,J,K      | Green     |
| G3, G03   | Counterclockwise arc                          | X,Y,Z,A,B,C,I,J,K      | Green     |
| G73       | chipbreak drill operation                     | X,Y,Z,R,Q              | Red/Green |
| G74       | left hand tapping operation                   | X,Y,Z,R,Q              | Red/Green |
| G81       | drill operation              | X,Y,Z,R,Q              | Red/Green |
| G82       | drill operation with dwell   | X,Y,Z,R,Q              | Red/Green |
| G83       | drill operation with peck    | X,Y,Z,R,Q              | Red/Green |
| G84       | right hand tapping operation | X,Y,Z,R,Q              | Red/Green |
| G38.2     | Straight probe move (used in probe operation) | Z,F                    | Yellow    |
| M0, M00   | Compulsory stop                               |                        |           |
| M1, M01   | Optional stop                                 |                        |           |
| M3, M03   | Spindle on (clockwise rotation)               | S\<rounds per minute\> |           |
| M4, M04   | Spindle on (counterclockwise rotation)        | S\<rounds per minute\> |           |
| M6, M06   | Tool change                                   | T\<tool number\>       |           |
| (Message) | comment                                       |                        |           |

# Fixtures
FreeCAD Job setup allows operations to be conducted in multiple machine fixtures. Path commands for activating fixtures are supported for:
G54, G55, G56, G57, G58, G59, G59.1 G59.2, G59.3, G59.4, G59.5, G59.6, G59.7, G59.8, G59.9,

# Non-Conforming commands
These commands do not conform to this ADR and are subject to deprecation and should not be used.

| Command | Description                               | Supported Arguments                    |
| ------- | ----------------------------------------- | -------------------------------------- |
| G80     | cancel canned cycle                       |                                        |
| G90     | absolute coordinates                      |                                        |
| G91     | relative coordinates                      |                                        |
| G41     | Tool radius compensation value            | Radius compensation is done in FreeCAD |
| G42     | Tool radius compensation value            | Radius compensation is done in FreeCAD |
| G98     | Return to initial Z level in canned cycle |                                        |
| G99     | Return to R level in canned cycle         |                                        |
| G40     | Cancel tool compensation                  |                                        |
|         |                                           |                                        |

## Consequences

Advantages
- it is human readable
- it is memory efficient
- it is easily converted into final gcode
- it is extensible

Disadvantages
- Gcode is not explicit.  A command contains semantics about where to move the
  cutter *to* but not where it is coming *from*.  Therefore the first move will always appear as a move from the origin
- Directly inspecting the path commands will not reflect either the document
  unit schema or the selected output unit schema.
