
# ADR-007: Add semantic information to Path Command

## Status
DRAFT

## Context
The [Path Command ](https://wiki.freecad.org/CAM_scripting#The_Path_object) is a minimal data structure for representing part of a toolpath. Path Commands within a document object are rendered on the screen as red (rapid) and green (feed) lines indicating where the tool will move.  The Path commands are handed to the post-processing system to be converted into final gcode.  Sets of Path Commands (Paths) may also be manipulated by dressups, helpers, and other processes before post-processing.

In some cases, the Path command does not carry sufficient information for a downstream process to operate effectively or reliably.  For example,

- a Path Command with a Command Name of 'G1' can be interpreted as a feed move where the tool is enaged in the material but it is impossible to tell from this alone whether this is a climb cut or a conventional cut. If a post-processor author needs the information, they are forced to reinterpret the path.
- There is no reliable method for a subsequent process to determine where an entry move begins or ends.
- Feed rate modification may need to know whether the cut is climb/conventional
  or which side of the cutter is engaged in the material.

## Decision

- It should be possible to add meta information to the Path parameters.
- Meta information should be readily distinguishable from regular parameters
- Imported gcode, Custom ops, and legacy operations will not have the meta information.  Thus any processes which uses meta information must be able to operate conservatively without error even if the information isn't found.
- To minimize the impact on storage, it should be expected that the majority of commands are unannotated.

e.g. c1 = Path.Command('G1' X:10 Y:10 F:500 $climb: True, $lead-in: true)


## Consequences
- Gains: Downstream processes should be easier to code with more robust logic
- Costs: Data storage will be increased.
