
# ADR-008: Terminology for heights and depths offsets

## Status
DRAFT

## Context

To properly and safely configure a CAM job and operations, the user must indicate at which height the cutting tool can operate.
There are numerous related concepts and the nomenclature for them is not consistent within the CAM/CNC industry.

Users are often confused by the terminology employed within FreeCAD's CAM workbench and this results in support issues and proposals for change.

This ADR describes the terminology to be used within the CAM workbench and how those concepts should be employed within operations, dressups, and post processors.

There are two types of offsets:

1) Offsets relative to the job origin.
2) Offsets relative to some other reference

## Decision
1) All offsets which are relative to the job origin will use The term 'Height'.
2) All offsets which are relative to some other reference will use the term 'Distance'.
3) The term 'Depth' is now deprecated and should not be used. It should be removed from documentation and task panels as soon as possible.

4) The following offsets are used in many operations. Their definitions are provided here for reference and consistency.  Operations may employ additional offsets as needed.  These additional offsets should follow the same naming style as described here.

### Clearance (Height)

The clearance offset is the height above the job origin at which the cutting tool can safely move laterally at any time.
It is assumed to be above all clamps, stock, model, and other obstacles.
The clearance offset should be consistent across all operations.

All operations will begin with a rapid move to the clearance height followed by a rapid move the X/Y coordinates of the start point.

All operations will end with a rapid move to the clearance height.

### Retract (Height)

The retract offset is the height to which the cutter will move laterally between cutting passes. At the retract height, the cutter is assumed
to be able to move at rapid speed anywhere within the operation's working envelope

### Feed (Distance)

The feed offset is the distance above the cutting pass from which entry moves will begin. The feed distance controls how far away from the material the cutter will begin moving in a feed-rate controlled manner. A rapid move vertically from retract height to the (cutting plane + feed distance) will be assumed safe.

Example: In a pocket operation with multiple step-downs, the cutter will rapid from the retract height to the start depth + feed distance on the first step down.  After the completion of the pass, the cutter will retract to the retract height, rapid to the start point, and then rapid down to begin the next pass.  Presumably height = ((start depth - step down) + feed distance)

### Start (Height)

Start offset is the nominal highest cutting point in the operation.

### Final (Height)

Final offset is the nominal lowest cutting point in the operation.  The actual lowest cutting point may differ from the final offset due to "stock to leave" settings and other configuration options.

## Consequences

Any use of heights and depths nomenclature should be revised at the earliest opportunity.
Wiki and other documentatin should be revised as soon as possible.

Heights and Depths tabs should be consolidated into a single tab.

Unit tests should ensure that all operations begin and end with the correct entry and exit moves.
