# ADR-009: Terminology consistency for "Material Allowance"

## Status
DRAFT

## Context

User's configuring a toolpath operation often want to fine tune how closely the cutter comes to the ideal model.  They may wish to leave behind a small amount of material that can be removed in a secondary operation (deburring, finishing, etc.).  They may also wish to overcut the model to compensate for inaccuracy in the model or tool chain.

The FreeCAD CAM module uses inconsistent and confusing terminology for controls that cause the cutting tool to leave material behind. This ADR defines
these terms and standardizes their usage across the module.

Terms employed with the CNC/CAM community are not consistent and include:

- Material Allowance
- Stock to Leave
- Stock Allowance
- Stock Margin
and others.

## Decision

Within the FreeCAD CAM module, we will use the term "Stock to Leave"

### Modifiers

In any context where the use of the term is ambiguous, we will use the modifier "axial" or "radial" to clarify the meaning.

#### Axial
Refers to material left behind when the cutter is end milling.  For example if the cutter is clearing a pocket with a 0.5mm axial stock to leave, it will leave 0.5mm of material at the bottom of the pocket.

#### Radial
Refers to material left behind when the cutter is side milling.  For example if the cutter is clearing a pocket with a 0.5mm radial stock to leave, it will leave 0.5mm of material on the walls of the pocket.

## Consequences

- Task panels, documentation, tooltips, and translation must be revisited for consistency.
- Inconsistent operations and dressups must be updated to use the new terminology.  This may have backwards compatibility implications.
