# STATUS:

Active

# Why it is a priority

Some core FreeCAD functionalities are implemented in dressups, but these
dressups are too hard for users to discover and configure. Where dressups
provide core functionality, they should be simple and accessible to use.  They
should also provide complete versions of this functionality.

At time of epic creation, dressups are mentioned as "core essentials" in
multiple of the "functionality" sections on the main roadmap README:

- Operation configuration: entry/exit strategies are partly completed by
  the lead in/out and ramp dressups
- Operation configuration: holding tags are completed by the tag dressup

# Scope

This epic is about improving priority features that are provided by dressups.

| In                                                                                     | Out |
| ---                                                                                    | --- |
| Computational performance improvements to the ramp dressup, so users never have to wait a long time for the dressup to run | Add features to the dogbone dressup, which provides niche functionality, not core functionality |
| Implement a task panel UI for the ramp dressup                                         | Improvements to the array dressup. Handling of array-like operations needs a new direction, and incremental improvements to the array dressup will not get us there.   |
| Make it possible to add and configure core dressups from within the operation UI panel |     |
| Add new entrance/exit strategies to the lead in/out dressup                            |     |

# Related Epics
