// SPDX-License-Identifier: LGPL-2.1-or-later

/***************************************************************************
 *   Copyright (c) 2023 David Carter <dcarter@david.carter.ca>             *
 *                                                                         *
 *   This file is part of FreeCAD.                                         *
 *                                                                         *
 *   FreeCAD is free software: you can redistribute it and/or modify it    *
 *   under the terms of the GNU Lesser General Public License as           *
 *   published by the Free Software Foundation, either version 2.1 of the  *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   FreeCAD is distributed in the hope that it will be useful, but        *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with FreeCAD. If not, see                               *
 *   <https://www.gnu.org/licenses/>.                                      *
 *                                                                         *
 **************************************************************************/

#ifndef MATERIAL_PRECOMPILED_H
#define MATERIAL_PRECOMPILED_H

#include <FCConfig.h>

#ifdef FC_OS_WIN32
#include <windows.h>
#endif


// standard
#include <cmath>

// STL
#include <algorithm>
#include <fstream>
#include <map>
#include <memory>
#include <random>
#include <sstream>
#include <string>
#include <vector>

// Qt
#include <QtGlobal>
#include <QDirIterator>
#include <QFileInfo>
#include <QIODevice>
#include <QList>
#include <QMetaType>
#include <QMetaType>
#include <QRegularExpression>
#include <QString>
#include <QTextStream>
#include <QUuid>
#include <QVector>


#endif  // MATERIAL_PRECOMPILED_H
