// SPDX-License-Identifier: LGPL-2.1-or-later

/***************************************************************************
 *   Copyright (c) 2023 David Carter <dcarter@david.carter.ca>             *
 *                                                                         *
 *   This file is part of FreeCAD.                                         *
 *                                                                         *
 *   FreeCAD is free software: you can redistribute it and/or modify it    *
 *   under the terms of the GNU Lesser General Public License as           *
 *   published by the Free Software Foundation, either version 2.1 of the  *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   FreeCAD is distributed in the hope that it will be useful, but        *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with FreeCAD. If not, see                               *
 *   <https://www.gnu.org/licenses/>.                                      *
 *                                                                         *
 **************************************************************************/

#ifndef MATGUI_PRECOMPILED_H
#define MATGUI_PRECOMPILED_H

#include <FCConfig.h>

#ifdef FC_OS_WIN32
#include <windows.h>
#endif


// standard
#include <cmath>
#include <limits>

// STL
#include <algorithm>
#include <map>
#include <sstream>
#include <string>
#include <vector>


// Qt Toolkit
#include <Gui/QtAll.h>

// Inventor includes OpenGL
# include <Gui/InventorAll.h>



#endif  // MATGUI_PRECOMPILED_H
