// SPDX-License-Identifier: LGPL-2.1-or-later

/***************************************************************************
 *   Copyright (c) 2024 Eric Price (CorvusCorax)                           *
 *                      <eric.price[at]tuebingen.mpg.de>                   *
 *                                                                         *
 *   This file is part of FreeCAD.                                         *
 *                                                                         *
 *   FreeCAD is free software: you can redistribute it and/or modify it    *
 *   under the terms of the GNU Lesser General Public License as           *
 *   published by the Free Software Foundation, either version 2.1 of the  *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   FreeCAD is distributed in the hope that it will be useful, but        *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with FreeCAD. If not, see                               *
 *   <https://www.gnu.org/licenses/>.                                      *
 *                                                                         *
 **************************************************************************/

#ifndef PART_FUZZYHELPER_H
#define PART_FUZZYHELPER_H

#include <Mod/Part/PartGlobal.h>
#include <functional>

namespace Part
{

/**
 * @brief The FuzzyHelper provides helper functions to determine fuzzy value for a boolean operation
 */
namespace FuzzyHelper
{
double PartExport getBooleanFuzzy();
void PartExport setBooleanFuzzy(double base);
void PartExport withBooleanFuzzy(double base, std::function<void()> func);
}  // namespace FuzzyHelper

}  // namespace Part

#endif  // PART_FUZZYHELPER_H
