// SPDX-License-Identifier: LGPL-2.1-or-later

/***************************************************************************
 *   Copyright (c) 2024 Werner Mayer <wmayer[at]users.sourceforge.net>     *
 *                                                                         *
 *   This file is part of FreeCAD.                                         *
 *                                                                         *
 *   FreeCAD is free software: you can redistribute it and/or modify it    *
 *   under the terms of the GNU Lesser General Public License as           *
 *   published by the Free Software Foundation, either version 2.1 of the  *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   FreeCAD is distributed in the hope that it will be useful, but        *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with FreeCAD. If not, see                               *
 *   <https://www.gnu.org/licenses/>.                                      *
 *                                                                         *
 **************************************************************************/

#ifndef FREECAD_FLOWLAYOUT_H
#define FREECAD_FLOWLAYOUT_H

#include <QLayout>
#include <QList>
#include <QStyle>

namespace StartGui
{

/*!
 * \brief The FlowLayout class
 * Based on https://forum.qt.io/topic/109408/is-there-a-qt-layout-grid-that-can-dynamically-
 * change-row-and-column-counts-to-best-fit-the-space
 */
class FlowLayout: public QLayout
{
    Q_OBJECT

public:
    explicit FlowLayout(QWidget* parent = nullptr, int margin = -1, int hSpacing = -1, int vSpacing = -1);
    ~FlowLayout() override;

    void addItem(QLayoutItem* item) override;
    int count() const override;
    QLayoutItem* itemAt(int index) const override;
    QLayoutItem* takeAt(int index) override;
    Qt::Orientations expandingDirections() const override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int width) const override;
    void setGeometry(const QRect& rect) override;
    QSize sizeHint() const override;
    QSize minimumSize() const override;

private:
    int horizontalSpacing() const;
    int verticalSpacing() const;
    int smartSpacing(QStyle::PixelMetric pm) const;
    int doLayout(const QRect& rect, bool testOnly) const;

private:
    QList<QLayoutItem*> itemList;
    int hSpace = -1;
    int vSpace = -1;
};

}  // namespace StartGui

#endif  // FREECAD_FLOWLAYOUT_H
