/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunConfigurationConverter;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunProfileStateWithPreparation;
import java.awt.Component;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrBeforeTestRunTaskProvider
extends BeforeRunTaskProvider {
    private static final String BEFORE_TEST_ID = "BeforeTestRunTask";
    public static final Key<BeforeTestRunTask> ID = Key.create((String)"BeforeTestRunTask");
    public static final Key<Content> CONTENT = Key.create((String)"Content");
    public static final Key<ProgressIndicator> PROGRESS = Key.create((String)"ProgressIndicator");
    private static final Key<ConsoleView> CONSOLE_VIEW = Key.create((String)"ConsoleView");

    public Key<BeforeTestRunTask> getId() {
        return ID;
    }

    public String getName() {
        return CidrExecutionBundle.message("test.before.run", new Object[0]);
    }

    public String getDescription(BeforeRunTask task) {
        return CidrExecutionBundle.message("test.before.run.description", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        LayeredIcon layeredIcon = LayeredIcon.layeredIcon(() -> new Icon[]{AllIcons.RunConfigurations.TestState.Run, AllIcons.RunConfigurations.TestMark});
        if (layeredIcon == null) {
            CidrBeforeTestRunTaskProvider.$$$reportNull$$$0(0);
        }
        return layeredIcon;
    }

    public boolean isSingleton() {
        return true;
    }

    public BeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            CidrBeforeTestRunTaskProvider.$$$reportNull$$$0(1);
        }
        if (!CidrBeforeTestRunTaskProvider.configurationNeedBeforeTestRunTask(runConfiguration)) {
            return null;
        }
        return new BeforeTestRunTask();
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull BeforeRunTask task) {
        if (configuration == null) {
            CidrBeforeTestRunTaskProvider.$$$reportNull$$$0(2);
        }
        if (task == null) {
            CidrBeforeTestRunTaskProvider.$$$reportNull$$$0(3);
        }
        return CidrBeforeTestRunTaskProvider.configurationNeedBeforeTestRunTask(configuration);
    }

    private static boolean configurationNeedBeforeTestRunTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            CidrBeforeTestRunTaskProvider.$$$reportNull$$$0(4);
        }
        return runConfiguration instanceof CidrTestRunConfiguration && ((CidrTestRunConfiguration)runConfiguration).getTestData() instanceof CidrTestConfigurationNeedBeforeRunTask;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull BeforeRunTask task) {
        if (context == null) {
            CidrBeforeTestRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            CidrBeforeTestRunTaskProvider.$$$reportNull$$$0(6);
        }
        if (env == null) {
            CidrBeforeTestRunTaskProvider.$$$reportNull$$$0(7);
        }
        if (task == null) {
            CidrBeforeTestRunTaskProvider.$$$reportNull$$$0(8);
        }
        try {
            RunProfileState pureState = Objects.requireNonNull(env.getState());
            if (!(pureState instanceof CidrTestRunProfileStateWithPreparation)) {
                return true;
            }
            CidrTestRunProfileStateWithPreparation state = (CidrTestRunProfileStateWithPreparation)pureState;
            BackgroundableProcessIndicator progress = this.createProgress(configuration);
            ProgressManager.getInstance().runProcess(() -> state.prepareTestExecutionEnvironment((ProgressIndicator)progress), (ProgressIndicator)progress);
            return !progress.isCanceled();
        }
        catch (ProcessCanceledException ignored) {
            return false;
        }
        catch (Throwable e) {
            CidrTestLog.LOG.error(e);
            return false;
        }
    }

    @NotNull
    private BackgroundableProcessIndicator createProgress(final @NotNull RunConfiguration configuration) {
        if (configuration == null) {
            CidrBeforeTestRunTaskProvider.$$$reportNull$$$0(9);
        }
        Ref indicatorRef = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            Project project = configuration.getProject();
            final Content content = this.getContent(project);
            BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(project, new TaskInfo(){

                @NotNull
                public String getTitle() {
                    String string = CidrExecutionBundle.message("test.before.run.progress.title", configuration.getName());
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public String getCancelText() {
                    return CidrExecutionBundle.message("test.stop.run", new Object[0]);
                }

                public String getCancelTooltipText() {
                    return CidrExecutionBundle.message("test.stop.run.description", new Object[0]);
                }

                public boolean isCancellable() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrBeforeTestRunTaskProvider$1", "getTitle"));
                }
            }, PerformInBackgroundOption.ALWAYS_BACKGROUND){
                boolean first;
                {
                    super(arg0, arg1, arg2);
                    this.first = true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void start() {
                    Object object = this.getLock();
                    synchronized (object) {
                        super.start();
                        this.setText(CidrExecutionBundle.message("test.before.run.progress.text", new Object[0]));
                        this.setText2(this.getTitle());
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stop() {
                    Object object = this.getLock();
                    synchronized (object) {
                        this.setText2(CidrExecutionBundle.message(this.isCanceled() ? "test.before.run.canceled" : "test.before.run.finished", new Object[0]));
                        PROGRESS.set((UserDataHolder)content, null);
                        super.stop();
                    }
                }

                public void setText2(@NlsSafe String text) {
                    Object message;
                    super.setText2(text);
                    if (content == null || Disposer.isDisposed((Disposable)content)) {
                        return;
                    }
                    ConsoleView consoleView = (ConsoleView)CONSOLE_VIEW.get((UserDataHolder)content);
                    if (consoleView == null) {
                        return;
                    }
                    if (this.first) {
                        this.first = false;
                        message = text;
                    } else {
                        message = "\n" + text;
                    }
                    ConsoleViewContentType output = ConsoleViewContentType.NORMAL_OUTPUT;
                    if (text.startsWith("Warning:") || text.startsWith("Error:")) {
                        output = ConsoleViewContentType.ERROR_OUTPUT;
                    }
                    consoleView.print((String)message, output);
                }
            };
            CONTENT.set((UserDataHolder)indicator, (Object)content);
            PROGRESS.set((UserDataHolder)content, (Object)indicator);
            indicatorRef.set((Object)indicator);
        });
        BackgroundableProcessIndicator backgroundableProcessIndicator = (BackgroundableProcessIndicator)indicatorRef.get();
        if (backgroundableProcessIndicator == null) {
            CidrBeforeTestRunTaskProvider.$$$reportNull$$$0(10);
        }
        return backgroundableProcessIndicator;
    }

    @Nullable
    private Content getContent(final @NotNull Project project) throws RuntimeException {
        if (project == null) {
            CidrBeforeTestRunTaskProvider.$$$reportNull$$$0(11);
        }
        return (Content)ApplicationManager.getApplication().runWriteAction(() -> {
            ConsoleView consoleView;
            MessageView.getInstance((Project)project);
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
            ToolWindow window = manager.getToolWindow("Messages");
            if (window == null) {
                return null;
            }
            String displayName = this.getName();
            final ContentManager contentManager = window.getContentManager();
            Content content = contentManager.findContent(displayName);
            if (content == null) {
                ConsoleView console = TextConsoleBuilderFactory.getInstance().createBuilder(project, ProjectScope.getProjectScope((Project)project)).getConsole();
                JComponent component = console.getComponent();
                DefaultActionGroup toolbarActions = new DefaultActionGroup();
                ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("Run", (ActionGroup)toolbarActions, false);
                toolbar.setTargetComponent(component);
                component.add((Component)toolbar.getComponent(), "West");
                content = contentManager.getFactory().createContent(component, displayName, true);
                contentManager.addContent(content);
                CONSOLE_VIEW.set((UserDataHolder)content, (Object)console);
                Disposer.register((Disposable)content, (Disposable)console);
                toolbarActions.add((AnAction)new StopAction(content));
                toolbarActions.addSeparator();
                toolbarActions.addAll(console.createConsoleActions());
                final Content fcontent = content;
                contentManager.addContentManagerListener(new ContentManagerListener(){

                    public void contentRemoved(@NotNull ContentManagerEvent event) {
                        if (event == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (event.getContent() != fcontent) {
                            return;
                        }
                        contentManager.removeContentManagerListener((ContentManagerListener)this);
                    }

                    public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
                        if (event == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        if (event.getContent() != fcontent) {
                            return;
                        }
                        ProgressIndicator indicator = (ProgressIndicator)PROGRESS.get((UserDataHolder)fcontent);
                        if (indicator != null && indicator.isRunning()) {
                            int result = Messages.showYesNoDialog((Project)project, (String)CidrExecutionBundle.message("test.before.run.cancelQuestion", new Object[0]), (String)CidrExecutionBundle.message("test.before.run.inProgress", new Object[0]), (Icon)Messages.getQuestionIcon());
                            if (result == 0) {
                                PROGRESS.set((UserDataHolder)fcontent, null);
                                indicator.cancel();
                            } else {
                                event.consume();
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "event";
                        objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrBeforeTestRunTaskProvider$3";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "contentRemoved";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "contentRemoveQuery";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            if (!window.isAvailable()) {
                window.setAvailable(true);
            }
            if (!window.isActive() && Registry.is((String)"cidr.test.framework.activate.test.scan.tab")) {
                window.activate(null);
            }
            if ((consoleView = (ConsoleView)CONSOLE_VIEW.get((UserDataHolder)content)) != null) {
                consoleView.clear();
            }
            contentManager.setSelectedContent(content);
            return content;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrBeforeTestRunTaskProvider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrBeforeTestRunTaskProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgress";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canExecuteTask";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configurationNeedBeforeTestRunTask";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createProgress";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11 -> new IllegalArgumentException(string);
        };
    }

    @ApiStatus.Internal
    public static final class BeforeTestRunTask
    extends BeforeRunTask<BeforeTestRunTask> {
        private BeforeTestRunTask() {
            super(ID);
            this.setEnabled(true);
        }
    }

    public static interface CidrTestConfigurationNeedBeforeRunTask {
    }

    private static final class StopAction
    extends DumbAwareAction {
        @NotNull
        private final Content myContent;

        private StopAction(@NotNull Content content) {
            if (content == null) {
                StopAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.message((String)"action.stop", (Object[])new Object[0]), null, AllIcons.Actions.Suspend);
            this.myContent = content;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ProgressIndicator indicator;
            if (e == null) {
                StopAction.$$$reportNull$$$0(1);
            }
            if ((indicator = (ProgressIndicator)PROGRESS.get((UserDataHolder)this.myContent)) != null) {
                indicator.cancel();
            }
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                StopAction.$$$reportNull$$$0(2);
            }
            ProgressIndicator indicator = (ProgressIndicator)PROGRESS.get((UserDataHolder)this.myContent);
            event.getPresentation().setEnabled(indicator != null && indicator.isRunning());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                StopAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrBeforeTestRunTaskProvider$StopAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrBeforeTestRunTaskProvider$StopAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static interface CidrBeforeRunTaskConverter
    extends RunConfigurationConverter {
        public String getId();

        default public boolean convertRunConfigurationOnDemand(@NotNull Element element) {
            if (element == null) {
                CidrBeforeRunTaskConverter.$$$reportNull$$$0(0);
            }
            if (!this.getId().equals(element.getAttributeValue("type"))) {
                return false;
            }
            Element method = element.getChild("method");
            if (method != null && method.getAttributeValue("v") != null && !ContainerUtil.exists((Iterable)method.getChildren("option"), option -> CidrBeforeTestRunTaskProvider.BEFORE_TEST_ID.equals(option.getAttributeValue("name")))) {
                Element option2 = new Element("option");
                option2.setAttribute("name", CidrBeforeTestRunTaskProvider.BEFORE_TEST_ID);
                option2.setAttribute("enabled", Boolean.TRUE.toString());
                method.addContent(option2);
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/execution/testing/CidrBeforeTestRunTaskProvider$CidrBeforeRunTaskConverter", "convertRunConfigurationOnDemand"));
        }
    }
}

