/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Triple;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CidrTestFrameworkDetector {
    public static final ExtensionPointName<CidrTestFrameworkDetector> EP_NAME = ExtensionPointName.create((String)"cidr.testFrameworkDetector");

    default public boolean hasTestConfiguration(@NotNull CidrBuildTarget<?> target, @NotNull CidrBuildConfigurationHelper<? extends CidrBuildConfiguration, ? extends CidrBuildTarget<?>> helper) {
        if (target == null) {
            CidrTestFrameworkDetector.$$$reportNull$$$0(0);
        }
        if (helper == null) {
            CidrTestFrameworkDetector.$$$reportNull$$$0(1);
        }
        return false;
    }

    @NotNull
    public ConfigurationTypeBase getTestConfigurationType();

    @NotNull
    @RegExp
    public String getTestHeaderName();

    @NotNull
    public Collection<String> getTestMacros();

    @Nullable
    public static ConfigurationTypeBase fastFilterTestSource(@NotNull Collection<File> sources, int maxFilesInSourcesToCheck, int maxHeaderFileContextLengthToCheck, Processor<? super File> testFileProcessor) {
        if (sources == null) {
            CidrTestFrameworkDetector.$$$reportNull$$$0(2);
        }
        LocalFileSystem fs = LocalFileSystem.getInstance();
        List fwDetection = ContainerUtil.map((Collection)EP_NAME.getExtensionList(), detector -> new Triple((Object)Pattern.compile(detector.getTestHeaderName() + "[\">]"), detector.getTestMacros(), (Object)detector.getTestConfigurationType()));
        block2: for (File file : sources) {
            if (--maxFilesInSourcesToCheck < 0) break;
            VirtualFile vf = fs.findFileByIoFile(file);
            if (vf == null) continue;
            try {
                String fullContext = VfsUtilCore.loadText((VirtualFile)vf);
                String content = fullContext.substring(0, Math.min(fullContext.length(), maxHeaderFileContextLengthToCheck));
                for (Triple fwd : fwDetection) {
                    if (!((Pattern)fwd.getFirst()).matcher(content).find()) continue;
                    for (String macroName : (Collection)fwd.getSecond()) {
                        if (!content.contains(macroName)) continue;
                        if (testFileProcessor.process((Object)file)) continue block2;
                        return (ConfigurationTypeBase)fwd.getThird();
                    }
                }
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestFrameworkDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTestConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fastFilterTestSource";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

