/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.jps.entities.SourceRootTypeId;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010!\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/cidr/execution/testing/CidrTestScopeService;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "userDefinedTestScope", "Lcom/intellij/psi/search/scope/packageSet/NamedScope;", "testRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "inAllKnownTestScopes", "Ljava/util/function/Predicate;", "Lcom/intellij/psi/PsiFileSystemItem;", "getTestCandidateChecker", "getTestRoots", "subscribeToScopeChange", "", "listener", "Lcom/jetbrains/cidr/execution/testing/CidrTestScopeService$TestScopeListener;", "lifetime", "Lcom/intellij/openapi/Disposable;", "fireTestScopeChanged", "refreshUserDefinedTestScope", "fireScopeChangedIfNeed", "", "getTestScope", "updateTestScope", "filePattern", "", "refreshTestRootScope", "getRealTestRoots", "getSyntheticTestRoots", "findFolderWithNameAsTestRoot", "TestScopeListener", "Companion", "intellij.cidr.execution"})
@SourceDebugExtension(value={"SMAP\nCidrTestScopeService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrTestScopeService.kt\ncom/jetbrains/cidr/execution/testing/CidrTestScopeService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1310#2,2:230\n3829#2:232\n4344#2,2:233\n37#3:235\n36#3,3:236\n1374#4:239\n1460#4,5:240\n774#4:245\n865#4,2:246\n*S KotlinDebug\n*F\n+ 1 CidrTestScopeService.kt\ncom/jetbrains/cidr/execution/testing/CidrTestScopeService\n*L\n113#1:230,2\n123#1:232\n123#1:233,2\n127#1:235\n127#1:236,3\n169#1:239\n169#1:240,5\n170#1:245\n170#1:246,2\n*E\n"})
public final class CidrTestScopeService
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private NamedScope userDefinedTestScope;
    @NotNull
    private Set<? extends VirtualFile> testRoots;
    @Nullable
    private volatile Predicate<PsiFileSystemItem> inAllKnownTestScopes;
    @NotNull
    public static final String TEST_SCOPE_NAME_ID = "cidr.test.scope.name";
    @NotNull
    public static final String TEST_ROOTS_ONLY_ID = "cidr.test.roots.only";
    @NotNull
    private static final String ALL_PROJECT_FILES_ARE_TEST_ROOTS = "*";
    @NotNull
    private static final Topic<TestScopeListener> TEST_SCOPE_LISTENER_TOPIC = new Topic(TestScopeListener.class);

    public CidrTestScopeService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.testRoots = SetsKt.emptySet();
        this.refreshUserDefinedTestScope(false);
        NamedScopeManager.getInstance((Project)this.project).addScopeListener(() -> CidrTestScopeService._init_$lambda$0(this), (Disposable)this);
        this.refreshTestRootScope(false);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = ModuleRootListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.refreshTestRootScope(true);
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(){

            public void advancedSettingChanged(String id, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                if (Intrinsics.areEqual((Object)id, (Object)CidrTestScopeService.TEST_SCOPE_NAME_ID)) {
                    this.refreshUserDefinedTestScope(true);
                } else if (Intrinsics.areEqual((Object)id, (Object)CidrTestScopeService.TEST_ROOTS_ONLY_ID)) {
                    this.refreshTestRootScope(true);
                }
            }
        });
    }

    @Nullable
    public final Predicate<PsiFileSystemItem> getTestCandidateChecker() {
        return this.inAllKnownTestScopes;
    }

    @NotNull
    public final synchronized Set<VirtualFile> getTestRoots() {
        return new HashSet(this.testRoots);
    }

    public final void subscribeToScopeChange(@NotNull TestScopeListener listener, @NotNull Disposable lifetime) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.project.getMessageBus().connect(lifetime).subscribe(TEST_SCOPE_LISTENER_TOPIC, (Object)listener);
    }

    private final void fireTestScopeChanged() {
        ((TestScopeListener)this.project.getMessageBus().syncPublisher(TEST_SCOPE_LISTENER_TOPIC)).scopeChanged();
    }

    private final synchronized void refreshUserDefinedTestScope(boolean fireScopeChangedIfNeed) {
        NamedScope localScope = this.getTestScope();
        if (fireScopeChangedIfNeed && !Intrinsics.areEqual((Object)localScope, (Object)this.userDefinedTestScope)) {
            this.fireTestScopeChanged();
        }
        this.userDefinedTestScope = localScope;
        Set<? extends VirtualFile> localTestRoots = this.testRoots;
        this.inAllKnownTestScopes = CidrTestScopeService.Companion.getInAllKnownTestScopes(localTestRoots, localScope);
    }

    @Nullable
    public final NamedScope getTestScope() {
        Object object;
        block1: {
            String scopeName = AdvancedSettings.Companion.getString(TEST_SCOPE_NAME_ID);
            NamedScope[] namedScopeArray = NamedScopeManager.getInstance((Project)this.project).getEditableScopes();
            Intrinsics.checkNotNullExpressionValue((Object)namedScopeArray, (String)"getEditableScopes(...)");
            Object[] $this$firstOrNull$iv = namedScopeArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NamedScope it = (NamedScope)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(NamedScope.class, it.getClass()) && Intrinsics.areEqual((Object)scopeName, (Object)it.getScopeId()))) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (NamedScope)object;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTestScope(@Nullable String filePattern) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String scopeName = AdvancedSettings.Companion.getString(TEST_SCOPE_NAME_ID);
        NamedScopeManager namedScopeManager = NamedScopeManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)namedScopeManager, (String)"getInstance(...)");
        NamedScopeManager namedScopeManager2 = namedScopeManager;
        NamedScope newTestScope = new NamedScope(scopeName, namedScopeManager2.getIcon(), null);
        NamedScope[] namedScopeArray = namedScopeManager2.getEditableScopes();
        Intrinsics.checkNotNullExpressionValue((Object)namedScopeArray, (String)"getEditableScopes(...)");
        Object[] objectArray = namedScopeArray;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            NamedScope it = (NamedScope)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getScopeId(), (Object)scopeName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List scopes = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        PackageSet compile = PackageSetFactory.getInstance().compile(filePattern);
        scopes.add(new NamedScope(scopeName, namedScopeManager2.getIcon(), compile));
        Collection $this$toTypedArray$iv = scopes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        namedScopeManager2.setScopes(thisCollection$iv.toArray(new NamedScope[0]));
    }

    private final synchronized void refreshTestRootScope(boolean fireScopeChangedIfNeed) {
        Set<VirtualFile> localTestRoots;
        boolean findTestInTestRootsOnly = AdvancedSettings.Companion.getBoolean(TEST_ROOTS_ONLY_ID);
        String findFolderWithNameAsTestRoot = Registry.Companion.stringValue("cidr.test.root.name");
        Set<VirtualFile> set = !findTestInTestRootsOnly ? SetsKt.emptySet() : (localTestRoots = ((CharSequence)findFolderWithNameAsTestRoot).length() == 0 ? this.getRealTestRoots() : this.getSyntheticTestRoots(findFolderWithNameAsTestRoot));
        if (fireScopeChangedIfNeed && !Intrinsics.areEqual(localTestRoots, this.testRoots)) {
            this.fireTestScopeChanged();
        }
        this.testRoots = localTestRoots;
        NamedScope localScope = this.userDefinedTestScope;
        this.inAllKnownTestScopes = CidrTestScopeService.Companion.getInAllKnownTestScopes(localTestRoots, localScope);
    }

    private final Set<VirtualFile> getRealTestRoots() {
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot().entities(SourceRootEntity.class), CidrTestScopeService::getRealTestRoots$lambda$3), CidrTestScopeService::getRealTestRoots$lambda$4));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<VirtualFile> getSyntheticTestRoots(String findFolderWithNameAsTestRoot) {
        void $this$filterTo$iv$iv;
        VirtualFile it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot().entities(SourceRootEntity.class), CidrTestScopeService::getSyntheticTestRoots$lambda$5), CidrTestScopeService::getSyntheticTestRoots$lambda$6));
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = it;
            Intrinsics.checkNotNull((Object)virtualFile);
            List list = VfsUtil.collectChildrenRecursively((VirtualFile)virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectChildrenRecursively(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(!it.isDirectory() && Intrinsics.areEqual((Object)findFolderWithNameAsTestRoot, (Object)ALL_PROJECT_FILES_ARE_TEST_ROOTS) || it.isDirectory() && Intrinsics.areEqual((Object)findFolderWithNameAsTestRoot, (Object)it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final void _init_$lambda$0(CidrTestScopeService this$0) {
        this$0.refreshUserDefinedTestScope(true);
    }

    private static final boolean getRealTestRoots$lambda$3(SourceRootEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getRootTypeId(), (Object)new SourceRootTypeId("java-test")) && VirtualFileUrls.getVirtualFile((VirtualFileUrl)it.getUrl()) != null;
    }

    private static final VirtualFile getRealTestRoots$lambda$4(SourceRootEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        VirtualFile virtualFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)it.getUrl());
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    private static final VirtualFile getSyntheticTestRoots$lambda$5(SourceRootEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return VirtualFileUrls.getVirtualFile((VirtualFileUrl)it.getContentRoot().getUrl());
    }

    private static final boolean getSyntheticTestRoots$lambda$6(VirtualFile it) {
        return it != null && it.isDirectory();
    }

    @JvmStatic
    @NotNull
    public static final CidrTestScopeService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J(\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/execution/testing/CidrTestScopeService$Companion;", "", "<init>", "()V", "TEST_SCOPE_NAME_ID", "", "TEST_ROOTS_ONLY_ID", "ALL_PROJECT_FILES_ARE_TEST_ROOTS", "TEST_SCOPE_LISTENER_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/jetbrains/cidr/execution/testing/CidrTestScopeService$TestScopeListener;", "kotlin.jvm.PlatformType", "getInstance", "Lcom/jetbrains/cidr/execution/testing/CidrTestScopeService;", "project", "Lcom/intellij/openapi/project/Project;", "getInAllKnownTestScopes", "Ljava/util/function/Predicate;", "Lcom/intellij/psi/PsiFileSystemItem;", "testRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "scope", "Lcom/intellij/psi/search/scope/packageSet/NamedScope;", "intellij.cidr.execution"})
    @SourceDebugExtension(value={"SMAP\nCidrTestScopeService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrTestScopeService.kt\ncom/jetbrains/cidr/execution/testing/CidrTestScopeService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CidrTestScopeService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(CidrTestScopeService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (CidrTestScopeService)object;
        }

        private final Predicate<PsiFileSystemItem> getInAllKnownTestScopes(Set<? extends VirtualFile> testRoots, NamedScope scope) {
            Predicate<PsiFileSystemItem> inTestScope;
            Predicate<PsiFileSystemItem> predicate;
            if (testRoots.isEmpty()) {
                predicate = null;
            } else {
                HashSet<VirtualFile> fileRoots = new HashSet<VirtualFile>();
                HashSet<VirtualFile> dirRoots = new HashSet<VirtualFile>();
                for (VirtualFile virtualFile : testRoots) {
                    boolean bl = virtualFile.isDirectory() ? dirRoots.add(virtualFile) : fileRoots.add(virtualFile);
                }
                predicate = arg_0 -> Companion.getInAllKnownTestScopes$lambda$1(fileRoots, dirRoots, arg_0);
            }
            Predicate<PsiFileSystemItem> inTestRoot = predicate;
            NamedScope namedScope = scope;
            PackageSet packageSet = namedScope != null ? namedScope.getValue() : null;
            Predicate<PsiFileSystemItem> predicate2 = inTestScope = packageSet == null ? null : arg_0 -> Companion.getInAllKnownTestScopes$lambda$2(packageSet, arg_0);
            if (inTestRoot == null) {
                return inTestScope;
            }
            if (inTestScope == null) {
                return inTestRoot;
            }
            return inTestScope.and(inTestRoot);
        }

        private static final boolean getInAllKnownTestScopes$lambda$1(HashSet $fileRoots, HashSet $dirRoots, PsiFileSystemItem psiFileSystemItem) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)psiFileSystemItem, (String)"psiFileSystemItem");
            VirtualFile virtualFile = psiFileSystemItem.getVirtualFile();
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl2 = false;
                bl = $fileRoots.contains(it) || VfsUtilCore.isUnder((VirtualFile)it, (Set)$dirRoots);
            } else {
                bl = false;
            }
            return bl;
        }

        private static final boolean getInAllKnownTestScopes$lambda$2(PackageSet $packageSet, PsiFileSystemItem psiFileSystemItem) {
            Intrinsics.checkNotNullParameter((Object)psiFileSystemItem, (String)"psiFileSystemItem");
            return $packageSet.contains(psiFileSystemItem, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/execution/testing/CidrTestScopeService$TestScopeListener;", "", "scopeChanged", "", "intellij.cidr.execution"})
    public static interface TestScopeListener {
        public void scopeChanged();
    }
}

