/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import org.jetbrains.annotations.NotNull;

public class AbstractBaselineInspection
extends AndroidLintInspectionBase {
    public static boolean ourSkipBaselineNextRun;
    public static boolean ourUpdateBaselineNextRun;

    public AbstractBaselineInspection(@NotNull String displayName, @NotNull Issue issue) {
        super(displayName, issue);
    }

    protected static void rerun() {
        ApplicationManager.getApplication().invokeLater(() -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (Frame frame : Frame.getFrames()) {
                    InspectionResultsView view = AbstractBaselineInspection.findInspectionView(frame);
                    if (view == null || !view.isRerunAvailable() || view.isDisposed()) continue;
                    view.rerun();
                }
            });
        });
    }

    public static void clearNextRunState() {
        ourSkipBaselineNextRun = false;
        ourUpdateBaselineNextRun = false;
    }

    private static InspectionResultsView findInspectionView(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            InspectionResultsView view;
            Component component = container.getComponent(i);
            if (component instanceof InspectionResultsView) {
                return (InspectionResultsView)component;
            }
            if (!(component instanceof Container) || (view = AbstractBaselineInspection.findInspectionView((Container)component)) == null) continue;
            return view;
        }
        return null;
    }
}

