/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeReadOnlyFileProvider;
import com.android.tools.lint.client.api.LintFixPerformer;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/lint/common/LintIdeReadWriteFileProvider;", "Lcom/android/tools/idea/lint/common/LintIdeReadOnlyFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/modcommand/ModPsiUpdater;)V", "createBinaryFile", "", "fileData", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEditFile;", "contents", "", "deleteFile", "intellij.lint"})
public final class LintIdeReadWriteFileProvider
extends LintIdeReadOnlyFileProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final ModPsiUpdater updater;

    public LintIdeReadWriteFileProvider(@NotNull Project project, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        super(project);
        this.project = project;
        this.updater = updater;
    }

    @Override
    public void createBinaryFile(@NotNull LintFixPerformer.PendingEditFile fileData, @NotNull byte[] contents) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        File file = fileData.getFile();
        if (!IntentionPreviewUtils.isIntentionPreviewActive()) {
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            FilesKt.writeBytes((File)file, (byte[])contents);
        }
    }

    @Override
    public void deleteFile(@NotNull LintFixPerformer.PendingEditFile fileData) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
            PsiFile psiFile = (PsiFile)this.updater.getWritable((PsiElement)PhysicalFileSystemUtilsKt.toPsiFile((File)fileData.getFile(), (Project)this.project));
            if (psiFile == null) break block0;
            psiFile.delete();
        }
    }
}

