/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.gradle.project.sync.MeasurementCheckpoint;
import com.android.tools.memory.usage.LightweightHeapTraverse;
import com.android.tools.memory.usage.LightweightHeapTraverseConfig;
import com.android.tools.memory.usage.LightweightTraverseResult;
import com.intellij.util.MemoryDumpHelper;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0002\u001a\b\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"captureSnapshot", "", "outputPath", "", "checkpoint", "Lcom/android/tools/idea/gradle/project/sync/MeasurementCheckpoint;", "analyzeCurrentProcessHeap", "captureHeapHistogramOfCurrentProcess", "execute", "", "kotlin.jvm.PlatformType", "Ljavax/management/MBeanServer;", "name", "getTimestamp", "", "intellij.android.projectSystem.gradle.sync"})
@SourceDebugExtension(value={"SMAP\nMemorySnapshotHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemorySnapshotHelper.kt\ncom/android/tools/idea/gradle/project/sync/MemorySnapshotHelperKt\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,86:1\n29#2,3:87\n29#2,3:90\n*S KotlinDebug\n*F\n+ 1 MemorySnapshotHelper.kt\ncom/android/tools/idea/gradle/project/sync/MemorySnapshotHelperKt\n*L\n41#1:87,3\n54#1:90,3\n*E\n"})
public final class MemorySnapshotHelperKt {
    public static final void captureSnapshot(@NotNull String outputPath, @NotNull MeasurementCheckpoint checkpoint) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)((Object)checkpoint), (String)"checkpoint");
        String name = checkpoint.name();
        try {
            File file = FilesKt.resolve((File)new File(outputPath), (String)("" + MemorySnapshotHelperKt.getTimestamp() + '-' + name + ".hprof"));
            System.out.println((Object)("Capturing memory snapshot at: " + file.getAbsolutePath()));
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            MemoryDumpHelper.captureMemoryDump((String)file.getAbsolutePath());
            long elapsedTime = System.currentTimeMillis() - start$iv;
            System.out.println((Object)("Done in " + elapsedTime));
        }
        catch (Exception e) {
            System.out.println((Object)("Error capturing snapshot:  " + ExceptionsKt.stackTraceToString((Throwable)e)));
        }
    }

    public static final void analyzeCurrentProcessHeap(@NotNull String outputPath, @NotNull MeasurementCheckpoint checkpoint) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)((Object)checkpoint), (String)"checkpoint");
        String name = checkpoint.name();
        System.out.println((Object)("Starting heap traversal for " + name));
        LightweightTraverseResult result = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        result = LightweightHeapTraverse.collectReport((LightweightHeapTraverseConfig)new LightweightHeapTraverseConfig(false, true, true));
        long elapsedTime = System.currentTimeMillis() - start$iv;
        System.out.println((Object)("Heap traversal for " + name + " finished in " + elapsedTime + " milliseconds"));
        StringBuilder stringBuilder = new StringBuilder().append("Heap ").append(name).append(" total size MBs: ");
        LightweightTraverseResult lightweightTraverseResult = result;
        Intrinsics.checkNotNull((Object)lightweightTraverseResult);
        System.out.println((Object)stringBuilder.append(lightweightTraverseResult.getTotalReachableObjectsSizeBytes() >> 20).append(' ').toString());
        System.out.println((Object)("Heap " + name + " total object count: " + result.getTotalReachableObjectsNumber() + ' '));
        File fileTotal = FilesKt.resolve((File)new File(outputPath), (String)("" + MemorySnapshotHelperKt.getTimestamp() + '_' + name + "_total"));
        FilesKt.writeText$default((File)fileTotal, (String)String.valueOf(result.getTotalReachableObjectsSizeBytes()), null, (int)2, null);
        System.out.println((Object)("Heap " + name + " strong size MBs: " + (result.getTotalStrongReferencedObjectsSizeBytes() >> 20) + ' '));
        System.out.println((Object)("Heap " + name + " strong object count: " + result.getTotalStrongReferencedObjectsNumber() + ' '));
        File fileStrong = FilesKt.resolve((File)new File(outputPath), (String)("" + MemorySnapshotHelperKt.getTimestamp() + '_' + name + "_strong"));
        FilesKt.writeText$default((File)fileStrong, (String)String.valueOf(result.getTotalStrongReferencedObjectsSizeBytes()), null, (int)2, null);
    }

    public static final void captureHeapHistogramOfCurrentProcess(@NotNull String outputPath, @NotNull MeasurementCheckpoint checkpoint) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)((Object)checkpoint), (String)"checkpoint");
        String name = checkpoint.name();
        System.out.println((Object)("Recording event " + name));
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Intrinsics.checkNotNull((Object)server);
        String histogram = MemorySnapshotHelperKt.execute(server, "gcClassHistogram").toString();
        File fileHistogram = FilesKt.resolve((File)new File(outputPath), (String)("" + MemorySnapshotHelperKt.getTimestamp() + '_' + name + ".histogram"));
        FilesKt.writeText$default((File)fileHistogram, (String)histogram, null, (int)2, null);
    }

    private static final Object execute(MBeanServer $this$execute, String name) {
        Object[] objectArray = new Object[]{null};
        Object[] objectArray2 = objectArray;
        objectArray = new String[]{String[].class.getName()};
        return $this$execute.invoke(new ObjectName("com.sun.management:type=DiagnosticCommand"), name, objectArray2, (String[])objectArray);
    }

    private static final long getTimestamp() {
        return Instant.now().toEpochMilli();
    }
}

