/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerUtilsKt;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a%\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0002\u001a\u0016\u0010\t\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0002\u001a'\u0010\n\u001a\u0004\u0018\u00010\u00012\u000b\u0010\u000b\u001a\u00070\u0001\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a6\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0015\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002\u001a3\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u000b\u0010\u001d\u001a\u00070\u0001\u00a2\u0006\u0002\b\fH\u0002\u001a.\u0010\u001e\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0016\u0010\u0015\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002\u001a\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002\"\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"findAnyPrefix", "", "prefixes", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "isClang", "", "defines", "", "isCpp", "convertToCanonicalIncludePath", "each", "Lorg/jetbrains/annotations/NonNls;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "workingDirectory", "Ljava/io/File;", "collectDiagnostics", "", "switches", "", "result", "", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Type;", "", "getLevel", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$DiagnosticLevel;", "globallyEnabled", "globallyEnabledAsError", "id", "collectFeatureFlags", "allowResultsWithError", "output", "Lcom/intellij/execution/process/ProcessOutput;", "ADDITIONAL_COMPILER_FEATURES", "", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature;", "skipEnvironment", "CLANG_TEST_MACROS", "GCC_BUILT_IN_VA_FUNCTION_MACROS", "GCC_BUILT_IN_FUNCTION_MACROS", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nGCCCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,970:1\n1#2:971\n1761#3,3:972\n1761#3,3:975\n216#4,2:978\n*S KotlinDebug\n*F\n+ 1 GCCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerKt\n*L\n838#1:972,3\n842#1:975,3\n900#1:978,2\n*E\n"})
public final class GCCCompilerKt {
    @NotNull
    private static final Map<String, OCCompilerFeatures.Feature> ADDITIONAL_COMPILER_FEATURES;
    @NotNull
    private static final Set<String> skipEnvironment;
    @NotNull
    private static final List<String> CLANG_TEST_MACROS;
    @NotNull
    private static final List<String> GCC_BUILT_IN_VA_FUNCTION_MACROS;
    @NotNull
    private static final List<String> GCC_BUILT_IN_FUNCTION_MACROS;

    private static final String findAnyPrefix(String $this$findAnyPrefix, String ... prefixes) {
        String string;
        String string2;
        block2: {
            String[] stringArray = prefixes;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string3;
                String it = string3 = stringArray[i];
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)$this$findAnyPrefix, (String)it, (boolean)false, (int)2, null)) continue;
                string2 = string3;
                break block2;
            }
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    private static final boolean isClang(List<String> defines) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = defines;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String define = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringUtil.contains((CharSequence)define, (CharSequence)"__clang_version__")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isCpp(List<String> defines) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = defines;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String define = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringUtil.contains((CharSequence)define, (CharSequence)"__cplusplus")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String convertToCanonicalIncludePath(String each, CidrToolEnvironment environment, File workingDirectory) {
        String string = environment.toLocalPath(workingDirectory, each);
        if (string == null) {
            return null;
        }
        String file = string;
        String[] stringArray = environment.getHostMachine().toCanonicalPath(CollectionsKt.listOf((Object)file), true);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toCanonicalPath(...)");
        String[] canonicalPath = stringArray;
        if (canonicalPath.length == 0) {
            return null;
        }
        try {
            return FileUtil.resolveShortWindowsName((String)canonicalPath[0]);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static final void collectDiagnostics(Set<String> switches, boolean isClang, Map<OCCompilerFeatures.Type<?>, Object> result) {
        if (switches.contains("-w")) {
            return;
        }
        boolean everythingEnabled = switches.contains("-Weverything");
        boolean allWarningsEnabled = everythingEnabled || switches.contains("-Wall");
        boolean pedanticAsErrors = switches.contains("-pedantic-errors");
        boolean pedanticEnabled = everythingEnabled || pedanticAsErrors || switches.contains("-pedantic") || switches.contains("-Wpedantic");
        boolean warningsAsErrors = switches.contains("-Werror");
        result.put(OCCompilerFeatures.Diagnostic.MISSING_RETURN_FROM_NON_VOID, (Object)GCCCompilerKt.getLevel(switches, isClang || allWarningsEnabled, warningsAsErrors, "return-type"));
        if (isClang) {
            result.put(OCCompilerFeatures.Diagnostic.FOLDING_CONSTANT, (Object)GCCCompilerKt.getLevel(switches, pedanticEnabled, pedanticAsErrors, "gnu-folding-constant"));
        }
    }

    private static final OCCompilerFeatures.DiagnosticLevel getLevel(Set<String> switches, boolean globallyEnabled, boolean globallyEnabledAsError, String id) {
        return globallyEnabled && globallyEnabledAsError || switches.contains("-Werror=" + id) ? OCCompilerFeatures.DiagnosticLevel.ERROR : (globallyEnabled || switches.contains("-W" + id) ? OCCompilerFeatures.DiagnosticLevel.WARNING : OCCompilerFeatures.DiagnosticLevel.DISABLED);
    }

    private static final void collectFeatureFlags(Set<String> switches, Map<OCCompilerFeatures.Type<?>, Object> result) {
        Map<String, OCCompilerFeatures.Feature> $this$forEach$iv = ADDITIONAL_COMPILER_FEATURES;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, OCCompilerFeatures.Feature>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, OCCompilerFeatures.Feature> element$iv;
            Map.Entry<String, OCCompilerFeatures.Feature> entry = element$iv = iterator.next();
            boolean bl = false;
            String flag = entry.getKey();
            OCCompilerFeatures.Feature feature = entry.getValue();
            String positive = "-f" + flag;
            String negative = "-fno-" + flag;
            if (switches.contains(positive)) {
                result.put(feature, true);
                continue;
            }
            if (!switches.contains(negative)) continue;
            result.put(feature, false);
        }
    }

    private static final boolean allowResultsWithError(ProcessOutput output) {
        return PluginUtils.hasAppCode() && output.getExitCode() == 1;
    }

    public static final /* synthetic */ List access$getCLANG_TEST_MACROS$p() {
        return CLANG_TEST_MACROS;
    }

    public static final /* synthetic */ List access$getGCC_BUILT_IN_FUNCTION_MACROS$p() {
        return GCC_BUILT_IN_FUNCTION_MACROS;
    }

    public static final /* synthetic */ String access$convertToCanonicalIncludePath(String each, CidrToolEnvironment environment, File workingDirectory) {
        return GCCCompilerKt.convertToCanonicalIncludePath(each, environment, workingDirectory);
    }

    public static final /* synthetic */ boolean access$isClang(List defines) {
        return GCCCompilerKt.isClang(defines);
    }

    public static final /* synthetic */ void access$collectDiagnostics(Set switches, boolean isClang, Map result) {
        GCCCompilerKt.collectDiagnostics(switches, isClang, result);
    }

    public static final /* synthetic */ void access$collectFeatureFlags(Set switches, Map result) {
        GCCCompilerKt.collectFeatureFlags(switches, result);
    }

    public static final /* synthetic */ boolean access$isCpp(List defines) {
        return GCCCompilerKt.isCpp(defines);
    }

    public static final /* synthetic */ Set access$getSkipEnvironment$p() {
        return skipEnvironment;
    }

    public static final /* synthetic */ boolean access$allowResultsWithError(ProcessOutput output) {
        return GCCCompilerKt.allowResultsWithError(output);
    }

    public static final /* synthetic */ String access$findAnyPrefix(String $receiver, String ... prefixes) {
        return GCCCompilerKt.findAnyPrefix($receiver, prefixes);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"ms-extensions", (Object)OCCompilerFeatures.Feature.MS_EXTENSIONS), TuplesKt.to((Object)"ms-compatibility", (Object)OCCompilerFeatures.Feature.MS_EXTENSIONS), TuplesKt.to((Object)"operator-names", (Object)OCCompilerFeatures.Feature.CXX_ALTERNATIVE_OPERATORS)};
        ADDITIONAL_COMPILER_FEATURES = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"DEPENDENCIES_OUTPUT", "SUNPRO_DEPENDENCIES"};
        skipEnvironment = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"#define __has_feature(X) " + GCCCompilerUtilsKt.clangFeatureMacro("##X"), "#define __has_extension(X) " + GCCCompilerUtilsKt.clangExtensionMacro("##X"), "#define __has_attribute(X) " + GCCCompilerUtilsKt.clangAttributeMacro("##X"), "#define __has_builtin(X) " + GCCCompilerUtilsKt.clangBuiltinMacro("##X"), "#define __is_target_arch(X) " + GCCCompilerUtilsKt.clangTargetArchMacro("##X"), "#define __is_target_vendor(X) " + GCCCompilerUtilsKt.clangTargetVendorMacro("##X"), "#define __is_target_os(X) " + GCCCompilerUtilsKt.clangTargetOsMacro("##X"), "#define __is_target_environment(X) " + GCCCompilerUtilsKt.clangTargetEnvironmentMacro("##X"), "#define __is_target_variant_os(X) " + GCCCompilerUtilsKt.clangTargetVariantOsMacro("##X"), "#define __is_target_variant_environment(X) " + GCCCompilerUtilsKt.clangTargetVariantEnvironmentMacro("##X")};
        CLANG_TEST_MACROS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"#define __builtin_va_start(list, paramN) ((void)(list = sizeof(paramN)))", "#define __builtin_va_arg(list, type) ((type)list)", "#define __builtin_va_end(list) ((void)list)", "#define __builtin_va_copy(dest, src) ((void)(dest = src))"};
        GCC_BUILT_IN_VA_FUNCTION_MACROS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"#define __builtin_offsetof(type, member) ((size_t)(&(((type *)0)->member)))", "#define __builtin_types_compatible_p(X,Y) 1", "#define __builtin_choose_expr(C,T,E) T"};
        GCC_BUILT_IN_FUNCTION_MACROS = CollectionsKt.plus((Collection)GCC_BUILT_IN_VA_FUNCTION_MACROS, (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }
}

